/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.component;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.faces.component.ComponentUtil_;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.FacesListener;
import javax.faces.event.PhaseId;
import javax.faces.internal.ComponentStates;
import javax.faces.internal.NamingContainerUtil;
import javax.faces.internal.UIDataUtil;
import javax.faces.model.DataModel;
import org.seasar.framework.util.AssertionUtil;

public class UIData
extends UIComponentBase
implements NamingContainer {
    public static final String COMPONENT_FAMILY = "javax.faces.Data";
    public static final String COMPONENT_TYPE = "javax.faces.Data";
    private static final String FOOTER_FACET_NAME = "footer";
    private static final String HEADER_FACET_NAME = "header";
    private static final String FIRST_BINDING_NAME = "first";
    private static final String VALUE_BINDING_NAME = "value";
    private static final String ROWS_BINDING_NAME = "rows";
    private int first = 0;
    private int rowIndex = 0;
    private int rows = 0;
    private boolean firstSet = false;
    private boolean rowsSet = false;
    private transient DataModel model = null;
    private Object value = null;
    private String var = null;
    private ComponentStates componentStates = new ComponentStates();
    private static final String DEFAULT_RENDER_TYPE = "javax.faces.Table";

    public UIData() {
        this.setRendererType(DEFAULT_RENDER_TYPE);
    }

    public String getFamily() {
        return "javax.faces.Data";
    }

    public void setId(String id) {
        super.setId(id);
        NamingContainerUtil.refreshDescendantComponentClientId(this);
    }

    public int getFirst() {
        if (this.firstSet) {
            return this.first;
        }
        Integer firstValue = (Integer)ComponentUtil_.getValueBindingValue(this, FIRST_BINDING_NAME);
        return firstValue != null ? firstValue : this.first;
    }

    public void setFirst(int first) {
        AssertionUtil.assertIntegerNotNegative((String)FIRST_BINDING_NAME, (int)first);
        this.first = first;
        this.firstSet = true;
    }

    public UIComponent getFooter() {
        return this.getFacet(FOOTER_FACET_NAME);
    }

    public void setFooter(UIComponent footer) {
        AssertionUtil.assertNotNull((String)FOOTER_FACET_NAME, (Object)footer);
        this.getFacets().put(FOOTER_FACET_NAME, footer);
    }

    public UIComponent getHeader() {
        return this.getFacet(HEADER_FACET_NAME);
    }

    public void setHeader(UIComponent header) {
        AssertionUtil.assertNotNull((String)HEADER_FACET_NAME, (Object)header);
        this.getFacets().put(HEADER_FACET_NAME, header);
    }

    public boolean isRowAvailable() {
        return this.getDataModel().isRowAvailable();
    }

    public int getRowCount() {
        return this.getDataModel().getRowCount();
    }

    public Object getRowData() {
        return this.getDataModel().getRowData();
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public void setRowIndex(int rowIndex) {
        this.saveDescendantState();
        this.rowIndex = rowIndex;
        DataModel model = this.getDataModel();
        model.setRowIndex(rowIndex);
        String var = this.getVar();
        if (var != null) {
            Map requestMap = this.getFacesContext().getExternalContext().getRequestMap();
            if (rowIndex == -1) {
                requestMap.remove(var);
            } else if (this.isRowAvailable()) {
                requestMap.put(var, this.getRowData());
            } else {
                requestMap.remove(var);
            }
        }
        this.restoreDescendantState();
    }

    public int getRows() {
        if (this.rowsSet) {
            return this.rows;
        }
        Integer value = (Integer)ComponentUtil_.getValueBindingValue(this, ROWS_BINDING_NAME);
        return value != null ? value : this.rows;
    }

    public void setRows(int rows) {
        AssertionUtil.assertIntegerNotNegative((String)ROWS_BINDING_NAME, (int)rows);
        this.rows = rows;
        this.rowsSet = true;
    }

    public String getVar() {
        return this.var;
    }

    public void setVar(String var) {
        this.var = var;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.first = (Integer)values[1];
        this.firstSet = (Boolean)values[2];
        this.rowIndex = (Integer)values[3];
        this.rows = (Integer)values[4];
        this.rowsSet = (Boolean)values[5];
        this.value = values[6];
        this.var = (String)values[7];
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), new Integer(this.first), this.firstSet ? Boolean.TRUE : Boolean.FALSE, new Integer(this.rowIndex), new Integer(this.rows), this.rowsSet ? Boolean.TRUE : Boolean.FALSE, this.value, this.var};
        return values;
    }

    public Object getValue() {
        if (this.value != null) {
            return this.value;
        }
        return ComponentUtil_.getValueBindingValue(this, VALUE_BINDING_NAME);
    }

    public void setValue(Object value) {
        this.value = value;
        this.model = null;
    }

    public void setValueBinding(String name, ValueBinding vb) {
        AssertionUtil.assertNotNull((String)"name", (Object)name);
        if (name.equals("var") || name.equals("rowIndex")) {
            throw new IllegalArgumentException("setValueBinding");
        }
        if (name.equals(VALUE_BINDING_NAME)) {
            this.model = null;
        }
        super.setValueBinding(name, vb);
    }

    public String getClientId(FacesContext context) {
        AssertionUtil.assertNotNull((String)"context", (Object)context);
        String clientId = super.getClientId(context);
        if (this.rowIndex >= 0) {
            clientId = clientId + ':' + this.rowIndex;
        }
        return clientId;
    }

    public void queueEvent(FacesEvent event) {
        AssertionUtil.assertNotNull((String)"event", (Object)event);
        super.queueEvent(new FacesEventWrapper(event, this.getRowIndex(), this));
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        AssertionUtil.assertNotNull((String)"event", (Object)event);
        if (!(event instanceof FacesEventWrapper)) {
            super.broadcast(event);
            return;
        }
        FacesEventWrapper e = (FacesEventWrapper)event;
        int rowIndex = this.getRowIndex();
        this.setRowIndex(e.getRowIndex());
        FacesEvent orgEvent = e.getFacesEvent();
        orgEvent.getComponent().broadcast(orgEvent);
        this.setRowIndex(rowIndex);
    }

    public void encodeBegin(FacesContext context) throws IOException {
        AssertionUtil.assertNotNull((String)"context", (Object)context);
        this.resetModelAndSavedState();
        super.encodeBegin(context);
    }

    public void processDecodes(FacesContext context) {
        AssertionUtil.assertNotNull((String)"context", (Object)context);
        if (!this.isRendered()) {
            return;
        }
        this.processAppropriateAction(context, PhaseId.APPLY_REQUEST_VALUES);
        try {
            this.decode(context);
        }
        catch (RuntimeException e) {
            context.renderResponse();
            throw e;
        }
    }

    public void processUpdates(FacesContext context) {
        AssertionUtil.assertNotNull((String)"context", (Object)context);
        if (!this.isRendered()) {
            return;
        }
        this.processAppropriateAction(context, PhaseId.UPDATE_MODEL_VALUES);
        this.resetModelAndSavedState();
    }

    public void processValidators(FacesContext context) {
        AssertionUtil.assertNotNull((String)"context", (Object)context);
        if (!this.isRendered()) {
            return;
        }
        this.processAppropriateAction(context, PhaseId.PROCESS_VALIDATIONS);
    }

    protected void processAppropriateAction(FacesContext context, PhaseId phaseId) {
        this.processFacets(context, phaseId);
        this.processColumns(context, phaseId);
        this.processColumnsChildren(context, phaseId);
    }

    protected void processFacets(FacesContext context, PhaseId phaseId) {
        this.setRowIndex(-1);
        Iterator facets = this.getFacets().keySet().iterator();
        while (facets.hasNext()) {
            UIComponent facet = (UIComponent)this.getFacets().get(facets.next());
            ComponentUtil_.processAppropriatePhaseAction(context, facet, phaseId);
        }
    }

    protected void processColumns(FacesContext context, PhaseId phaseId) {
        this.setRowIndex(-1);
        Iterator columns = this.getChildren().iterator();
        while (columns.hasNext()) {
            UIComponent column = (UIComponent)columns.next();
            if (!(column instanceof UIColumn) || !column.isRendered()) continue;
            Iterator columnFacets = column.getFacets().keySet().iterator();
            while (columnFacets.hasNext()) {
                UIComponent columnFacet = (UIComponent)column.getFacets().get(columnFacets.next());
                ComponentUtil_.processAppropriatePhaseAction(context, columnFacet, phaseId);
            }
        }
    }

    protected void processColumnsChildren(FacesContext context, PhaseId phaseId) {
        int first = this.getFirst();
        int rows = this.getRows();
        int last = rows != 0 ? first + rows : this.getRowCount();
        for (int rowIndex = first; rowIndex < last; ++rowIndex) {
            this.setRowIndex(rowIndex);
            if (!this.isRowAvailable()) continue;
            Iterator children = this.getChildren().iterator();
            while (children.hasNext()) {
                UIComponent child = (UIComponent)children.next();
                if (!(child instanceof UIColumn)) continue;
                Iterator grandChildren = child.getChildren().iterator();
                while (grandChildren.hasNext()) {
                    UIComponent grandChild = (UIComponent)grandChildren.next();
                    if (!grandChild.isRendered()) continue;
                    ComponentUtil_.processAppropriatePhaseAction(context, grandChild, phaseId);
                }
            }
        }
        this.setRowIndex(-1);
    }

    protected void saveDescendantState() {
        FacesContext context = this.getFacesContext();
        Iterator itr = this.getChildren().iterator();
        while (itr.hasNext()) {
            UIComponent child = (UIComponent)itr.next();
            if (!(child instanceof UIColumn)) continue;
            this.saveDescendantState(child, context);
        }
    }

    protected void saveDescendantState(UIComponent component, FacesContext context) {
        this.componentStates.saveDescendantComponentStates(context, component);
    }

    protected void restoreDescendantState() {
        FacesContext context = this.getFacesContext();
        Iterator itr = this.getChildren().iterator();
        while (itr.hasNext()) {
            UIComponent child = (UIComponent)itr.next();
            if (!(child instanceof UIColumn)) continue;
            this.restoreDescendantState(child, context);
        }
    }

    protected void restoreDescendantState(UIComponent component, FacesContext context) {
        this.componentStates.restoreDescendantState(context, component);
    }

    protected DataModel getDataModel() {
        if (this.model != null) {
            return this.model;
        }
        this.model = UIDataUtil.getSuitableDataModel(this.getValue());
        return this.model;
    }

    private void resetModelAndSavedState() {
        this.model = null;
        this.componentStates.clear();
    }

    static class FacesEventWrapper
    extends FacesEvent {
        private static final long serialVersionUID = 1L;
        private FacesEvent event_ = null;
        private int index_ = -1;

        public FacesEventWrapper(FacesEvent event, int index, UIComponent component) {
            super(component);
            this.event_ = event;
            this.index_ = index;
        }

        public FacesEvent getFacesEvent() {
            return this.event_;
        }

        public int getRowIndex() {
            return this.index_;
        }

        public PhaseId getPhaseId() {
            return this.event_.getPhaseId();
        }

        public void setPhaseId(PhaseId phaseId) {
            this.event_.setPhaseId(phaseId);
        }

        public boolean isAppropriateListener(FacesListener listener) {
            return this.event_.isAppropriateListener(listener);
        }

        public void processListener(FacesListener listener) {
            this.event_.processListener(listener);
        }

        public void queue() {
            this.event_.queue();
        }
    }
}

