/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.render;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.seasar.framework.log.Logger;
import org.seasar.teeda.core.render.AbstractRenderer;
import org.seasar.teeda.core.util.PostbackUtil;
import org.seasar.teeda.core.util.RendererUtil;
import org.seasar.teeda.extension.component.TViewRoot;
import org.seasar.teeda.extension.html.HtmlComponentInvoker;
import org.seasar.teeda.extension.render.IncludedBody;
import org.seasar.teeda.extension.render.Invokable;
import org.seasar.teeda.extension.util.LayoutBuilder;

public class TViewRootRenderer
extends AbstractRenderer
implements Invokable {
    public static final String COMPONENT_FAMILY = "javax.faces.ViewRoot";
    public static final String RENDERER_TYPE = "org.seasar.teeda.extension.ViewRoot";
    private static final Logger logger = Logger.getLogger((Class)TViewRootRenderer.class);
    private HtmlComponentInvoker htmlComponentInvoker;

    public void decode(FacesContext context, UIComponent component) {
        super.decode(context, component);
        Iterator i = component.getChildren().iterator();
        while (i.hasNext()) {
            UIComponent child = (UIComponent)i.next();
            child.processDecodes(context);
        }
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        super.encodeBegin(context, component);
        this.invokeAll(context);
        TViewRoot viewRoot = (TViewRoot)component;
        this.invoke(context, viewRoot.getRootViewId());
        if (!context.getResponseComplete()) {
            RendererUtil.renderChildren((FacesContext)context, (UIComponent)component);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        super.encodeEnd(context, component);
    }

    public void invokeAll(FacesContext context) {
        List bodies = LayoutBuilder.getIncludedBodies(context);
        if (bodies == null) {
            return;
        }
        for (int i = 0; i < bodies.size(); ++i) {
            IncludedBody body = (IncludedBody)bodies.get(i);
            this.invoke(context, body.getViewId());
        }
    }

    public void invoke(FacesContext context, String viewId) {
        String componentName;
        ExternalContext externalContext = context.getExternalContext();
        Map requestMap = externalContext.getRequestMap();
        if (!PostbackUtil.isPostback((Map)requestMap) && (componentName = this.htmlComponentInvoker.getComponentName(viewId, "initialize")) != null) {
            this.htmlComponentInvoker.invokeInitialize(context, componentName);
        }
        if (context.getResponseComplete()) {
            return;
        }
        componentName = this.htmlComponentInvoker.getComponentName(viewId, "prerender");
        if (componentName != null) {
            this.htmlComponentInvoker.invokePrerender(context, componentName);
        }
    }

    public HtmlComponentInvoker getHtmlComponentInvoker() {
        return this.htmlComponentInvoker;
    }

    public void setHtmlComponentInvoker(HtmlComponentInvoker htmlComponentInvoker) {
        this.htmlComponentInvoker = htmlComponentInvoker;
    }
}

