/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.seasar.framework.util.DecimalFormatUtil;
import org.seasar.framework.util.StringUtil;

public class ByteConversionUtil {
    protected ByteConversionUtil() {
    }

    public static Byte toByte(Object o) {
        return ByteConversionUtil.toByte(o, null);
    }

    public static Byte toByte(Object o, String pattern) {
        if (o == null) {
            return null;
        }
        if (o instanceof Byte) {
            return (Byte)o;
        }
        if (o instanceof Number) {
            return new Byte(((Number)o).byteValue());
        }
        if (o instanceof String) {
            return ByteConversionUtil.toByte((String)o);
        }
        if (o instanceof Date) {
            if (pattern != null) {
                return new Byte(new SimpleDateFormat(pattern).format(o));
            }
            return new Byte((byte)((Date)o).getTime());
        }
        if (o instanceof Boolean) {
            return (Boolean)o != false ? new Byte(1) : new Byte(0);
        }
        return ByteConversionUtil.toByte(o.toString());
    }

    private static Byte toByte(String s) {
        if (StringUtil.isEmpty(s)) {
            return null;
        }
        return new Byte(DecimalFormatUtil.normalize(s));
    }

    public static byte toPrimitiveByte(Object o) {
        return ByteConversionUtil.toPrimitiveByte(o, null);
    }

    public static byte toPrimitiveByte(Object o, String pattern) {
        if (o == null) {
            return 0;
        }
        if (o instanceof Number) {
            return ((Number)o).byteValue();
        }
        if (o instanceof String) {
            return ByteConversionUtil.toPrimitiveByte((String)o);
        }
        if (o instanceof Date) {
            if (pattern != null) {
                return Byte.parseByte(new SimpleDateFormat(pattern).format(o));
            }
            return (byte)((Date)o).getTime();
        }
        if (o instanceof Boolean) {
            return (Boolean)o != false ? (byte)1 : 0;
        }
        return ByteConversionUtil.toPrimitiveByte(o.toString());
    }

    private static byte toPrimitiveByte(String s) {
        if (StringUtil.isEmpty(s)) {
            return 0;
        }
        return Byte.parseByte(DecimalFormatUtil.normalize(s));
    }
}

