/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.render.html;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.internal.FacesMessageUtil;
import org.seasar.framework.util.AssertionUtil;
import org.seasar.framework.util.StringUtil;
import org.seasar.teeda.core.render.html.HtmlSelectOneMenuRenderer;
import org.seasar.teeda.core.util.RendererUtil;
import org.seasar.teeda.extension.component.html.THtmlSelectOneMenu;

public class THtmlSelectOneMenuRenderer
extends HtmlSelectOneMenuRenderer {
    public static final String COMPONENT_FAMILY = "javax.faces.SelectOne";
    public static final String RENDERER_TYPE = "org.seasar.teeda.extension.HtmlSelectOneMenu";

    public THtmlSelectOneMenuRenderer() {
        this.addIgnoreAttributeName("pageName");
        this.addIgnoreAttributeName("labelName");
        this.addIgnoreAttributeName("errorStyleClass");
    }

    protected void renderSize(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        THtmlSelectOneMenu c = (THtmlSelectOneMenu)component;
        RendererUtil.renderAttribute((ResponseWriter)writer, (String)"size", (Object)String.valueOf(c.getSize()));
    }

    protected void renderStyleClass(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        this.colorErrorComponent(context, (UIInput)component);
    }

    protected void colorErrorComponent(FacesContext context, UIInput input) throws IOException {
        AssertionUtil.assertNotNull((String)"context", (Object)context);
        THtmlSelectOneMenu selectOneMenu = (THtmlSelectOneMenu)input;
        ResponseWriter writer = context.getResponseWriter();
        String clientId = selectOneMenu.getClientId(context);
        String styleClass = selectOneMenu.getStyleClass();
        if (FacesMessageUtil.hasMessagesByClientId((FacesContext)context, (String)clientId) || this.containsClientId(context, clientId)) {
            String errorCss = selectOneMenu.getErrorStyleClass();
            if (StringUtil.isEmpty((String)errorCss)) {
                return;
            }
            if (styleClass != null && styleClass.indexOf(errorCss) >= 0) {
                return;
            }
            styleClass = styleClass != null ? styleClass + " " + errorCss : errorCss;
        }
        RendererUtil.renderAttribute((ResponseWriter)writer, (String)"styleClass", (Object)styleClass);
    }

    protected boolean containsClientId(FacesContext context, String clientId) {
        ExternalContext externalContext = context.getExternalContext();
        Map requestMap = externalContext.getRequestMap();
        Set clientIds = (Set)requestMap.get("org.seasar.teeda.extension.message.clientids");
        return clientIds != null && clientIds.contains(clientId);
    }
}

