/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.managedbean.impl;

import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.DestroyMethodDef;
import org.seasar.framework.container.InitMethodDef;
import org.seasar.framework.container.InstanceDef;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.impl.ComponentDefImpl;
import org.seasar.framework.container.impl.DestroyMethodDefImpl;
import org.seasar.framework.container.impl.InitMethodDefImpl;
import org.seasar.teeda.core.managedbean.ManagedBeanFactory;
import org.seasar.teeda.core.managedbean.ManagedBeanScopeSaver;
import org.seasar.teeda.core.scope.Scope;
import org.seasar.teeda.core.scope.ScopeManager;

public class ManagedBeanFactoryImpl
implements ManagedBeanFactory {
    private ManagedBeanScopeSaver managedBeanScopeSaver;
    private ScopeManager scopeManager;
    private S2Container container;

    public Object getManagedBean(String name) {
        if (this.container.hasComponentDef((Object)name)) {
            return this.container.getComponent((Object)name);
        }
        return null;
    }

    public void registerManagedBean(String name, Class type, Scope scope) {
        ComponentDefImpl componentDef = new ComponentDefImpl(type, name);
        this.registerManagedBean((ComponentDef)componentDef, scope);
    }

    public void registerManagedBean(String name, Class type, Scope scope, String initMethodName, String destroyMethodName) {
        ComponentDefImpl componentDef = new ComponentDefImpl(type, name);
        componentDef.addInitMethodDef((InitMethodDef)new InitMethodDefImpl(initMethodName));
        componentDef.addDestroyMethodDef((DestroyMethodDef)new DestroyMethodDefImpl(destroyMethodName));
        this.registerManagedBean((ComponentDef)componentDef, scope);
    }

    public void registerManagedBean(ComponentDef componentDef, Scope scope) {
        this.setManagedBean(this.container, componentDef, scope);
    }

    protected void setManagedBean(S2Container container, ComponentDef componentDef, Scope scope) {
        this.setInstanceTypeFor(componentDef, scope);
        container.register(componentDef);
    }

    public Scope getManagedBeanScope(String name) {
        Scope scope = null;
        if (this.container.hasComponentDef((Object)name)) {
            InstanceDef instanceDef = this.container.getComponentDef((Object)name).getInstanceDef();
            scope = this.scopeManager.getScopeTranslator().toScope(instanceDef);
        }
        return scope;
    }

    public void setScopeManager(ScopeManager scopeManager) {
        this.scopeManager = scopeManager;
    }

    public ScopeManager getScopeManager() {
        return this.scopeManager;
    }

    public void setManagedBeanScopeSaver(ManagedBeanScopeSaver managedBeanScopeSaver) {
        this.managedBeanScopeSaver = managedBeanScopeSaver;
    }

    public ManagedBeanScopeSaver getManagedBeanScopeSaver() {
        return this.managedBeanScopeSaver;
    }

    public S2Container getContainer() {
        return this.container;
    }

    public void setContainer(S2Container container) {
        this.container = container;
        if (container != null) {
            this.container = container.getRoot();
        }
    }

    private void setInstanceTypeFor(ComponentDef componentDef, Scope scope) {
        InstanceDef instanceDef = (InstanceDef)this.scopeManager.getScopeTranslator().toExternalComponentScope(scope);
        componentDef.setInstanceDef(instanceDef);
    }
}

