/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.usermodel;

import org.apache.poi.hwpf.sprm.TableSprmUncompressor;
import org.apache.poi.hwpf.usermodel.Paragraph;
import org.apache.poi.hwpf.usermodel.Table;
import org.apache.poi.hwpf.usermodel.TableCell;
import org.apache.poi.hwpf.usermodel.TableProperties;

public class TableRow
extends Paragraph {
    private static final char TABLE_CELL_MARK = '\u0007';
    private static final short SPRM_TJC = 21504;
    private static final short SPRM_DXAGAPHALF = -27134;
    private static final short SPRM_FCANTSPLIT = 13315;
    private static final short SPRM_FTABLEHEADER = 13316;
    private static final short SPRM_DYAROWHEIGHT = -27641;
    int _levelNum;
    private TableProperties _tprops;
    private TableCell[] _cells;

    public TableRow(int startIdx, int endIdx, Table parent, int levelNum) {
        super(startIdx, endIdx, parent);
        this._tprops = TableSprmUncompressor.uncompressTAP(this._papx.toByteArray(), 2);
        this._levelNum = levelNum;
        this._cells = new TableCell[this._tprops.getItcMac()];
        int start = 0;
        int end = 0;
        for (int cellIndex = 0; cellIndex < this._cells.length; ++cellIndex) {
            Paragraph p = this.getParagraph(start);
            String s = p.text();
            while (!(s.charAt(s.length() - 1) == '\u0007' || p.isEmbeddedCellMark() && p.getTableLevel() == levelNum)) {
                p = this.getParagraph(++end);
                s = p.text();
            }
            this._cells[cellIndex] = new TableCell(start, end, this, levelNum, this._tprops.getRgtc()[cellIndex], this._tprops.getRgdxaCenter()[cellIndex], this._tprops.getRgdxaCenter()[cellIndex + 1] - this._tprops.getRgdxaCenter()[cellIndex]);
            start = ++end;
        }
    }

    public int getRowJustification() {
        return this._tprops.getJc();
    }

    public void setRowJustification(int jc) {
        this._tprops.setJc(jc);
        this._papx.updateSprm((short)21504, (short)jc);
    }

    public int getGapHalf() {
        return this._tprops.getDxaGapHalf();
    }

    public void setGapHalf(int dxaGapHalf) {
        this._tprops.setDxaGapHalf(dxaGapHalf);
        this._papx.updateSprm((short)-27134, (short)dxaGapHalf);
    }

    public int getRowHeight() {
        return this._tprops.getDyaRowHeight();
    }

    public void setRowHeight(int dyaRowHeight) {
        this._tprops.setDyaRowHeight(dyaRowHeight);
        this._papx.updateSprm((short)-27641, (short)dyaRowHeight);
    }

    public boolean cantSplit() {
        return this._tprops.getFCantSplit();
    }

    public void setCantSplit(boolean cantSplit) {
        this._tprops.setFCantSplit(cantSplit);
        this._papx.updateSprm((short)13315, (byte)(cantSplit ? 1 : 0));
    }

    public boolean isTableHeader() {
        return this._tprops.getFTableHeader();
    }

    public void setTableHeader(boolean tableHeader) {
        this._tprops.setFTableHeader(tableHeader);
        this._papx.updateSprm((short)13316, (byte)(tableHeader ? 1 : 0));
    }

    public int numCells() {
        return this._cells.length;
    }

    public TableCell getCell(int index) {
        return this._cells[index];
    }
}

