/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;

public class ResourceBundleMap
implements Map {
    private final ResourceBundle bundle;
    private List values;

    public ResourceBundleMap(ResourceBundle bundle) {
        this.bundle = bundle;
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public boolean containsKey(Object key) {
        boolean result = false;
        if (key != null) {
            result = this.bundle.getObject(key.toString()) != null;
        }
        return result;
    }

    public int hashCode() {
        return this.bundle.hashCode();
    }

    public boolean isEmpty() {
        boolean result = true;
        Enumeration<String> keys = this.bundle.getKeys();
        result = !keys.hasMoreElements();
        return result;
    }

    public Collection values() {
        if (this.values == null) {
            this.values = new ArrayList();
            Enumeration<String> keys = this.bundle.getKeys();
            while (keys.hasMoreElements()) {
                this.values.add(this.bundle.getString(keys.nextElement()));
            }
        }
        return this.values;
    }

    public int size() {
        return this.values().size();
    }

    public boolean containsValue(Object value) {
        return this.values().contains(value);
    }

    public Set entrySet() {
        HashMap<String, Object> mappings = new HashMap<String, Object>();
        Enumeration<String> keys = this.bundle.getKeys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            Object value = this.bundle.getObject(key);
            mappings.put(key, value);
        }
        return mappings.entrySet();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Map)) {
            return false;
        }
        return ((Object)this.entrySet()).equals(((Map)obj).entrySet());
    }

    public Object get(Object key) {
        if (key == null) {
            return null;
        }
        Object result = null;
        try {
            result = this.bundle.getObject(key.toString());
        }
        catch (MissingResourceException e) {
            result = "???" + key + "???";
        }
        return result;
    }

    public Set keySet() {
        HashSet<String> set = new HashSet<String>();
        Enumeration<String> enumer = this.bundle.getKeys();
        while (enumer.hasMoreElements()) {
            set.add(enumer.nextElement());
        }
        return set;
    }

    public Object remove(Object key) {
        throw new UnsupportedOperationException();
    }

    public void putAll(Map t) {
        throw new UnsupportedOperationException();
    }

    public Object put(Object key, Object value) {
        throw new UnsupportedOperationException();
    }
}

