/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.component;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.FacesListener;
import javax.faces.internal.AttachedObjectStateWrapper;
import javax.faces.internal.ComponentAttributesMap;
import javax.faces.internal.ComponentChildrenListWrapper;
import javax.faces.internal.ComponentFacetAndChildrenIterator;
import javax.faces.internal.ComponentFacetMapWrapper;
import javax.faces.internal.SerializableStateHolder;
import javax.faces.internal.UIComponentUtil;
import javax.faces.render.Renderer;
import org.seasar.framework.util.AssertionUtil;

public abstract class UIComponentBase
extends UIComponent {
    private String id;
    private ComponentAttributesMap attributesMap = null;
    private Map bindingMap = new HashMap();
    private UIComponent parent;
    private String clientId = null;
    private Boolean isRendered;
    private String renderType = null;
    private List childrenList = null;
    private Map facetMap = null;
    private List listeners = null;
    private boolean isTransient = false;
    private String uniqueId;
    private static final String RENDERED = "rendered";
    private static final String RENDERER_TYPE = "rendererType";
    private static final int LIST_NULL_SIZE = 0;

    public Map getAttributes() {
        if (this.attributesMap == null) {
            this.attributesMap = new ComponentAttributesMap(this);
        }
        return this.attributesMap;
    }

    public ValueBinding getValueBinding(String name) {
        AssertionUtil.assertNotNull((String)"name", (Object)name);
        return (ValueBinding)this.bindingMap.get(name);
    }

    public void setValueBinding(String name, ValueBinding binding) {
        AssertionUtil.assertNotNull((String)"name", (Object)name);
        if (name.equals("id") || name.equals("parent")) {
            throw new IllegalArgumentException("invalid name is specified");
        }
        if (binding != null) {
            this.bindingMap.put(name, binding);
        } else {
            this.bindingMap.remove(name);
        }
    }

    public String getClientId(FacesContext context) {
        AssertionUtil.assertNotNull((String)"context", (Object)context);
        if (this.clientId == null) {
            this.clientId = this.createClientId(context);
        }
        return this.clientId;
    }

    private String createClientId(FacesContext context) {
        StringBuffer buf = new StringBuffer(32);
        for (UIComponent component = this.getParent(); component != null; component = component.getParent()) {
            if (!(component instanceof NamingContainer)) continue;
            buf.append(component.getClientId(context)).append(':');
            break;
        }
        buf.append(context.getExternalContext().encodeNamespace(this.id != null ? this.id : this.getUniqueId(context)));
        String clientId = buf.toString();
        Renderer renderer = this.getRenderer(context);
        if (renderer != null) {
            clientId = renderer.convertClientId(context, clientId);
        }
        return clientId;
    }

    private String getUniqueId(FacesContext context) {
        if (this.uniqueId == null) {
            this.uniqueId = context.getViewRoot().createUniqueId();
        }
        return this.uniqueId;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.validateId(id);
        this.id = id;
        this.clientId = null;
    }

    public UIComponent getParent() {
        return this.parent;
    }

    public void setParent(UIComponent parent) {
        this.parent = parent;
    }

    public boolean isRendered() {
        if (this.isRendered != null) {
            return this.isRendered;
        }
        Boolean v = null;
        ValueBinding vb = this.getValueBinding(RENDERED);
        if (vb != null) {
            v = (Boolean)this.getValueFromBinding(vb);
        }
        if (v != null) {
            return v;
        }
        return true;
    }

    public void setRendered(boolean isRendered) {
        this.isRendered = isRendered;
    }

    public String getRendererType() {
        if (this.renderType != null) {
            return this.renderType;
        }
        ValueBinding vb = this.getValueBinding(RENDERER_TYPE);
        String result = null;
        if (vb != null) {
            result = (String)this.getValueFromBinding(vb);
        }
        return result;
    }

    public void setRendererType(String renderType) {
        this.renderType = renderType;
    }

    private Object getValueFromBinding(ValueBinding vb) {
        return vb.getValue(this.getFacesContext());
    }

    public boolean getRendersChildren() {
        boolean result = false;
        Renderer renderer = this.getRenderer(this.getFacesContext());
        if (this.getRendererType() != null && renderer != null) {
            result = renderer.getRendersChildren();
        }
        return result;
    }

    public List getChildren() {
        if (this.childrenList == null) {
            this.childrenList = new ComponentChildrenListWrapper(this);
        }
        return this.childrenList;
    }

    public int getChildCount() {
        return this.childrenList != null ? this.childrenList.size() : 0;
    }

    public UIComponent findComponent(String expr) {
        AssertionUtil.assertNotNull((String)"expr", (Object)expr);
        UIComponent base = this;
        if (expr.charAt(0) == ':') {
            this.getComponentRoot(base);
            expr = expr.substring(1);
        } else {
            while (((UIComponent)base).getParent() != null && !(base instanceof NamingContainer)) {
                base = ((UIComponent)base).getParent();
            }
        }
        UIComponent result = null;
        if (expr.length() > 0) {
            String id = null;
            int separator = expr.indexOf(58);
            if (separator >= 0) {
                id = expr.substring(0, separator);
                expr = expr.substring(separator + 1);
            } else {
                id = expr;
                expr = null;
            }
            result = this.findComponent(base, id);
            if (result != null && expr != null) {
                if (result instanceof NamingContainer) {
                    result = result.findComponent(expr);
                } else {
                    throw new IllegalArgumentException(id);
                }
            }
        }
        return result;
    }

    private UIComponent findComponent(UIComponent base, String id) {
        if (this.containsSameId(base, id)) {
            return base;
        }
        UIComponent child = null;
        UIComponent result = null;
        Iterator itr = base.getFacetsAndChildren();
        while (itr.hasNext()) {
            child = (UIComponent)itr.next();
            if (!(child instanceof NamingContainer)) {
                result = this.findComponent(child, id);
                if (result == null) continue;
                break;
            }
            if (!this.containsSameId(child, id)) continue;
            result = child;
            break;
        }
        return result;
    }

    protected boolean containsSameId(UIComponent base, String id) {
        return id.equals(base.getId());
    }

    protected UIComponent getComponentRoot(UIComponent base) {
        UIComponent parent = base;
        while (parent.getParent() != null) {
            parent = parent.getParent();
        }
        return parent;
    }

    public Map getFacets() {
        if (this.facetMap == null) {
            this.facetMap = new ComponentFacetMapWrapper(this);
        }
        return this.facetMap;
    }

    public UIComponent getFacet(String name) {
        return this.facetMap != null ? (UIComponent)this.facetMap.get(name) : null;
    }

    public Iterator getFacetsAndChildren() {
        return new ComponentFacetAndChildrenIterator(this.facetMap, this.childrenList);
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        AssertionUtil.assertNotNull((String)"event", (Object)event);
        if (this.listeners != null) {
            Iterator itr = this.listeners.iterator();
            while (itr.hasNext()) {
                FacesListener listener = (FacesListener)itr.next();
                if (!event.isAppropriateListener(listener)) continue;
                event.processListener(listener);
            }
        }
    }

    public void decode(FacesContext context) {
        AssertionUtil.assertNotNull((String)"context", (Object)context);
        Renderer renderer = this.getRendererForEncodeOrDecode(context);
        renderer.decode(context, this);
    }

    public void encodeBegin(FacesContext context) throws IOException {
        AssertionUtil.assertNotNull((String)"context", (Object)context);
        if (!this.isRendered()) {
            return;
        }
        Renderer renderer = this.getRendererForEncodeOrDecode(context);
        renderer.encodeBegin(context, this);
    }

    public void encodeChildren(FacesContext context) throws IOException {
        AssertionUtil.assertNotNull((String)"context", (Object)context);
        if (!this.isRendered()) {
            return;
        }
        Renderer renderer = this.getRendererForEncodeOrDecode(context);
        renderer.encodeChildren(context, this);
    }

    public void encodeEnd(FacesContext context) throws IOException {
        AssertionUtil.assertNotNull((String)"context", (Object)context);
        if (!this.isRendered()) {
            return;
        }
        Renderer renderer = this.getRendererForEncodeOrDecode(context);
        renderer.encodeEnd(context, this);
    }

    private Renderer getRendererForEncodeOrDecode(FacesContext context) {
        Renderer renderer = this.getRenderer(context);
        if (renderer == null) {
            renderer = new NullRenderer();
        }
        return renderer;
    }

    protected void addFacesListener(FacesListener listener) {
        AssertionUtil.assertNotNull((String)"listener", (Object)listener);
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(listener);
    }

    protected FacesListener[] getFacesListeners(Class clazz) {
        AssertionUtil.assertNotNull((String)"class", (Object)clazz);
        if (!FacesListener.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(clazz.getName() + " is not FacesListener");
        }
        if (this.listeners == null) {
            return (FacesListener[])Array.newInstance(clazz, 0);
        }
        ArrayList<FacesListener> result = new ArrayList<FacesListener>();
        FacesListener listener = null;
        Iterator itr = this.listeners.iterator();
        while (itr.hasNext()) {
            listener = (FacesListener)itr.next();
            if (!clazz.isAssignableFrom(listener.getClass())) continue;
            result.add(listener);
        }
        Object[] args = (Object[])Array.newInstance(clazz, result.size());
        return (FacesListener[])result.toArray(args);
    }

    protected void removeFacesListener(FacesListener listener) {
        AssertionUtil.assertNotNull((String)"listener", (Object)listener);
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    public void queueEvent(FacesEvent event) {
        AssertionUtil.assertNotNull((String)"event", (Object)event);
        UIComponent parent = this.getParent();
        if (parent == null) {
            throw new IllegalStateException("parent not found");
        }
        parent.queueEvent(event);
    }

    public void processDecodes(FacesContext context) {
        AssertionUtil.assertNotNull((String)"context", (Object)context);
        if (!this.isRendered()) {
            return;
        }
        UIComponent component = null;
        Iterator itr = this.getFacetsAndChildren();
        while (itr.hasNext()) {
            component = (UIComponent)itr.next();
            component.processDecodes(context);
        }
        try {
            this.decode(context);
        }
        catch (RuntimeException e) {
            context.renderResponse();
            throw e;
        }
    }

    public void processValidators(FacesContext context) {
        AssertionUtil.assertNotNull((String)"context", (Object)context);
        if (!this.isRendered()) {
            return;
        }
        UIComponent component = null;
        Iterator itr = this.getFacetsAndChildren();
        while (itr.hasNext()) {
            component = (UIComponent)itr.next();
            component.processValidators(context);
        }
    }

    public void processUpdates(FacesContext context) {
        AssertionUtil.assertNotNull((String)"context", (Object)context);
        if (!this.isRendered()) {
            return;
        }
        UIComponent component = null;
        Iterator itr = this.getFacetsAndChildren();
        while (itr.hasNext()) {
            component = (UIComponent)itr.next();
            component.processUpdates(context);
        }
    }

    public Object processSaveState(FacesContext context) {
        AssertionUtil.assertNotNull((String)"context", (Object)context);
        if (this.isTransient()) {
            return null;
        }
        HashMap<String, Object> facetMap = new HashMap<String, Object>();
        Iterator itr = this.getFacets().entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry entry = itr.next();
            String key = (String)entry.getKey();
            UIComponent component = (UIComponent)entry.getValue();
            if (component.isTransient()) continue;
            facetMap.put(key, component.processSaveState(context));
        }
        ArrayList<Object> children = new ArrayList<Object>();
        Iterator itr2 = this.getChildren().iterator();
        while (itr2.hasNext()) {
            UIComponent component = (UIComponent)itr2.next();
            if (component.isTransient()) continue;
            children.add(component.processSaveState(context));
        }
        return new SerializableStateHolder(this.saveState(context), facetMap, children);
    }

    public void processRestoreState(FacesContext context, Object state) {
        UIComponent component;
        AssertionUtil.assertNotNull((String)"context", (Object)context);
        if (!(state instanceof SerializableStateHolder)) {
            throw new IllegalArgumentException();
        }
        SerializableStateHolder holder = (SerializableStateHolder)state;
        Object thisState = holder.getState();
        Map facetMap = holder.getFacetMap();
        List children = holder.getChildren();
        Iterator itr = this.getFacets().entrySet().iterator();
        while (itr.hasNext()) {
            Object facetState;
            Map.Entry entry = itr.next();
            component = (UIComponent)entry.getValue();
            if (component.isTransient() || (facetState = facetMap.get(entry.getKey())) == null) continue;
            component.processRestoreState(context, facetState);
        }
        int index = 0;
        Iterator itr2 = this.getChildren().iterator();
        while (itr2.hasNext()) {
            Object childrenState;
            component = (UIComponent)itr2.next();
            if (component.isTransient() || (childrenState = children.get(index++)) == null) continue;
            component.processRestoreState(context, childrenState);
        }
        this.restoreState(context, thisState);
    }

    protected FacesContext getFacesContext() {
        return FacesContext.getCurrentInstance();
    }

    protected Renderer getRenderer(FacesContext context) {
        return UIComponentUtil.getRenderer(context, this);
    }

    public boolean isTransient() {
        return this.isTransient;
    }

    public void setTransient(boolean transientFlag) {
        this.isTransient = transientFlag;
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{this.id, this.isRendered, this.renderType, this.clientId, this.saveAttributesMap(), UIComponentBase.saveAttachedState(context, this.listeners), this.saveValueBindingMap(context)};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        this.id = (String)values[0];
        this.isRendered = (Boolean)values[1];
        this.renderType = (String)values[2];
        this.clientId = (String)values[3];
        this.restoreAttributeMap(values[4]);
        this.listeners = (List)UIComponentBase.restoreAttachedState(context, values[5]);
        this.restoreValueBindingMap(context, values[6]);
    }

    public static Object saveAttachedState(FacesContext context, Object attachedObject) {
        AssertionUtil.assertNotNull((String)"context", (Object)context);
        if (attachedObject == null) {
            return null;
        }
        if (attachedObject instanceof List) {
            List attachedList = (List)attachedObject;
            ArrayList<AttachedObjectStateWrapper> resultList = new ArrayList<AttachedObjectStateWrapper>(attachedList.size());
            Iterator itr = attachedList.iterator();
            while (itr.hasNext()) {
                Object obj = itr.next();
                resultList.add(new AttachedObjectStateWrapper(context, obj));
            }
            return resultList;
        }
        return new AttachedObjectStateWrapper(context, attachedObject);
    }

    public static Object restoreAttachedState(FacesContext context, Object stateObject) {
        AssertionUtil.assertNotNull((String)"context", (Object)context);
        if (stateObject == null) {
            return null;
        }
        if (stateObject instanceof List) {
            List list = (List)stateObject;
            ArrayList<Object> restoredList = new ArrayList<Object>(list.size());
            Iterator itr = list.iterator();
            while (itr.hasNext()) {
                AttachedObjectStateWrapper wrapper = (AttachedObjectStateWrapper)itr.next();
                Object restoredObject = wrapper.restore(context);
                if (restoredObject == null) continue;
                restoredList.add(restoredObject);
            }
            return restoredList;
        }
        if (stateObject instanceof AttachedObjectStateWrapper) {
            AttachedObjectStateWrapper wrapper = (AttachedObjectStateWrapper)stateObject;
            return wrapper.restore(context);
        }
        throw new IllegalStateException("Unsupported:" + stateObject);
    }

    private Object saveAttributesMap() {
        return this.attributesMap != null ? this.attributesMap.getAttributesActual() : null;
    }

    private void restoreAttributeMap(Object state) {
        if (state != null) {
            this.attributesMap = new ComponentAttributesMap(this, (Map)state);
        } else {
            this.clearAttributeMap();
        }
    }

    private Object saveValueBindingMap(FacesContext context) {
        HashMap states = null;
        if (this.bindingMap != null) {
            states = new HashMap();
            Iterator itr = this.bindingMap.entrySet().iterator();
            while (itr.hasNext()) {
                Map.Entry entry = itr.next();
                states.put(entry.getKey(), UIComponentBase.saveAttachedState(context, entry.getValue()));
            }
        }
        return states;
    }

    private void restoreValueBindingMap(FacesContext context, Object state) {
        this.bindingMap = null;
        if (state != null) {
            Map stateMap = (Map)state;
            this.bindingMap = new HashMap();
            Iterator itr = stateMap.entrySet().iterator();
            while (itr.hasNext()) {
                Map.Entry entry = itr.next();
                this.bindingMap.put(entry.getKey(), UIComponentBase.restoreAttachedState(context, entry.getValue()));
            }
        }
    }

    private void clearAttributeMap() {
        this.attributesMap = null;
    }

    private void validateId(String id) {
        if (id == null) {
            return;
        }
        if (id.length() < 1) {
            throw new IllegalArgumentException("UIComponentBase");
        }
        for (int i = 0; i < id.length(); ++i) {
            char ch = id.charAt(i);
            if (i == 0 && !Character.isLetter(ch) && ch != '_') {
                throw new IllegalArgumentException("The first character is invalid(id = " + id + ")");
            }
            if (Character.isDigit(ch) || Character.isLetter(ch) || ch == '-' || ch == '_') continue;
            throw new IllegalArgumentException("Subsequent character is invalid(id = " + id + ")");
        }
    }

    private static class NullRenderer
    extends Renderer {
    }
}

