/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.render.html;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.internal.IgnoreAttribute;
import org.seasar.framework.util.StringUtil;
import org.seasar.teeda.core.render.AbstractRenderer;
import org.seasar.teeda.core.util.RendererUtil;
import org.seasar.teeda.extension.component.html.THtmlStyle;

public class THtmlStyleRenderer
extends AbstractRenderer {
    public static final String COMPONENT_FAMILY = "org.seasar.teeda.extension.HtmlStyle";
    public static final String RENDERER_TYPE = "org.seasar.teeda.extension.HtmlStyle";
    private static final IgnoreAttribute IGNORE_COMPONENT = THtmlStyleRenderer.buildIgnoreComponent();

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        this.assertNotNull(context, component);
        if (!component.isRendered()) {
            return;
        }
        this.encodeTHtmlStyleBegin(context, (THtmlStyle)component);
    }

    protected void encodeTHtmlStyleBegin(FacesContext context, THtmlStyle style) throws IOException {
        String title;
        String media;
        String lang;
        String dir;
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("style", (UIComponent)style);
        String type = style.getType();
        if (!StringUtil.isEmpty((String)type)) {
            RendererUtil.renderAttribute((ResponseWriter)writer, (String)"type", (Object)type, null);
        }
        if (!StringUtil.isEmpty((String)(dir = style.getDir()))) {
            RendererUtil.renderAttribute((ResponseWriter)writer, (String)"dir", (Object)dir, null);
        }
        if (!StringUtil.isEmpty((String)(lang = style.getLang()))) {
            RendererUtil.renderAttribute((ResponseWriter)writer, (String)"lang", (Object)lang, null);
        }
        if (!StringUtil.isEmpty((String)(media = style.getMedia()))) {
            RendererUtil.renderAttribute((ResponseWriter)writer, (String)"media", (Object)media, null);
        }
        if (!StringUtil.isEmpty((String)(title = style.getTitle()))) {
            RendererUtil.renderAttribute((ResponseWriter)writer, (String)"title", (Object)title, null);
        }
        this.renderRemainAttributes((UIComponent)style, writer, IGNORE_COMPONENT);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        this.assertNotNull(context, component);
        if (!component.isRendered()) {
            return;
        }
        this.encodeTHtmlStyleEnd(context, (THtmlStyle)component);
    }

    protected void encodeTHtmlStyleEnd(FacesContext context, THtmlStyle style) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.endElement("style");
    }

    protected static IgnoreAttribute buildIgnoreComponent() {
        IgnoreAttribute ignore = new IgnoreAttribute();
        ignore.addAttributeName("type");
        ignore.addAttributeName("dir");
        ignore.addAttributeName("lang");
        ignore.addAttributeName("media");
        ignore.addAttributeName("title");
        return ignore;
    }
}

