/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.application.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.faces.component.UIComponent;
import org.seasar.framework.util.ClassUtil;
import org.seasar.teeda.core.application.TreeStructure;
import org.seasar.teeda.core.application.TreeStructureManager;

public class TreeStructureManagerImpl
implements TreeStructureManager,
Serializable {
    private static final long serialVersionUID = 1L;

    public TreeStructure buildTreeStructure(UIComponent component) {
        UIComponentTreeStructure struct = new UIComponentTreeStructure(component);
        struct.setChildren(this.buildChildrenTreeStructure(component));
        struct.setFacets(this.buildFacetsTreeStructure(component));
        return struct;
    }

    public UIComponent restoreTreeStructure(TreeStructure structure) {
        String className = structure.getComponentClassName();
        String id = structure.getComponentId();
        UIComponent component = (UIComponent)ClassUtil.newInstance((String)className);
        component.setId(id);
        this.restoreChildrenTreeStructure(component, structure.getChildren());
        this.restoreFacetsTreeStructure(component, structure.getFacets());
        return component;
    }

    protected TreeStructure[] buildChildrenTreeStructure(UIComponent component) {
        if (component.getChildCount() > 0) {
            ArrayList<TreeStructure> structs = new ArrayList<TreeStructure>();
            Iterator itr = component.getChildren().iterator();
            while (itr.hasNext()) {
                UIComponent child = (UIComponent)itr.next();
                if (child.isTransient()) continue;
                TreeStructure childStruct = this.buildTreeStructure(child);
                structs.add(childStruct);
            }
            return structs.toArray(new TreeStructure[structs.size()]);
        }
        return null;
    }

    protected Object[] buildFacetsTreeStructure(UIComponent component) {
        Map facets = component.getFacets();
        if (!facets.isEmpty()) {
            ArrayList<Object[]> structs = new ArrayList<Object[]>();
            Iterator it = facets.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                UIComponent child = (UIComponent)entry.getValue();
                if (child.isTransient()) continue;
                String facetName = (String)entry.getKey();
                TreeStructure struct = this.buildTreeStructure(child);
                structs.add(new Object[]{facetName, struct});
            }
            return structs.toArray();
        }
        return null;
    }

    protected void restoreChildrenTreeStructure(UIComponent component, TreeStructure[] structs) {
        for (int i = 0; i < structs.length; ++i) {
            UIComponent child = this.restoreTreeStructure(structs[i]);
            component.getChildren().add(child);
        }
    }

    protected void restoreFacetsTreeStructure(UIComponent component, Object[] facets) {
        int len = facets.length;
        for (int i = 0; i < len; ++i) {
            Object[] array = (Object[])facets[i];
            String facetName = (String)array[0];
            TreeStructure struct = (TreeStructure)array[1];
            UIComponent child = this.restoreTreeStructure(struct);
            component.getFacets().put(facetName, child);
        }
    }

    private static class UIComponentTreeStructure
    extends TreeStructure {
        private static final long serialVersionUID = 1L;

        public UIComponentTreeStructure(UIComponent component) {
            super(component.getClass().getName(), component.getId());
        }
    }
}

