/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.unit;

import java.io.File;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.seasar.teeda.core.unit.TeedaTestCase;
import org.seasar.teeda.extension.config.taglib.element.TaglibElement;
import org.seasar.teeda.extension.config.taglib.element.impl.TagElementImpl;
import org.seasar.teeda.extension.config.taglib.element.impl.TaglibElementImpl;
import org.seasar.teeda.extension.html.ActionDesc;
import org.seasar.teeda.extension.html.ElementNode;
import org.seasar.teeda.extension.html.ElementNodeDecision;
import org.seasar.teeda.extension.html.HtmlParser;
import org.seasar.teeda.extension.html.PageDesc;
import org.seasar.teeda.extension.html.impl.ActionDescImpl;
import org.seasar.teeda.extension.html.impl.BodyElementNodeDecision;
import org.seasar.teeda.extension.html.impl.ElementNodeImpl;
import org.seasar.teeda.extension.html.impl.HtmlNodeHandler;
import org.seasar.teeda.extension.html.impl.HtmlParserImpl;
import org.seasar.teeda.extension.html.impl.InputTypeCheckboxElementNodeDecision;
import org.seasar.teeda.extension.html.impl.InputTypeRadioElementNodeDecision;
import org.seasar.teeda.extension.html.impl.PageDescImpl;
import org.seasar.teeda.extension.jsp.PageContextImpl;
import org.seasar.teeda.extension.mock.MockTaglibManager;

public abstract class TeedaExtensionTestCase
extends TeedaTestCase {
    protected PageContextImpl pageContext;
    protected MockTaglibManager taglibManager;
    protected HtmlParserImpl parser;

    protected PageContextImpl getPageContext() {
        return this.pageContext;
    }

    protected void setUpContainer() throws Throwable {
        super.setUpContainer();
        this.pageContext = new PageContextImpl();
        this.pageContext.initialize(this.getServlet(), (ServletRequest)this.getRequest(), (ServletResponse)this.getResponse(), null);
        this.taglibManager = this.createTaglibManager();
        this.parser = new HtmlParserImpl();
        HtmlNodeHandler htmlNodeHandler = new HtmlNodeHandler();
        ElementNodeDecision[] decisions = new ElementNodeDecision[]{new BodyElementNodeDecision(), new InputTypeRadioElementNodeDecision(), new InputTypeCheckboxElementNodeDecision()};
        htmlNodeHandler.setElementNodeDecisions(decisions);
        this.getContainer().register((Object)htmlNodeHandler);
    }

    protected void tearDownContainer() throws Throwable {
        super.tearDownContainer();
        this.pageContext = null;
        this.taglibManager = null;
    }

    protected MockTaglibManager createTaglibManager() {
        return new MockTaglibManager();
    }

    protected MockTaglibManager getTaglibManager() {
        return this.taglibManager;
    }

    protected void registerTagElement(String uri, String tagName, Class tagClass) {
        TaglibElement taglibElement;
        if (!this.taglibManager.hasTaglibElement(uri)) {
            taglibElement = new TaglibElementImpl();
            taglibElement.setUri(uri);
            this.taglibManager.addTaglibElement(taglibElement);
        } else {
            taglibElement = this.taglibManager.getTaglibElement(uri);
        }
        TagElementImpl tagElement = new TagElementImpl();
        tagElement.setName(tagName);
        tagElement.setTagClass(tagClass);
        taglibElement.addTagElement(tagElement);
    }

    protected ElementNode createElementNode(String tagName, Map props) {
        return this.createElementNode(null, null, tagName, props);
    }

    protected ElementNode createElementNode(String namespaceURI, String localName, String tagName, Map props) {
        return new ElementNodeImpl(namespaceURI, localName, tagName, props);
    }

    protected PageDesc createPageDesc(Class pageClass, String pageName) {
        return this.createPageDesc(pageClass, pageName, null);
    }

    protected PageDesc createPageDesc(Class pageClass, String pageName, File file) {
        this.getContainer().register(pageClass, pageName);
        PageDescImpl pd = new PageDescImpl(pageClass, pageName, file);
        return pd;
    }

    protected ActionDesc createActionDesc(Class actionClass, String actionName) {
        return this.createActionDesc(actionClass, actionName, null);
    }

    protected ActionDesc createActionDesc(Class actionClass, String actionName, File file) {
        this.getContainer().register(actionClass, actionName);
        ActionDescImpl ad = new ActionDescImpl(actionClass, actionName, file);
        return ad;
    }

    protected HtmlParser getHtmlParser() {
        return this.parser;
    }
}

