/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.util;

import java.util.Iterator;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.util.AssertionUtil;

public class UIParameterUtil {
    private UIParameterUtil() {
    }

    public static void saveParametersToRequest(UIComponent component, FacesContext context) {
        List children = component.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            UIComponent o = (UIComponent)children.get(i);
            if (!(o instanceof UIParameter)) continue;
            UIParameter param = (UIParameter)o;
            context.getExternalContext().getRequestMap().put(param.getName(), param.getValue());
        }
    }

    public static void saveParametersToInstance(UIComponent component, Object obj) {
        AssertionUtil.assertNotNull((String)"component", (Object)component);
        AssertionUtil.assertNotNull((String)"obj", (Object)obj);
        Iterator itr = component.getChildren().iterator();
        while (itr.hasNext()) {
            PropertyDesc propertyDesc;
            Object o = itr.next();
            if (!(o instanceof UIParameter)) continue;
            UIParameter param = (UIParameter)o;
            String name = param.getName();
            Object value = param.getValue();
            BeanDesc beanDesc = BeanDescFactory.getBeanDesc(obj.getClass());
            if (!beanDesc.hasPropertyDesc(name) || !(propertyDesc = beanDesc.getPropertyDesc(name)).isWritable()) continue;
            propertyDesc.setValue(obj, value);
        }
    }
}

