/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.util;

import java.io.File;
import java.util.LinkedList;

public class FileSystemTraversal {
    public static void traverse(File rootDirectory, Handler handler) {
        LinkedList dirs = new LinkedList();
        FileSystemTraversal.addAll(dirs, rootDirectory.listFiles());
        while (!dirs.isEmpty()) {
            File file = (File)dirs.removeFirst();
            if (file.isFile()) {
                handler.acceptFile(file);
                continue;
            }
            if (!file.isDirectory()) continue;
            handler.acceptDirectory(file);
            FileSystemTraversal.addAll(dirs, file.listFiles());
        }
    }

    private static void addAll(LinkedList dirs, File[] files) {
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            dirs.add(file);
        }
    }

    public static interface Handler {
        public void acceptFile(File var1);

        public void acceptDirectory(File var1);
    }
}

