/*
 * Decompiled with CFR 0.152.
 */
package org.easymock.internal;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import org.easymock.IArgumentMatcher;
import org.easymock.internal.MocksControl;
import org.easymock.internal.matchers.And;
import org.easymock.internal.matchers.Not;
import org.easymock.internal.matchers.Or;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LastControl {
    private static final ThreadLocal<MocksControl> threadToControl = new ThreadLocal();
    private static final ThreadLocal<Stack<Object[]>> threadToCurrentArguments = new ThreadLocal();
    private static final ThreadLocal<Stack<IArgumentMatcher>> threadToArgumentMatcherStack = new ThreadLocal();

    public static synchronized void reportLastControl(MocksControl control) {
        if (control != null) {
            threadToControl.set(control);
        } else {
            threadToControl.remove();
        }
    }

    public static synchronized MocksControl lastControl() {
        return threadToControl.get();
    }

    public static synchronized void reportMatcher(IArgumentMatcher matcher) {
        Stack<IArgumentMatcher> stack = threadToArgumentMatcherStack.get();
        if (stack == null) {
            stack = new Stack();
            threadToArgumentMatcherStack.set(stack);
        }
        stack.push(matcher);
    }

    public static synchronized List<IArgumentMatcher> pullMatchers() {
        Stack<IArgumentMatcher> stack = threadToArgumentMatcherStack.get();
        if (stack == null) {
            return null;
        }
        threadToArgumentMatcherStack.remove();
        return new ArrayList<IArgumentMatcher>(stack);
    }

    public static synchronized void reportAnd(int count) {
        Stack<IArgumentMatcher> stack = threadToArgumentMatcherStack.get();
        LastControl.assertState(stack != null, "no matchers found.");
        stack.push(new And(LastControl.popLastArgumentMatchers(count)));
    }

    public static synchronized void reportNot() {
        Stack<IArgumentMatcher> stack = threadToArgumentMatcherStack.get();
        LastControl.assertState(stack != null, "no matchers found.");
        stack.push(new Not(LastControl.popLastArgumentMatchers(1).get(0)));
    }

    private static List<IArgumentMatcher> popLastArgumentMatchers(int count) {
        Stack<IArgumentMatcher> stack = threadToArgumentMatcherStack.get();
        LastControl.assertState(stack != null, "no matchers found.");
        LastControl.assertState(stack.size() >= count, "" + count + " matchers expected, " + stack.size() + " recorded.");
        LinkedList<IArgumentMatcher> result = new LinkedList<IArgumentMatcher>();
        result.addAll(stack.subList(stack.size() - count, stack.size()));
        for (int i = 0; i < count; ++i) {
            stack.pop();
        }
        return result;
    }

    private static void assertState(boolean toAssert, String message) {
        if (!toAssert) {
            threadToArgumentMatcherStack.remove();
            throw new IllegalStateException(message);
        }
    }

    public static void reportOr(int count) {
        Stack<IArgumentMatcher> stack = threadToArgumentMatcherStack.get();
        LastControl.assertState(stack != null, "no matchers found.");
        stack.push(new Or(LastControl.popLastArgumentMatchers(count)));
    }

    public static Object[] getCurrentArguments() {
        Stack<Object[]> stack = threadToCurrentArguments.get();
        if (stack == null || stack.empty()) {
            return null;
        }
        return (Object[])stack.lastElement();
    }

    public static void pushCurrentArguments(Object[] args) {
        Stack<Object> stack = threadToCurrentArguments.get();
        if (stack == null) {
            stack = new Stack();
            threadToCurrentArguments.set(stack);
        }
        stack.push(args);
    }

    public static void popCurrentArguments() {
        Stack<Object[]> stack = threadToCurrentArguments.get();
        stack.pop();
    }
}

