/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.util;

import org.seasar.extension.jdbc.exception.SingleQuoteNotCloseRuntimeException;

public class QueryTokenizer {
    public static final int TT_EOF = -1;
    public static final int TT_WORD = -2;
    public static final int TT_QUOTE = -3;
    public static final int TT_OTHER = -4;
    private String str;
    private int pos;
    private int nextPos;
    private int length;
    private String token;
    private int type = -1;

    public QueryTokenizer(String str) {
        this.str = str;
        this.length = str.length();
        this.peek(0);
    }

    protected void peek(int index) {
        if (index < this.length) {
            char c = this.str.charAt(index);
            this.type = Character.isWhitespace(c) || this.isOrdinary(c) ? -4 : (c == '\'' ? -3 : -2);
            this.pos = index;
            this.nextPos = index + 1;
        } else {
            this.type = -1;
        }
    }

    public int nextToken() {
        if (this.type == -1) {
            return -1;
        }
        if (this.type == -3) {
            for (int i = this.nextPos; i < this.length; ++i) {
                char c = this.str.charAt(i);
                if (c != '\'') continue;
                if (++i >= this.length) {
                    this.token = this.str.substring(this.pos, i);
                    this.type = -1;
                    return -3;
                }
                if (this.str.charAt(i) == '\'') continue;
                this.token = this.str.substring(this.pos, i);
                this.peek(i);
                return -3;
            }
            throw new SingleQuoteNotCloseRuntimeException(this.str);
        }
        for (int i = this.nextPos; i < this.length; ++i) {
            char c = this.str.charAt(i);
            if (this.isOther(c)) {
                if (this.type != -2) continue;
                this.token = this.str.substring(this.pos, i);
                this.pos = i;
                this.nextPos = this.pos + 1;
                this.type = -4;
                return -2;
            }
            if (c == '\'') {
                if (this.type == -2) {
                    this.token = this.str.substring(this.pos, i);
                    this.pos = i;
                    this.nextPos = this.pos + 1;
                    this.type = -3;
                    return -2;
                }
                if (this.type != -4) continue;
                this.token = this.str.substring(this.pos, i);
                this.pos = i;
                this.nextPos = this.pos + 1;
                this.type = -3;
                return -4;
            }
            if (this.type != -4) continue;
            this.token = this.str.substring(this.pos, i);
            this.pos = i;
            this.nextPos = this.pos + 1;
            this.type = -2;
            return -4;
        }
        this.token = this.str.substring(this.pos, this.length);
        if (this.type == -2) {
            this.type = -1;
            return -2;
        }
        this.type = -1;
        return -4;
    }

    protected boolean isOther(char c) {
        return Character.isWhitespace(c) || this.isOrdinary(c);
    }

    protected boolean isOrdinary(char c) {
        return c == '=' || c == '?' || c == '<' || c == '>' || c == '(' || c == ')' || c == '!' || c == '*' || c == '-' || c == ',';
    }

    public String getToken() {
        return this.token;
    }
}

