/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.util;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class JavaScriptUtil {
    private static final Set RESERVED_WORDS = new HashSet<String>(Arrays.asList("abstract", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "delete", "do", "double", "else", "enum", "export", "extends", "false", "final", "finally", "float", "for", "function", "goto", "if", "implements", "in", "instanceof", "int", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "typeof", "var", "void", "while", "with"));

    public static String getClearHiddenCommandFormParamsFunctionName(String formName) {
        return "clear_" + JavaScriptUtil.getValidJavascriptName(formName, false);
    }

    private static String getValidJavascriptName(String s, boolean checkForReservedWord) {
        if (checkForReservedWord && RESERVED_WORDS.contains(s)) {
            return s + "_";
        }
        StringBuffer buf = null;
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            byte[] bytes;
            char c = s.charAt(i);
            if (Character.isLetterOrDigit(c)) {
                if (buf == null) continue;
                buf.append(c);
                continue;
            }
            if (buf == null) {
                buf = new StringBuffer(s.length() + 10);
                buf.append(s.substring(0, i));
            }
            buf.append('_');
            if (c < '\u0010') {
                buf.append('0');
            }
            if (c < '\u0080') {
                buf.append(Integer.toHexString(c).toUpperCase());
                continue;
            }
            try {
                bytes = Character.toString(c).getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            for (int j = 0; j < bytes.length; ++j) {
                int intVal = bytes[j];
                if (intVal < 0) {
                    intVal = 256 + intVal;
                } else if (intVal < 16) {
                    buf.append('0');
                }
                buf.append(Integer.toHexString(intVal).toUpperCase());
            }
        }
        return buf == null ? s : buf.toString();
    }
}

