/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.application;

import java.io.IOException;
import javax.faces.component.ActionSource;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.MethodBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import org.seasar.framework.log.Logger;
import org.seasar.teeda.core.util.ErrorPageManager;
import org.seasar.teeda.core.util.MethodBindingUtil;
import org.seasar.teeda.core.util.NavigationHandlerUtil;
import org.seasar.teeda.core.util.NullErrorPageManagerImpl;

public class ActionListenerImpl
implements ActionListener {
    private static Logger logger = Logger.getLogger((Class)ActionListenerImpl.class);
    public static final String errorManager_BINDING = "bindingType=may";
    private ErrorPageManager errorPageManager = new NullErrorPageManagerImpl();

    public void processAction(ActionEvent actionEvent) throws AbortProcessingException {
        FacesContext context = FacesContext.getCurrentInstance();
        ActionSource actionSource = (ActionSource)((Object)actionEvent.getComponent());
        MethodBinding mb = actionSource.getAction();
        String fromAction = null;
        String outcome = null;
        if (mb != null) {
            fromAction = mb.getExpressionString();
            try {
                outcome = MethodBindingUtil.invoke(mb, context);
                this.processAfterInvoke(context, fromAction, outcome);
            }
            catch (EvaluationException ex) {
                Throwable cause = ex.getCause();
                try {
                    ExternalContext extContext = context.getExternalContext();
                    if (!this.errorPageManager.handleException(cause, context, extContext)) {
                        throw ex;
                    }
                    context.responseComplete();
                }
                catch (IOException ioe) {
                    logger.log((Throwable)ioe);
                    throw ex;
                }
            }
        }
        NavigationHandlerUtil.handleNavigation(context, fromAction, outcome);
        context.renderResponse();
    }

    protected void processAfterInvoke(FacesContext context, String fromAction, String outcome) {
    }

    public ErrorPageManager getErrorPageManager() {
        return this.errorPageManager;
    }

    public void setErrorPageManager(ErrorPageManager errorPageManager) {
        this.errorPageManager = errorPageManager;
    }
}

