/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.external;

import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractExternalContextMap
extends AbstractMap {
    private Set entrySet;
    private Set keySet;
    private Collection values;

    public void clear() {
        ArrayList<String> list = new ArrayList<String>();
        Iterator it = this.getAttributeNames();
        while (it.hasNext()) {
            String key = (String)it.next();
            list.add(key);
        }
        this.clearReally(list);
    }

    private void clearReally(List keys) {
        Iterator itr = keys.iterator();
        while (itr.hasNext()) {
            String key = (String)itr.next();
            this.removeAttribute(key);
        }
    }

    public boolean containsKey(Object key) {
        return this.getAttribute(key.toString()) != null;
    }

    public boolean containsValue(Object value) {
        if (value != null) {
            Iterator it = this.getAttributeNames();
            while (it.hasNext()) {
                String key = (String)it.next();
                Object attributeValue = this.getAttribute(key);
                if (!value.equals(attributeValue)) continue;
                return true;
            }
        }
        return false;
    }

    public Set entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySet(this);
        }
        return this.entrySet;
    }

    public Object get(Object key) {
        return this.getAttribute(key.toString());
    }

    public Object put(Object key, Object value) {
        String keyStr = key.toString();
        Object o = this.getAttribute(keyStr);
        this.setAttribute(keyStr, value);
        return o;
    }

    public void putAll(Map map) {
        Iterator itr = map.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry entry = itr.next();
            String key = (String)entry.getKey();
            this.setAttribute(key, entry.getValue());
        }
    }

    public boolean isEmpty() {
        return !this.getAttributeNames().hasNext();
    }

    public Set keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet(this);
        }
        return this.keySet;
    }

    public Object remove(Object key) {
        String keyStr = key.toString();
        Object o = this.getAttribute(keyStr);
        this.removeAttribute(keyStr);
        return o;
    }

    public Collection values() {
        if (this.values == null) {
            this.values = new ValuesCollection(this);
        }
        return this.values;
    }

    protected abstract Object getAttribute(String var1);

    protected abstract void setAttribute(String var1, Object var2);

    protected abstract Iterator getAttributeNames();

    protected abstract void removeAttribute(String var1);

    protected static class ImmutableEntry
    implements Map.Entry {
        private final Object key;
        private final Object value;

        public ImmutableEntry(Object key, Object value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object arg0) {
            throw new UnsupportedOperationException("Immutable entry.");
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof ImmutableEntry)) {
                return false;
            }
            ImmutableEntry entry = (ImmutableEntry)obj;
            Object k = entry.getKey();
            Object v = entry.getValue();
            return (k == this.key || k != null && k.equals(this.key)) && (v == this.value || v != null && v.equals(this.value));
        }

        public int hashCode() {
            return (this.key != null ? this.key.hashCode() : 0) ^ (this.value != null ? this.value.hashCode() : 0);
        }
    }

    class ValuesIterator
    extends AbstractExternalContextIterator {
        public ValuesIterator(AbstractExternalContextMap contextMap) {
            super(contextMap);
        }

        protected Object doNext() {
            String key = this.getCurrentKey();
            return this.getValueFromMap(key);
        }

        protected void doRemove() {
            String key = this.getCurrentKey();
            Object value = this.getValueFromMap(key);
            this.removeValueFromMap(value);
        }
    }

    class KeyIterator
    extends AbstractExternalContextIterator {
        public KeyIterator(AbstractExternalContextMap contextMap) {
            super(contextMap);
        }

        protected Object doNext() {
            return this.getCurrentKey();
        }

        protected void doRemove() {
            this.removeKeyFromMap(this.getCurrentKey());
        }
    }

    class EntryIterator
    extends AbstractExternalContextIterator {
        public EntryIterator(AbstractExternalContextMap contextMap) {
            super(contextMap);
        }

        protected Object doNext() {
            String key = this.getCurrentKey();
            return new ImmutableEntry(key, this.getValueFromMap(key));
        }

        protected void doRemove() {
            String key = this.getCurrentKey();
            this.removeKeyFromMap(key);
        }
    }

    abstract class AbstractExternalContextIterator
    implements Iterator {
        private final Iterator iterator;
        private final AbstractExternalContextMap contextMap;
        private String currentKey;
        private boolean removeCalled = false;

        public AbstractExternalContextIterator(AbstractExternalContextMap contextMap) {
            this.iterator = contextMap.getAttributeNames();
            this.contextMap = contextMap;
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object next() {
            this.currentKey = (String)this.iterator.next();
            try {
                Object object = this.doNext();
                return object;
            }
            finally {
                this.removeCalled = false;
            }
        }

        public void remove() {
            if (this.currentKey == null || this.removeCalled) {
                throw new IllegalStateException();
            }
            this.doRemove();
            this.removeCalled = true;
        }

        protected String getCurrentKey() {
            return this.currentKey;
        }

        protected Object getValueFromMap(String key) {
            return this.contextMap.get(key);
        }

        protected void removeKeyFromMap(String key) {
            this.contextMap.remove(key);
        }

        protected void removeValueFromMap(Object value) {
            if (AbstractExternalContextMap.this.containsValue(value)) {
                Iterator itr = AbstractExternalContextMap.this.entrySet().iterator();
                while (itr.hasNext()) {
                    Map.Entry e = (Map.Entry)itr.next();
                    if (!value.equals(e.getValue())) continue;
                    this.contextMap.remove(e.getKey());
                }
            }
        }

        protected abstract Object doNext();

        protected abstract void doRemove();
    }

    class ValuesCollection
    extends AbstractCollection {
        private AbstractExternalContextMap contextMap;

        public ValuesCollection(AbstractExternalContextMap contextMap) {
            this.contextMap = contextMap;
        }

        public int size() {
            int size = 0;
            Iterator itr = this.iterator();
            while (itr.hasNext()) {
                itr.next();
                ++size;
            }
            return size;
        }

        public Iterator iterator() {
            return new ValuesIterator(this.contextMap);
        }
    }

    class KeySet
    extends AbstractExternalContextSet {
        private AbstractExternalContextMap contextMap;

        public KeySet(AbstractExternalContextMap contextMap) {
            this.contextMap = contextMap;
        }

        public Iterator iterator() {
            return new KeyIterator(this.contextMap);
        }

        public boolean remove(Object o) {
            if (!(o instanceof String)) {
                return false;
            }
            String s = (String)o;
            Object returnObj = this.contextMap.remove(s);
            return returnObj != null;
        }
    }

    class EntrySet
    extends AbstractExternalContextSet {
        private AbstractExternalContextMap contextMap;

        public EntrySet(AbstractExternalContextMap contextMap) {
            this.contextMap = contextMap;
        }

        public Iterator iterator() {
            return new EntryIterator(this.contextMap);
        }

        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            Object returnObj = this.contextMap.remove(entry.getKey());
            return returnObj != null;
        }
    }

    abstract class AbstractExternalContextSet
    extends AbstractSet {
        AbstractExternalContextSet() {
        }

        public int size() {
            int size = 0;
            Iterator itr = this.iterator();
            while (itr.hasNext()) {
                itr.next();
                ++size;
            }
            return size;
        }
    }
}

