/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.dialect;

import javax.persistence.GenerationType;
import org.seasar.extension.jdbc.SelectForUpdateType;
import org.seasar.extension.jdbc.dialect.StandardDialect;

public class SqliteDialect
extends StandardDialect {
    public String getName() {
        return "sqlite";
    }

    public boolean supportsLimit() {
        return true;
    }

    public String convertLimitSql(String sql, int offset, int limit) {
        StringBuilder buf = new StringBuilder(sql.length() + 20);
        buf.append(sql);
        if (offset > 0) {
            buf.append(" limit ");
            buf.append(limit);
            buf.append(" offset ");
            buf.append(offset);
        } else {
            buf.append(" limit ");
            buf.append(limit);
        }
        return buf.toString();
    }

    public GenerationType getDefaultGenerationType() {
        return GenerationType.IDENTITY;
    }

    public boolean supportsIdentity() {
        return true;
    }

    public String getIdentitySelectString(String tableName, String columnName) {
        return "select last_insert_rowid()";
    }

    public boolean supportsForUpdate(SelectForUpdateType type, boolean withTarget) {
        return false;
    }
}

