/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.context.html;

import java.io.IOException;
import java.io.Writer;
import java.net.URLEncoder;
import javax.faces.component.UIComponent;
import javax.faces.context.ResponseWriter;
import org.seasar.framework.util.ArrayUtil;
import org.seasar.framework.util.AssertionUtil;
import org.seasar.framework.util.StringUtil;
import org.seasar.teeda.core.util.EmptyElementUtil;
import org.seasar.teeda.core.util.HTMLEncodeUtil;

public class HtmlResponseWriter
extends ResponseWriter {
    private static final char[] reserved = new char[]{';', '/', '?', ':', '@', '&', '=', '+', '$', ','};
    private static final char[] unescape = new char[reserved.length + 1];
    private Writer writer;
    private String contentType;
    private String characterEncoding;
    private boolean startTagOpening;
    private boolean shouldEscape = true;
    private static final boolean DEFAULT_ESCAPE = true;

    public void startElement(String name, UIComponent componentForElement) throws IOException {
        AssertionUtil.assertNotNull((String)"name", (Object)name);
        Writer writer = this.getWriter();
        this.closeStartTagIfOpening(writer);
        writer.write("<");
        writer.write(name);
        this.shouldEscape = !"script".equalsIgnoreCase(name);
        this.startTagOpening = true;
    }

    protected void closeStartTagIfOpening(Writer writer) throws IOException {
        if (this.startTagOpening) {
            writer.write(">");
            this.startTagOpening = false;
        }
    }

    public void endElement(String name) throws IOException {
        AssertionUtil.assertNotNull((String)"name", (Object)name);
        Writer writer = this.getWriter();
        if (this.startTagOpening) {
            if (EmptyElementUtil.isEmptyElement(name)) {
                writer.write(" />");
            } else {
                writer.write(">");
                writer.write("</" + name + ">");
            }
            this.startTagOpening = false;
        } else {
            writer.write("</" + name + ">");
        }
        this.shouldEscape = true;
    }

    public void writeAttribute(String name, Object value, String property) throws IOException {
        AssertionUtil.assertNotNull((String)"name", (Object)name);
        if (!this.startTagOpening) {
            throw new IllegalStateException("there is no currently open element");
        }
        String strValue = value == null ? "" : value.toString();
        Writer writer = this.getWriter();
        writer.write(" ");
        writer.write(name);
        writer.write("=\"");
        writer.write(this.escapeAttribute(strValue));
        writer.write("\"");
    }

    public void writeURIAttribute(String name, Object value, String property) throws IOException {
        AssertionUtil.assertNotNull((String)"name", (Object)name);
        if (!this.startTagOpening) {
            throw new IllegalStateException("there is no currently open element");
        }
        Writer writer = this.getWriter();
        String strValue = value.toString();
        writer.write(" ");
        writer.write(name);
        writer.write("=\"");
        if (StringUtil.startsWithIgnoreCase((String)strValue, (String)"javascript:")) {
            writer.write(this.escapeAttribute(strValue));
        } else {
            writer.write(this.encodeURIAttribute(strValue));
        }
        writer.write("\"");
    }

    public void writeComment(Object comment) throws IOException {
        AssertionUtil.assertNotNull((String)"comment", (Object)comment);
        Writer writer = this.getWriter();
        this.closeStartTagIfOpening(writer);
        writer.write("<!--");
        writer.write(comment.toString());
        writer.write("-->");
    }

    public void writeText(Object text, String property) throws IOException {
        AssertionUtil.assertNotNull((String)"text", (Object)text);
        Writer writer = this.getWriter();
        this.closeStartTagIfOpening(writer);
        String str = text.toString();
        if (this.shouldEscape) {
            str = this.htmlSpecialChars(str);
        }
        writer.write(str);
    }

    public void writeText(char[] text, int off, int len) throws IOException {
        AssertionUtil.assertNotNull((String)"text", (Object)text);
        this.writeText(new String(text, off, len), null);
    }

    protected String htmlSpecialChars(String s) {
        return HTMLEncodeUtil.encode(s, true, true);
    }

    protected String escapeAttribute(String s) {
        return HTMLEncodeUtil.encode(s, false, false);
    }

    public ResponseWriter cloneWithWriter(Writer writer) {
        AssertionUtil.assertNotNull((String)"writer", (Object)writer);
        HtmlResponseWriter clone = new HtmlResponseWriter();
        clone.setWriter(writer);
        clone.setContentType(this.getContentType());
        clone.setCharacterEncoding(this.getCharacterEncoding());
        return clone;
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        Writer writer = this.getWriter();
        this.closeStartTagIfOpening(writer);
        writer.write(cbuf, off, len);
    }

    public void write(char[] cbuf) throws IOException {
        Writer writer = this.getWriter();
        this.closeStartTagIfOpening(writer);
        writer.write(cbuf);
    }

    public void write(int c) throws IOException {
        Writer writer = this.getWriter();
        this.closeStartTagIfOpening(writer);
        writer.write(c);
    }

    public void write(String str) throws IOException {
        Writer writer = this.getWriter();
        this.closeStartTagIfOpening(writer);
        writer.write(str);
    }

    public void write(String str, int off, int len) throws IOException {
        Writer writer = this.getWriter();
        this.closeStartTagIfOpening(writer);
        writer.write(str, off, len);
    }

    public void flush() throws IOException {
        Writer writer = this.getWriter();
        this.closeStartTagIfOpening(writer);
    }

    public void close() throws IOException {
        Writer writer = this.getWriter();
        this.closeStartTagIfOpening(writer);
        writer.close();
    }

    public void startDocument() throws IOException {
    }

    public void endDocument() throws IOException {
        this.closeStartTagIfOpening(this.getWriter());
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getCharacterEncoding() {
        if (this.characterEncoding == null) {
            this.characterEncoding = "UTF-8";
        }
        return this.characterEncoding;
    }

    public void setCharacterEncoding(String characterEncoding) {
        this.characterEncoding = characterEncoding;
    }

    public Writer getWriter() {
        return this.writer;
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    protected String encodeURIAttribute(String url) throws IOException {
        char[] chars = url.toCharArray();
        StringBuffer sb = new StringBuffer(url.length() + 100);
        int length = chars.length;
        String encoding = this.getCharacterEncoding();
        for (int i = 0; i < length; ++i) {
            char c = chars[i];
            if (ArrayUtil.contains((char[])unescape, (char)c)) {
                sb.append(c);
                if ('?' != c) continue;
                if (i >= length) break;
                sb.append(this.encodeQueryString(url.substring(i + 1)));
                break;
            }
            sb.append(URLEncoder.encode(String.valueOf(c), encoding));
        }
        return new String(sb);
    }

    public String encodeQueryString(String s) throws IOException {
        char[] chars = s.toCharArray();
        StringBuffer sb = new StringBuffer(s.length() + 32);
        String encoding = this.getCharacterEncoding();
        block14: for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            switch (c) {
                case ' ': {
                    sb.append("%20");
                    continue block14;
                }
                case '!': {
                    sb.append("!");
                    continue block14;
                }
                case '#': {
                    sb.append("#");
                    continue block14;
                }
                case '%': {
                    sb.append("%");
                    continue block14;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block14;
                }
                case '\'': {
                    sb.append("'");
                    continue block14;
                }
                case '(': {
                    sb.append("(");
                    continue block14;
                }
                case ')': {
                    sb.append(")");
                    continue block14;
                }
                case '+': {
                    sb.append("+");
                    continue block14;
                }
                case '/': {
                    sb.append("/");
                    continue block14;
                }
                case '=': {
                    sb.append("=");
                    continue block14;
                }
                case '~': {
                    sb.append("~");
                    continue block14;
                }
                default: {
                    sb.append(URLEncoder.encode(String.valueOf(c), encoding));
                }
            }
        }
        return new String(sb);
    }

    public String toString() {
        return this.writer.toString();
    }

    static {
        System.arraycopy(reserved, 0, unescape, 0, reserved.length);
        HtmlResponseWriter.unescape[HtmlResponseWriter.unescape.length - 1] = 35;
    }
}

