/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.webapp;

import javax.faces.component.UIComponent;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.internal.WebAppUtil;
import javax.faces.webapp.UIComponentTag;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;

public class ConverterTag
extends TagSupport {
    private static final long serialVersionUID = 1L;
    private String converterId = null;

    public void setConverterId(String converterId) {
        this.converterId = converterId;
    }

    public int doStartTag() throws JspException {
        UIComponentTag tag = UIComponentTag.getParentUIComponentTag(this.pageContext);
        if (tag == null) {
            throw new JspException("No nested in UIComponentTag");
        }
        if (!tag.getCreated()) {
            return 0;
        }
        Converter converter = this.createConverter();
        UIComponent component = tag.getComponentInstance();
        if (component == null || !(component instanceof ValueHolder)) {
            throw new JspException("Component is null or not value holder.");
        }
        ValueHolder valueHolder = (ValueHolder)((Object)component);
        valueHolder.setConverter(converter);
        Object localValue = valueHolder.getLocalValue();
        if (localValue instanceof String) {
            try {
                String str = (String)localValue;
                FacesContext context = WebAppUtil.getFacesContext();
                localValue = converter.getAsObject(context, component, str);
                valueHolder.setValue(localValue);
            }
            catch (ConverterException e) {
                JspException ex = new JspException((Throwable)e);
                throw ex;
            }
        }
        return 0;
    }

    public void release() {
        this.converterId = null;
    }

    protected Converter createConverter() throws JspException {
        try {
            String id = this.converterId;
            if (UIComponentTag.isValueReference(id)) {
                id = (String)WebAppUtil.getValueFromCreatedValueBinding(id);
            }
            return WebAppUtil.createConverter(id);
        }
        catch (Exception e) {
            throw new JspException((Throwable)e);
        }
    }
}

