/*
 * Decompiled with CFR 0.152.
 */
package javassist.bytecode.annotation;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.NotFoundException;
import javassist.bytecode.AnnotationDefaultAttribute;
import javassist.bytecode.ClassFile;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.MemberValue;

public class AnnotationImpl
implements InvocationHandler {
    private Annotation annotation;
    private ClassPool pool;
    private ClassLoader classLoader;
    static /* synthetic */ Class class$java$lang$Object;

    public static Object make(ClassLoader cl, Class clazz, ClassPool cp, Annotation anon) {
        AnnotationImpl handler = new AnnotationImpl(anon, cp, cl);
        return Proxy.newProxyInstance(cl, new Class[]{clazz}, (InvocationHandler)handler);
    }

    private AnnotationImpl(Annotation a, ClassPool cp, ClassLoader loader) {
        this.annotation = a;
        this.pool = cp;
        this.classLoader = loader;
    }

    public String getTypeName() {
        return this.annotation.getTypeName();
    }

    public Annotation getAnnotation() {
        return this.annotation;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        MemberValue mv;
        String name = method.getName();
        if ((class$java$lang$Object == null ? (class$java$lang$Object = AnnotationImpl.class$("java.lang.Object")) : class$java$lang$Object) == method.getDeclaringClass()) {
            if ("equals".equals(name)) {
                Object obj = args[0];
                if (obj == null || !(obj instanceof Proxy)) {
                    return Boolean.FALSE;
                }
                InvocationHandler other = Proxy.getInvocationHandler(obj);
                if (this.equals(other)) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            if ("toString".equals(name)) {
                return this.annotation.getTypeName() + '@' + this.hashCode();
            }
            if ("hashCode".equals(name)) {
                return new Integer(this.hashCode());
            }
        } else if ("annotationType".equals(name) && method.getParameterTypes().length == 0) {
            return this.classLoader.loadClass(this.getTypeName());
        }
        if ((mv = this.annotation.getMemberValue(name)) == null) {
            return this.getDefault(name, method);
        }
        return mv.getValue(this.classLoader, this.pool, method);
    }

    private Object getDefault(String name, Method method) throws ClassNotFoundException, RuntimeException {
        String classname = this.annotation.getTypeName();
        if (this.pool != null) {
            try {
                AnnotationDefaultAttribute ainfo;
                CtClass cc = this.pool.get(classname);
                ClassFile cf = cc.getClassFile2();
                MethodInfo minfo = cf.getMethod(name);
                if (minfo != null && (ainfo = (AnnotationDefaultAttribute)minfo.getAttribute("AnnotationDefault")) != null) {
                    MemberValue mv = ainfo.getDefaultValue();
                    return mv.getValue(this.classLoader, this.pool, method);
                }
            }
            catch (NotFoundException e) {
                throw new RuntimeException("cannot find a class file: " + classname);
            }
        }
        throw new RuntimeException("no default value: " + classname + "." + name + "()");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

