/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.internal;

import java.util.Map;
import javax.faces.convert.Converter;
import javax.faces.internal.ConverterBuilder;
import javax.faces.internal.ConverterResource;
import javax.faces.internal.EnumUtil;
import org.seasar.framework.beans.util.BeanUtil;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;
import org.seasar.framework.container.hotdeploy.HotdeployUtil;

public class HotDeployConverterBuilderImpl
implements ConverterBuilder {
    private S2Container container;

    public HotDeployConverterBuilderImpl() {
        this.container = SingletonS2ContainerFactory.getContainer();
    }

    public HotDeployConverterBuilderImpl(S2Container container) {
        this.container = container;
    }

    public Converter build(String expression, ConverterResource.ConverterPair[] pairs) {
        if (pairs == null || pairs.length == 0) {
            return null;
        }
        return this.getSingleConverter(pairs[0]);
    }

    protected Converter getSingleConverter(ConverterResource.ConverterPair pair) {
        ComponentDef cd;
        if (!Converter.class.isAssignableFrom((cd = this.container.getComponentDef((Object)pair.converterName)).getComponentClass())) {
            return null;
        }
        Map properties = pair.properties;
        if (HotdeployUtil.isHotdeploy()) {
            properties = EnumUtil.convertNameToEnum(properties);
        }
        Converter converter = (Converter)cd.getComponent();
        BeanUtil.copyProperties((Map)properties, (Object)converter);
        return converter;
    }

    public void setContainer(S2Container container) {
        this.container = container;
    }

    public void clearAll() {
    }

    public void clearConverter(String expression) {
    }
}

