/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.component;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.el.VariableResolver;
import javax.faces.internal.ComponentStates;
import javax.faces.internal.ComponentStatesHolder;
import javax.faces.internal.FacesMessageResource;
import javax.faces.internal.FacesMessageUtil;
import javax.faces.internal.NamingContainerUtil;
import javax.faces.internal.SavedState;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.log.Logger;
import org.seasar.framework.util.AssertionUtil;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.FieldUtil;
import org.seasar.framework.util.MethodUtil;
import org.seasar.teeda.core.util.BindingUtil;

public class TForEach
extends UIComponentBase
implements NamingContainer,
ComponentStatesHolder {
    public static final String COMPONENT_TYPE = "org.seasar.teeda.extension.ForEach";
    public static final String COMPONENT_FAMILY = "org.seasar.teeda.extension.ForEach";
    private static final String DEFAULT_RENDERER_TYPE = "org.seasar.teeda.extension.ForEach";
    private static final Object[] EMPTY_ITEMS = new Object[0];
    private static final String INDEX_SUFFIX = "Index";
    public static final int INITIAL_ROW_INDEX = -1;
    protected static final Method IS_PARAMETERIZED_METHOD = TForEach.getIsParameterizedMethod();
    protected static final Method GET_ELEMENT_CLASS_METHOD = TForEach.getGetElementClassMethod();
    private String tagName;
    private String pageName;
    private String itemsName;
    private Boolean omittag;
    private List bindingPropertyNames = new ArrayList();
    private int rowIndex = -1;
    private int rowSize;
    private final ComponentStates componentStates = new ComponentStates();
    private static final Logger logger = Logger.getLogger((Class)TForEach.class);

    public TForEach() {
        this.setRendererType("org.seasar.teeda.extension.ForEach");
    }

    public String getFamily() {
        return "org.seasar.teeda.extension.ForEach";
    }

    public void setId(String id) {
        super.setId(id);
        NamingContainerUtil.refreshDescendantComponentClientId((UIComponent)this);
    }

    public String getClientId(FacesContext context) {
        String clientId = super.getClientId(context);
        int rowIndex = this.getRowIndex();
        if (rowIndex == -1) {
            return clientId;
        }
        return clientId + ':' + rowIndex;
    }

    public String getTagName() {
        return this.tagName;
    }

    public void setTagName(String tagName) {
        this.tagName = tagName;
    }

    public String getItemsName() {
        return this.itemsName;
    }

    public void setItemsName(String itemsName) {
        if (itemsName != null && !itemsName.endsWith("Items")) {
            throw new IllegalArgumentException(itemsName);
        }
        this.itemsName = itemsName;
    }

    public String getItemName() {
        if (this.itemsName == null) {
            return null;
        }
        return this.itemsName.substring(0, this.itemsName.length() - "Items".length());
    }

    public String getIndexName() {
        String itemName = this.getItemName();
        if (itemName == null) {
            return null;
        }
        return itemName + INDEX_SUFFIX;
    }

    public String getPageName() {
        return this.pageName;
    }

    public void setPageName(String pageName) {
        this.pageName = pageName;
    }

    public boolean isOmittag() {
        Boolean v;
        if (this.omittag != null) {
            return this.omittag;
        }
        ValueBinding vb = this.getValueBinding("omittag");
        Boolean bl = v = vb != null ? (Boolean)vb.getValue(this.getFacesContext()) : null;
        if (v != null) {
            return v;
        }
        return "div".equalsIgnoreCase(this.tagName) || "span".equalsIgnoreCase(this.tagName);
    }

    public void setOmittag(boolean omittag) {
        this.omittag = new Boolean(omittag);
    }

    public String[] getBindingPropertyNames() {
        return this.bindingPropertyNames.toArray(new String[this.bindingPropertyNames.size()]);
    }

    public void setValueBindingAttribute(String name, String value) {
        BindingUtil.setValueBinding((UIComponent)this, (String)name, (String)value);
        this.bindingPropertyNames.add(name);
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public void setRowIndex(int rowIndex) {
        this.rowIndex = rowIndex;
    }

    public void processDecodes(FacesContext context) {
        AssertionUtil.assertNotNull((String)"context", (Object)context);
        if (!this.isRendered()) {
            return;
        }
        try {
            this.decode(context);
        }
        catch (RuntimeException e) {
            context.renderResponse();
            throw e;
        }
    }

    public void processValidators(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (!this.isRendered()) {
            return;
        }
        this.processValidatorsAllRows(context, (UIComponent)this);
    }

    protected void processValidatorsAllRows(FacesContext context, UIComponent base) {
        String pageName = this.getPageName();
        String id = this.getId();
        String expression = BindingUtil.getExpression((String)pageName, (String)id);
        for (int i = 0; i < this.rowSize; ++i) {
            Integer savedIndex = this.bindRowIndex(context, new Integer(i));
            this.enterRow(context, i, base);
            Iterator itr = base.getFacetsAndChildren();
            while (itr.hasNext()) {
                UIComponent component = (UIComponent)itr.next();
                component.processValidators(context);
            }
            String parentClientId = this.getClientId(context);
            if (!FacesMessageResource.hasMessages((String)expression)) {
                this.processEachRowValidation(context, i, parentClientId);
            }
            this.leaveRow(context, base);
            this.bindRowIndex(context, savedIndex);
        }
        this.aggregateErrorMessageIfNeed(context, expression);
    }

    protected void processEachRowValidation(FacesContext context, int row, String parentClientId) {
        if (FacesMessageUtil.hasMessages((FacesContext)context)) {
            this.appendLineInfoToErrorMessage(context, parentClientId, row);
        }
    }

    protected void aggregateErrorMessageIfNeed(FacesContext context, String expression) {
        if (FacesMessageResource.hasMessages((String)expression)) {
            String parentRowClientId = super.getClientId(context);
            FacesMessage aggregateMessage = FacesMessageResource.getFacesMessage((String)expression);
            this.aggregateErrorMessage(aggregateMessage, context, parentRowClientId);
        }
    }

    protected boolean aggregateErrorMessage(FacesMessage aggregateMessage, FacesContext context, String parentClientId) {
        boolean shouldAggregate = false;
        HashMap<String, Iterator> map = new HashMap<String, Iterator>();
        String saveClientId = null;
        HashSet<String> clientIds = new HashSet<String>();
        Iterator itr = context.getClientIdsWithMessages();
        while (itr.hasNext()) {
            String clientId = (String)itr.next();
            clientIds.add(clientId);
            if (!clientId.startsWith(parentClientId)) {
                Iterator messages = context.getMessages(clientId);
                map.put(clientId, messages);
                continue;
            }
            if (shouldAggregate) continue;
            saveClientId = clientId;
            shouldAggregate = true;
        }
        if (shouldAggregate) {
            BeanDesc bd = BeanDescFactory.getBeanDesc(context.getClass());
            Field field = bd.getField("messages");
            FieldUtil.set((Field)field, (Object)context, null);
            Iterator itr2 = map.entrySet().iterator();
            while (itr2.hasNext()) {
                Map.Entry entry = itr2.next();
                Iterator messages = (Iterator)entry.getValue();
                while (messages.hasNext()) {
                    FacesMessage fm = (FacesMessage)messages.next();
                    context.addMessage(null, fm);
                }
            }
            context.addMessage(saveClientId, aggregateMessage);
            ExternalContext externalContext = context.getExternalContext();
            Map requestMap = externalContext.getRequestMap();
            requestMap.put("org.seasar.teeda.extension.message.clientids", clientIds);
        }
        return shouldAggregate;
    }

    protected void appendLineInfoToErrorMessage(FacesContext context, String parentClientId, int row) {
        Iterator itr = context.getClientIdsWithMessages();
        while (itr.hasNext()) {
            String clientId = (String)itr.next();
            if (clientId == null || !clientId.startsWith(parentClientId)) continue;
            Iterator messages = context.getMessages(clientId);
            while (messages.hasNext()) {
                FacesMessage fm = (FacesMessage)messages.next();
                String summary = fm.getSummary();
                String detail = fm.getDetail();
                if (summary == null && detail == null) continue;
                String lineErrorMessage = this.getLineErrorMessage(context, row + 1);
                if (summary != null) {
                    if (lineErrorMessage != null) {
                        fm.setSummary(summary + lineErrorMessage);
                    } else {
                        fm.setSummary(summary + "(line : " + (row + 1) + ")");
                    }
                }
                if (detail == null) continue;
                if (lineErrorMessage != null) {
                    fm.setDetail(detail + lineErrorMessage);
                    continue;
                }
                fm.setDetail(detail + "(line : " + (row + 1) + ")");
            }
        }
    }

    protected String getLineErrorMessage(FacesContext context, int linenumber) {
        String message = FacesMessageUtil.getSummary((FacesContext)context, (String)"org.seasar.teeda.extension.component.TForEach.line", (Object[])new Object[]{new Integer(linenumber)});
        return message;
    }

    protected Object createNewInstance(FacesContext context, Class itemType) {
        AssertionUtil.assertNotNull((String)"itemType", (Object)itemType);
        Object o = null;
        if (itemType.isPrimitive()) {
            itemType = ClassUtil.getWrapperClassIfPrimitive((Class)itemType);
        }
        if (itemType == Integer.class) {
            return new Integer("0");
        }
        if (itemType == Long.class) {
            return new Long("0");
        }
        if (itemType == Double.class) {
            return new Double("0");
        }
        if (itemType == Float.class) {
            return new Float("0");
        }
        if (itemType == Short.class) {
            return new Short("0");
        }
        if (itemType == BigDecimal.class) {
            return new BigDecimal("0");
        }
        if (itemType == BigInteger.class) {
            return new BigInteger("0");
        }
        if (itemType == Boolean.class) {
            return Boolean.FALSE;
        }
        if (itemType == Calendar.class) {
            Locale locale = context.getViewRoot().getLocale();
            return Calendar.getInstance(locale);
        }
        if (itemType.isArray()) {
            Class<?> cType = itemType.getComponentType();
            return Array.newInstance(cType, 0);
        }
        if (List.class.isAssignableFrom(itemType)) {
            return new ArrayList();
        }
        o = ClassUtil.newInstance((Class)itemType);
        return o;
    }

    public void processUpdates(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (!this.isRendered()) {
            return;
        }
        this.processUpdatesAllRows(context, (UIComponent)this);
    }

    /*
     * WARNING - void declaration
     */
    public void processUpdatesAllRows(FacesContext context, UIComponent base) {
        int i;
        void var9_9;
        List<Object> itemList;
        Class itemClass;
        String itemsName;
        Object page = this.getPage(context);
        Class<?> pageClass = page.getClass();
        BeanDesc pageBeanDesc = BeanDescFactory.getBeanDesc(pageClass);
        PropertyDesc itemsPd = pageBeanDesc.getPropertyDesc(itemsName = this.getItemsName());
        if (!itemsPd.isWritable()) {
            throw new IllegalStateException("class [" + pageBeanDesc.getBeanClass().getName() + "] should have writeMethod for [" + itemsPd.getPropertyName() + "]");
        }
        Class itemsClass = itemsPd.getPropertyType();
        if (itemsClass.isArray()) {
            itemClass = itemsClass.getComponentType();
        } else if (List.class.isAssignableFrom(itemsClass) && this.isParameterized(itemsPd)) {
            itemClass = this.getElementClass(itemsPd);
        } else {
            logger.debug((Object)("class [" + itemsClass.getName() + "] should be array type or parameterized List, so no update."));
            return;
        }
        Object items = itemsPd.getValue(page);
        if (items != null) {
            if (itemsClass.isArray()) {
                Object[] array = (Object[])items;
                int length = array.length;
                if (length >= this.rowSize) {
                    itemList = Arrays.asList(array);
                } else {
                    Object[] newArray = (Object[])Array.newInstance(var9_9, this.rowSize);
                    for (int i2 = 0; i2 < this.rowSize; ++i2) {
                        newArray[i2] = i2 < length ? array[i2] : this.createNewInstance(context, (Class)var9_9);
                    }
                    itemsPd.setValue(page, (Object)newArray);
                    itemList = Arrays.asList(newArray);
                }
            } else {
                itemList = (ArrayList<Object>)items;
                for (int i3 = itemList.size(); i3 < this.rowSize; ++i3) {
                    itemList.add(this.createNewInstance(context, (Class)var9_9));
                }
            }
            this.rowSize = itemList.size();
        } else if (itemsClass.isArray()) {
            Object[] array = (Object[])Array.newInstance(var9_9, this.rowSize);
            for (i = 0; i < array.length; ++i) {
                array[i] = this.createNewInstance(context, (Class)var9_9);
            }
            itemList = Arrays.asList(array);
            itemsPd.setValue(page, (Object)array);
        } else {
            itemList = new ArrayList<Object>(this.rowSize);
            for (int i4 = 0; i4 < this.rowSize; ++i4) {
                itemList.add(this.createNewInstance(context, (Class)var9_9));
            }
            itemsPd.setValue(page, itemList);
        }
        BeanDesc itemBeanDesc = BeanDescFactory.getBeanDesc((Class)var9_9);
        for (i = 0; i < itemList.size(); ++i) {
            Object item = itemList.get(i);
            if (item == null) continue;
            Integer savedIndex = this.bindRowIndex(context, new Integer(i));
            Map savedValues = this.itemToPage(pageBeanDesc, page, item);
            this.enterRow(context, i, base);
            Iterator itr = base.getFacetsAndChildren();
            while (itr.hasNext()) {
                UIComponent component = (UIComponent)itr.next();
                component.processUpdates(context);
            }
            this.leaveRow(context, base);
            this.pageToItem(page, pageBeanDesc, item, itemBeanDesc, savedValues);
            this.bindRowIndex(context, savedIndex);
        }
    }

    public void enterRow(FacesContext context, int rowIndex, UIComponent base) {
        this.setRowIndex(rowIndex);
        this.componentStates.restoreDescendantState(context, base);
    }

    public void leaveRow(FacesContext context, UIComponent base) {
        this.componentStates.saveDescendantComponentStates(context, base);
        this.setRowIndex(-1);
    }

    public Integer bindRowIndex(FacesContext context, Integer rowIndex) {
        Object page = this.getPage(context);
        Class<?> pageClass = page.getClass();
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc(pageClass);
        String indexName = this.getIndexName();
        HashMap savedValues = new HashMap();
        this.setValue(beanDesc, page, indexName, rowIndex, savedValues);
        return (Integer)savedValues.get(indexName);
    }

    public Object getPage(FacesContext context) {
        VariableResolver variableResolver = context.getApplication().getVariableResolver();
        return variableResolver.resolveVariable(context, this.getPageName());
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.tagName, this.pageName, this.itemsName, this.omittag, this.bindingPropertyNames};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.tagName = (String)values[1];
        this.pageName = (String)values[2];
        this.itemsName = (String)values[3];
        this.omittag = (Boolean)values[4];
        this.bindingPropertyNames = (List)values[5];
    }

    public void save(SavedState state) {
        state.setLocalValue((Object)new Integer(this.rowSize));
    }

    public void restore(SavedState state) {
        Integer value = (Integer)state.getLocalValue();
        this.rowSize = value == null ? 0 : value;
    }

    public int getRowSize() {
        return this.rowSize;
    }

    public void setRowSize(int rowCount) {
        this.rowSize = rowCount;
    }

    public Object[] getItems(FacesContext context) {
        Object page = this.getPage(context);
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc(page.getClass());
        PropertyDesc pd = beanDesc.getPropertyDesc(this.getItemsName());
        Object items = pd.getValue(page);
        if (items == null) {
            return EMPTY_ITEMS;
        }
        if (items instanceof Collection) {
            return ((Collection)items).toArray();
        }
        if (items.getClass().isArray()) {
            return (Object[])items;
        }
        throw new IllegalStateException(items.getClass().toString());
    }

    public Map itemToPage(BeanDesc pageBeanDesc, Object page, Object item) {
        if (item == null) {
            return Collections.EMPTY_MAP;
        }
        String itemName = this.getItemName();
        this.setValue(pageBeanDesc, page, itemName, item, null);
        HashMap savedValues = new HashMap();
        if (item instanceof Map) {
            this.processMapItem(pageBeanDesc, page, (Map)item, savedValues);
        } else {
            this.processBeanItem(pageBeanDesc, page, item, savedValues);
        }
        return savedValues;
    }

    public void pageToItem(Object page, BeanDesc pageBeanDesc, Object item, BeanDesc itemBeanDesc, Map savedValues) {
        Iterator it = savedValues.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String propertyName = (String)entry.getKey();
            Object savedPageValue = entry.getValue();
            PropertyDesc pagePd = pageBeanDesc.getPropertyDesc(propertyName);
            if (!pagePd.isReadable()) continue;
            Object pageValue = pagePd.getValue(page);
            if (pagePd.isWritable()) {
                pagePd.setValue(page, savedPageValue);
            }
            if (item instanceof Map) {
                ((Map)item).put(propertyName, pageValue);
                continue;
            }
            PropertyDesc itemPd = itemBeanDesc.getPropertyDesc(propertyName);
            if (!itemPd.isWritable()) continue;
            itemPd.setValue(item, pageValue);
        }
    }

    protected void processBeanItem(BeanDesc pageBeanDesc, Object page, Object item, Map savedValues) {
        BeanDesc itemBeanDesc = BeanDescFactory.getBeanDesc(item.getClass());
        for (int i = 0; i < itemBeanDesc.getPropertyDescSize(); ++i) {
            PropertyDesc pd = itemBeanDesc.getPropertyDesc(i);
            String propertyName = pd.getPropertyName();
            if (!pageBeanDesc.hasPropertyDesc(propertyName) || !pageBeanDesc.getPropertyDesc(propertyName).isWritable()) continue;
            Object value = this.getValue(itemBeanDesc, item, propertyName);
            this.setValue(pageBeanDesc, page, propertyName, value, savedValues);
        }
    }

    protected void processMapItem(BeanDesc pageBeanDesc, Object page, Map item, Map savedValues) {
        Iterator it = item.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String propertyName = (String)entry.getKey();
            Object value = entry.getValue();
            if (!pageBeanDesc.hasPropertyDesc(propertyName) || !pageBeanDesc.getPropertyDesc(propertyName).isWritable()) continue;
            this.setValue(pageBeanDesc, page, propertyName, value, savedValues);
        }
    }

    protected Object getValue(BeanDesc beanDesc, Object page, String propertyName) {
        PropertyDesc pd;
        if (beanDesc.hasPropertyDesc(propertyName) && (pd = beanDesc.getPropertyDesc(propertyName)).isReadable()) {
            return pd.getValue(page);
        }
        return null;
    }

    protected void setValue(BeanDesc beanDesc, Object page, String propertyName, Object value, Map savedValues) {
        if (beanDesc.hasPropertyDesc(propertyName)) {
            Class<?> valueClass;
            PropertyDesc pd = beanDesc.getPropertyDesc(propertyName);
            Class pdClass = pd.getPropertyType();
            if (pdClass.isPrimitive()) {
                pdClass = ClassUtil.getWrapperClass((Class)pdClass);
            }
            Class<?> clazz = valueClass = value != null ? value.getClass() : null;
            if (pd.isWritable() && TForEach.isRelatedClass(pdClass, valueClass)) {
                if (savedValues != null && pd.isReadable()) {
                    savedValues.put(propertyName, pd.getValue(page));
                }
                pd.setValue(page, value);
            }
        }
    }

    protected static boolean isRelatedClass(Class pdClass, Class valueClass) {
        if (valueClass == null) {
            return true;
        }
        return pdClass == valueClass || pdClass.isAssignableFrom(valueClass);
    }

    protected static Method getIsParameterizedMethod() {
        try {
            return PropertyDesc.class.getMethod("isParameterized", null);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected static Method getGetElementClassMethod() {
        try {
            return PropertyDesc.class.getMethod("getElementClassOfCollection", null);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected boolean isParameterized(PropertyDesc pd) {
        if (IS_PARAMETERIZED_METHOD == null) {
            return false;
        }
        return (Boolean)MethodUtil.invoke((Method)IS_PARAMETERIZED_METHOD, (Object)pd, null);
    }

    protected Class getElementClass(PropertyDesc pd) {
        if (GET_ELEMENT_CLASS_METHOD == null) {
            return null;
        }
        return (Class)MethodUtil.invoke((Method)GET_ELEMENT_CLASS_METHOD, (Object)pd, null);
    }
}

