/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.annotation.handler;

import java.util.Map;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.util.StringUtil;
import org.seasar.teeda.extension.ExtensionConstants;
import org.seasar.teeda.extension.annotation.handler.AbstractScopeAnnotationHandler;

public class ConstantScopeAnnotationHandler
extends AbstractScopeAnnotationHandler {
    private static final String REDIRECT_SCOPE_KEY = "REDIRECT_SCOPE";
    private static final String SUBAPPLICATION_SCOPE_KEY = "SUBAPPLICATION_SCOPE";
    private static final String PAGE_SCOPE_KEY = "PAGE_SCOPE";

    public void setupPropertyScopes(BeanDesc beanDesc, Map scopes) {
        this.handleScope(beanDesc, scopes, REDIRECT_SCOPE_KEY, ExtensionConstants.REDIRECT_SCOPE);
        this.handleScope(beanDesc, scopes, SUBAPPLICATION_SCOPE_KEY, ExtensionConstants.SUBAPP_SCOPE);
        this.handleScope(beanDesc, scopes, PAGE_SCOPE_KEY, ExtensionConstants.PAGE_SCOPE);
    }

    protected void handleScope(BeanDesc beanDesc, Map scopes, String scopeKey, Integer scope) {
        if (beanDesc.hasField(scopeKey)) {
            String redirectScopeValue = (String)beanDesc.getFieldValue(scopeKey, null);
            this.storePropertyScope(scopes, redirectScopeValue, scope);
        }
    }

    private void storePropertyScope(Map scopes, String value, Integer scope) {
        String[] array = StringUtil.split((String)value, (String)", ");
        for (int i = 0; i < array.length; ++i) {
            scopes.put(array[i], scope);
        }
    }
}

