/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.internal;

import java.io.Serializable;
import javax.faces.component.StateHolder;
import javax.faces.context.FacesContext;
import javax.faces.internal.ClassLoaderUtil;
import org.seasar.framework.log.Logger;

public class AttachedObjectStateWrapper
implements Serializable {
    private static final Logger logger = Logger.getLogger((Class)AttachedObjectStateWrapper.class);
    private static final long serialVersionUID = 3256726169255885111L;
    private Object savedState = null;
    private String className = null;
    private boolean isSavedStateHolder = false;

    public AttachedObjectStateWrapper(FacesContext context, Object obj) {
        if (obj == null) {
            throw new IllegalArgumentException();
        }
        this.className = obj.getClass().getName();
        if (obj instanceof StateHolder) {
            StateHolder stateHolder = (StateHolder)obj;
            if (!stateHolder.isTransient()) {
                this.savedState = stateHolder.saveState(context);
                this.isSavedStateHolder = true;
            }
        } else {
            if (!(obj instanceof Serializable)) {
                logger.debug((Object)("class : " + this.className + " should be serializable."));
            }
            this.savedState = obj;
        }
    }

    public Object restore(FacesContext context) throws IllegalStateException {
        Object result = null;
        if (!this.isSavedStateHolder) {
            result = this.savedState;
        } else if (this.isSavedStateHolder) {
            try {
                ClassLoader loader = ClassLoaderUtil.getClassLoader(context);
                Class clazz = ClassLoaderUtil.loadClass(loader, this.className);
                result = clazz.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e.getMessage());
            }
            catch (InstantiationException e) {
                throw new IllegalStateException(e.getMessage());
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e.getMessage());
            }
            if (this.savedState != null && result instanceof StateHolder) {
                ((StateHolder)result).restoreState(context, this.savedState);
            }
        }
        return result;
    }
}

