/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.context.portlet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.faces.application.Application;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseStream;
import javax.faces.context.ResponseWriter;
import javax.faces.internal.FactoryFinderUtil;
import javax.faces.render.RenderKit;
import org.seasar.framework.util.AssertionUtil;
import org.seasar.teeda.core.context.Releaseable;
import org.seasar.teeda.core.util.ApplicationUtil;

public class PortletFacesContextImpl
extends FacesContext {
    private ExternalContext externalContext;
    private Application application;
    private boolean released = false;
    private boolean renderResponse = false;
    private boolean responseComplete = false;
    private ResponseWriter responseWriter;
    private UIViewRoot root;
    private List messages;
    private List messageClientIds;
    private FacesMessage.Severity maxSeverity;
    private ResponseStream responseStream;

    public PortletFacesContextImpl(ExternalContext externalContext) {
        this.externalContext = externalContext;
        this.application = ApplicationUtil.getApplicationFromFactory();
        FacesContext.setCurrentInstance(this);
    }

    public Application getApplication() {
        this.assertNotReleased();
        return this.application;
    }

    public Iterator getClientIdsWithMessages() {
        this.assertNotReleased();
        if (this.messages == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return this.messageClientIds.iterator();
    }

    public ExternalContext getExternalContext() {
        this.assertNotReleased();
        return this.externalContext;
    }

    public FacesMessage.Severity getMaximumSeverity() {
        this.assertNotReleased();
        return this.maxSeverity;
    }

    public Iterator getMessages() {
        this.assertNotReleased();
        return this.messages != null ? this.messages.iterator() : Collections.EMPTY_LIST.iterator();
    }

    public Iterator getMessages(String clientId) {
        this.assertNotReleased();
        if (this.messages == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        if (this.messages.size() != this.messageClientIds.size()) {
            throw new IllegalStateException();
        }
        ArrayList list = new ArrayList();
        for (int i = 0; i < this.messages.size(); ++i) {
            String savedClientId = (String)this.messageClientIds.get(i);
            if (!this.stringEquals(clientId, savedClientId)) continue;
            list.add(this.messages.get(i));
        }
        return list.iterator();
    }

    private boolean stringEquals(String a, String b) {
        if (a == null) {
            return b == null;
        }
        return a.equals(b);
    }

    public RenderKit getRenderKit() {
        this.assertNotReleased();
        UIViewRoot root = this.getViewRoot();
        if (root == null) {
            return null;
        }
        String renderKitId = root.getRenderKitId();
        if (renderKitId == null) {
            return null;
        }
        return FactoryFinderUtil.getRenderKitFactory().getRenderKit(this, renderKitId);
    }

    public boolean getRenderResponse() {
        this.assertNotReleased();
        return this.renderResponse;
    }

    public boolean getResponseComplete() {
        this.assertNotReleased();
        return this.responseComplete;
    }

    public ResponseStream getResponseStream() {
        this.assertNotReleased();
        return this.responseStream;
    }

    public void setResponseStream(ResponseStream responseStream) {
        this.assertNotReleased();
        AssertionUtil.assertNotNull((String)"responseStream", (Object)responseStream);
        this.responseStream = responseStream;
    }

    public ResponseWriter getResponseWriter() {
        this.assertNotReleased();
        return this.responseWriter;
    }

    public void setResponseWriter(ResponseWriter responseWriter) {
        this.assertNotReleased();
        AssertionUtil.assertNotNull((String)"responseWriter", (Object)responseWriter);
        this.responseWriter = responseWriter;
    }

    public UIViewRoot getViewRoot() {
        this.assertNotReleased();
        return this.root;
    }

    public void setViewRoot(UIViewRoot root) {
        this.assertNotReleased();
        AssertionUtil.assertNotNull((String)"root", (Object)root);
        this.root = root;
    }

    public void addMessage(String clientId, FacesMessage message) {
        this.assertNotReleased();
        AssertionUtil.assertNotNull((String)"message", (Object)message);
        if (this.messages == null) {
            this.messages = new ArrayList();
            this.messageClientIds = new ArrayList();
        }
        this.messages.add(message);
        this.messageClientIds.add(clientId);
        FacesMessage.Severity severity = message.getSeverity();
        this.setSeverity(severity);
    }

    public void release() {
        this.released = true;
        this.application = null;
        if (this.externalContext instanceof Releaseable) {
            ((Releaseable)((Object)this.externalContext)).release();
        }
        this.externalContext = null;
        FacesContext.setCurrentInstance(null);
    }

    public void renderResponse() {
        this.assertNotReleased();
        this.renderResponse = true;
    }

    public void responseComplete() {
        this.assertNotReleased();
        this.responseComplete = true;
    }

    private void setSeverity(FacesMessage.Severity severity) {
        if (severity != null && (this.maxSeverity == null || severity.compareTo(this.maxSeverity) > 0)) {
            this.maxSeverity = severity;
        }
    }

    private void assertNotReleased() {
        if (this.released) {
            throw new IllegalStateException("already released");
        }
    }

    public void setExternalContext(ExternalContext externalContext) {
        this.assertNotReleased();
        this.externalContext = externalContext;
        FacesContext.setCurrentInstance(this);
    }
}

