/*
 * Copyright 2004-2011 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.teeda.extension.render;

import java.util.List;

/**
 * @author higa
 * 
 */
public class IncludedBody {

    private String viewId;

    private List componentList;

    /**
     * @param viewId
     * @param componentList
     */
    public IncludedBody(String viewId, List componentList) {
        this.viewId = viewId;
        this.componentList = componentList;
    }

    /**
     * @return Returns the componentList.
     */
    public List getComponentList() {
        return componentList;
    }

    /**
     * @return Returns the viewId.
     */
    public String getViewId() {
        return viewId;
    }
}
