/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.render.html.support;

import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.portlet.PortletURL;
import javax.portlet.RenderResponse;
import org.seasar.teeda.core.portlet.FacesPortlet;
import org.seasar.teeda.core.render.html.support.UrlBuilder;
import org.seasar.teeda.core.render.html.support.UrlParameter;

public class PortletUrlBuilder
extends UrlBuilder {
    public String build() {
        URI uri = URI.create(this.getBase());
        if (uri.getScheme() != null) {
            return super.build();
        }
        FacesContext context = FacesContext.getCurrentInstance();
        if (context != null) {
            String viewId = this.calculatePath(context.getViewRoot().getViewId(), uri.getPath());
            ExternalContext externalContext = context.getExternalContext();
            if (externalContext.getResponse() instanceof RenderResponse) {
                RenderResponse response = (RenderResponse)externalContext.getResponse();
                PortletURL portletUrl = response.createActionURL();
                portletUrl.setParameter(FacesPortlet.VIEW_ID, viewId);
                portletUrl.setParameter(FacesPortlet.RENDER_PARAMETER, "true");
                if (uri.getQuery() != null) {
                    String[] queries = uri.getQuery().split("&");
                    for (int i = 0; i < queries.length; ++i) {
                        int index = queries[i].indexOf("=");
                        if (index <= 0) continue;
                        portletUrl.setParameter(queries[i].substring(0, index), queries[i].substring(index + 1));
                    }
                }
                Iterator it = this.getUrlParameters().entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    String key = (String)entry.getKey();
                    UrlParameter parameter = (UrlParameter)entry.getValue();
                    String[] values = parameter.getValues();
                    for (int i = 0; i < values.length; ++i) {
                        String value = values[i];
                        portletUrl.setParameter(key, value);
                    }
                }
                return portletUrl.toString();
            }
        }
        return super.build();
    }

    protected String calculatePath(String currentPath, String path) {
        int i;
        if (path.startsWith("/")) {
            return path;
        }
        String[] cPaths = currentPath.split("/");
        String[] nPaths = path.split("/");
        ArrayList<String> list = new ArrayList<String>();
        for (i = 0; i < cPaths.length - 1; ++i) {
            if (cPaths[i].equals("")) continue;
            list.add(cPaths[i]);
        }
        for (i = 0; i < nPaths.length; ++i) {
            if ("..".equals(nPaths[i])) {
                int size = list.size();
                if (size <= 0) continue;
                list.remove(size - 1);
                continue;
            }
            if (".".equals(nPaths[i]) || nPaths[i].equals("")) continue;
            list.add(nPaths[i]);
        }
        StringBuffer p = new StringBuffer("");
        for (int i2 = 0; i2 < list.size(); ++i2) {
            p.append("/");
            p.append(list.get(i2));
        }
        return p.toString();
    }
}

