/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.internal.scope;

import java.util.Map;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.faces.internal.scope.VariableScope;

public abstract class RedirectScope {
    private static final String REDIRECTING_KEY = RedirectScope.class.getName();
    private static final String REDIRECTED_KEY = RedirectScope.class.getName() + ".REDIRECTED";
    private static final VariableScope scope = new VariableScope(REDIRECTING_KEY);

    protected RedirectScope() {
    }

    public static Map getContext(FacesContext context) throws FacesException {
        return scope.getContext(context);
    }

    public static Map getOrCreateContext(FacesContext context) throws FacesException {
        return scope.getOrCreateContext(context);
    }

    public static void removeContext(FacesContext context) throws FacesException {
        scope.removeContext(context);
    }

    public static void clearContext(FacesContext context) throws FacesException {
        scope.clearContext(context);
    }

    public static boolean isRedirecting(FacesContext context) throws FacesException {
        Map ctx = scope.getContext(context);
        if (ctx == null) {
            return false;
        }
        return ctx.containsKey(REDIRECTING_KEY);
    }

    public static void setRedirectingPath(FacesContext context, String path) throws FacesException {
        Map ctx = RedirectScope.getOrCreateContext(context);
        ctx.put(REDIRECTING_KEY, path);
    }

    public static String getRedirectingPath(FacesContext context) throws FacesException {
        Map ctx = scope.getContext(context);
        if (ctx == null) {
            return null;
        }
        return (String)ctx.get(REDIRECTING_KEY);
    }

    public static void setRedirectedPath(FacesContext context, String path) throws FacesException {
        Map ctx = RedirectScope.getOrCreateContext(context);
        ctx.put(REDIRECTED_KEY, path);
    }

    public static String getRedirectedPath(FacesContext context) throws FacesException {
        Map ctx = scope.getContext(context);
        if (ctx == null) {
            return null;
        }
        return (String)ctx.get(REDIRECTED_KEY);
    }
}

