/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.render.html;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.LinkedList;
import java.util.List;
import javax.faces.context.ResponseStream;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;
import org.seasar.framework.util.SPrintWriter;
import org.seasar.teeda.core.application.ComponentLookupStrategy;
import org.seasar.teeda.core.application.impl.DefaultComponentLookupStrategy;
import org.seasar.teeda.core.context.html.HtmlResponseWriter;
import org.seasar.teeda.core.mock.MockRenderer;
import org.seasar.teeda.core.render.html.HtmlRenderKitImpl;
import org.seasar.teeda.core.render.html.support.HtmlRenderKitKeyGenerateUtil;
import org.seasar.teeda.core.unit.TeedaTestCase;

public class HtmlRenderKitImplTest
extends TeedaTestCase {
    public void testAddRenderer() throws Exception {
        HtmlRenderKitImpl renderKit = this.createHtmlRenderKitImpl();
        renderKit.setContainer(this.getContainer());
        try {
            renderKit.addRenderer(null, "a", (Renderer)new MockRenderer());
            HtmlRenderKitImplTest.fail();
        }
        catch (NullPointerException expected) {
            HtmlRenderKitImplTest.success();
        }
        try {
            renderKit.addRenderer("a", null, (Renderer)new MockRenderer());
            HtmlRenderKitImplTest.fail();
        }
        catch (NullPointerException expected) {
            HtmlRenderKitImplTest.success();
        }
        try {
            renderKit.addRenderer("a", "aa", null);
            HtmlRenderKitImplTest.fail();
        }
        catch (NullPointerException expected) {
            HtmlRenderKitImplTest.success();
        }
        MockRenderer mock = new MockRenderer();
        renderKit.addRenderer("a", "b", (Renderer)mock);
        Renderer r = renderKit.getRenderer("a", "b");
        HtmlRenderKitImplTest.assertNotNull((Object)r);
        HtmlRenderKitImplTest.assertEquals((Object)mock, (Object)r);
    }

    public void testGetRenderer() throws Exception {
        Renderer r;
        HtmlRenderKitImpl renderKit = this.createHtmlRenderKitImpl();
        renderKit.setContainer(this.getContainer());
        MockRenderer mock = new MockRenderer();
        renderKit.addRenderer("a", "b", (Renderer)mock);
        try {
            r = renderKit.getRenderer(null, "b");
            HtmlRenderKitImplTest.fail();
        }
        catch (NullPointerException expected) {
            HtmlRenderKitImplTest.success();
        }
        try {
            r = renderKit.getRenderer("a", null);
            HtmlRenderKitImplTest.fail();
        }
        catch (NullPointerException expected) {
            HtmlRenderKitImplTest.success();
        }
        r = renderKit.getRenderer("a", "b");
        HtmlRenderKitImplTest.assertNotNull((Object)r);
        HtmlRenderKitImplTest.assertEquals((Object)mock, (Object)r);
    }

    public void testCreateOutStream() throws Exception {
        HtmlRenderKitImpl renderKit = this.createHtmlRenderKitImpl();
        MockOutputStream out = new MockOutputStream();
        ResponseStream stream = renderKit.createResponseStream((OutputStream)out);
        stream.write(0);
        stream.write(1);
        List list = out.getResultList();
        HtmlRenderKitImplTest.assertEquals((Object)new Integer(0), list.get(0));
        HtmlRenderKitImplTest.assertEquals((Object)new Integer(1), list.get(1));
    }

    public void testCreateResponseWriter2() throws Exception {
        HtmlRenderKitImpl renderKit = this.createHtmlRenderKitImpl();
        ResponseWriter w = renderKit.createResponseWriter((Writer)new SPrintWriter(), "text/html, hoge, foo", "Windows-31J");
        HtmlRenderKitImplTest.assertNotNull((Object)w);
        HtmlRenderKitImplTest.assertTrue((boolean)(w instanceof HtmlResponseWriter));
        HtmlRenderKitImplTest.assertEquals((String)"Windows-31J", (String)w.getCharacterEncoding());
        HtmlRenderKitImplTest.assertEquals((String)"text/html", (String)w.getContentType());
        HtmlRenderKitImplTest.assertTrue((boolean)(((HtmlResponseWriter)w).getWriter() instanceof SPrintWriter));
    }

    public void testCreateResponseWriter_ReturnsDefaultContentTypeWhenContentTypeListNoMatch() throws Exception {
        HtmlRenderKitImpl renderKit = this.createHtmlRenderKitImpl();
        ResponseWriter w = renderKit.createResponseWriter((Writer)new SPrintWriter(), "a, b", "Windows-31J");
        HtmlRenderKitImplTest.assertEquals((String)"[text/html] is Default ContentType", (String)"text/html", (String)w.getContentType());
    }

    public void testAddRenderer_withFacesConfig() throws Exception {
        HtmlRenderKitImpl renderKit = this.createHtmlRenderKitImpl();
        renderKit.addRenderer("a", "b", (Renderer)new MockRenderer());
        Renderer renderer = renderKit.getRenderer("a", "b");
        HtmlRenderKitImplTest.assertNotNull((Object)renderer);
        HtmlRenderKitImplTest.assertFalse((boolean)renderer.getRendersChildren());
        renderKit.addRenderer("a", "b", (Renderer)new MockRenderer(){

            public boolean getRendersChildren() {
                return true;
            }
        });
        renderer = renderKit.getRenderer("a", "b");
        HtmlRenderKitImplTest.assertNotNull((Object)renderer);
        HtmlRenderKitImplTest.assertTrue((boolean)renderer.getRendersChildren());
    }

    public void testAddRenderer_withS2Register() throws Exception {
        HtmlRenderKitImpl renderKit = this.createHtmlRenderKitImpl();
        this.getContainer().register(new MockRenderer().getClass(), HtmlRenderKitKeyGenerateUtil.getGeneratedKey((String)"a", (String)"b"));
        Renderer renderer = renderKit.getRenderer("a", "b");
        HtmlRenderKitImplTest.assertNotNull((Object)renderer);
        HtmlRenderKitImplTest.assertTrue((boolean)(renderer instanceof MockRenderer));
    }

    public void testAddRenderer_withDicon1() throws Exception {
        this.include("child.dicon");
        HtmlRenderKitImpl renderKit = this.createHtmlRenderKitImpl();
        Renderer renderer = renderKit.getRenderer("a", "b");
        HtmlRenderKitImplTest.assertNotNull((Object)renderer);
        HtmlRenderKitImplTest.assertTrue((boolean)(renderer instanceof MockRenderer2));
        renderer = renderKit.getRenderer("b", "c");
        HtmlRenderKitImplTest.assertNotNull((Object)renderer);
        HtmlRenderKitImplTest.assertTrue((boolean)(renderer instanceof MockRenderer3));
        renderer = renderKit.getRenderer("c", "d");
        HtmlRenderKitImplTest.assertNotNull((Object)renderer);
        HtmlRenderKitImplTest.assertTrue((boolean)(renderer instanceof MockRenderer4));
    }

    public void testAddRenderer_withFacesConfigAndDicon() throws Exception {
        this.include("child.dicon");
        HtmlRenderKitImpl renderKit = this.createHtmlRenderKitImpl();
        renderKit.addRenderer("b", "c", (Renderer)new MockRenderer5());
        Renderer renderer = renderKit.getRenderer("b", "c");
        HtmlRenderKitImplTest.assertNotNull((Object)renderer);
        HtmlRenderKitImplTest.assertTrue((boolean)(renderer instanceof MockRenderer5));
        HtmlRenderKitImplTest.assertTrue((boolean)renderer.getRendersChildren());
    }

    private HtmlRenderKitImpl createHtmlRenderKitImpl() {
        HtmlRenderKitImpl renderKit = new HtmlRenderKitImpl();
        renderKit.setContainer(this.getContainer());
        renderKit.setComponentLookupStrategy((ComponentLookupStrategy)new DefaultComponentLookupStrategy());
        return renderKit;
    }

    public static class MockRenderer5
    extends MockRenderer {
        public boolean getRendersChildren() {
            return true;
        }
    }

    public static class MockRenderer4
    extends MockRenderer {
    }

    public static class MockRenderer3
    extends MockRenderer {
    }

    public static class MockRenderer2
    extends MockRenderer {
    }

    public static class MockRenderer1
    extends MockRenderer {
    }

    private static class MockOutputStream
    extends OutputStream {
        private List list = new LinkedList();

        private MockOutputStream() {
        }

        public void write(int arg0) throws IOException {
            this.list.add(new Integer(arg0));
        }

        public List getResultList() {
            return this.list;
        }
    }
}

