/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.el.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.faces.application.Application;
import javax.faces.context.FacesContext;
import javax.faces.el.PropertyResolver;
import javax.faces.el.VariableResolver;
import org.seasar.teeda.core.el.ELParser;
import org.seasar.teeda.core.el.ExpressionProcessor;
import org.seasar.teeda.core.el.TeedaVariableResolver;
import org.seasar.teeda.core.el.impl.ValueBindingImpl;
import org.seasar.teeda.core.el.impl.commons.CommonsELParser;
import org.seasar.teeda.core.el.impl.commons.CommonsExpressionProcessorImpl;
import org.seasar.teeda.core.managedbean.ManagedBeanFactory;
import org.seasar.teeda.core.mock.MockFacesContext;
import org.seasar.teeda.core.mock.MockPropertyResolver;
import org.seasar.teeda.core.mock.MockVariableResolver;
import org.seasar.teeda.core.mock.NullELParser;
import org.seasar.teeda.core.scope.Scope;
import org.seasar.teeda.core.unit.ExceptionAssert;
import org.seasar.teeda.core.unit.TeedaTestCase;

public class ValueBindingImplTest
extends TeedaTestCase {
    public void testGetValueSimple1() {
        A a = new A();
        MockVariableResolver resolver = this.getVariableResolver();
        resolver.putValue("a", (Object)a);
        ValueBindingImpl vb = new ValueBindingImpl((Application)this.getApplication(), "#{a}", this.createELParser());
        Object o = vb.getValue((FacesContext)this.getFacesContext());
        ValueBindingImplTest.assertTrue((o == a ? 1 : 0) != 0);
    }

    public void testGetValueSimple2() {
        A a = new A();
        MockVariableResolver variableResolver = this.getVariableResolver();
        variableResolver.putValue("a", (Object)a);
        ValueBindingImpl vb = new ValueBindingImpl((Application)this.getApplication(), "#{a.name}", this.createELParser());
        Object o = vb.getValue((FacesContext)this.getFacesContext());
        ValueBindingImplTest.assertEquals((Object)"aaa", (Object)o);
        this.getApplication().getPropertyResolver().setValue((Object)a, (Object)"name", (Object)"bbb");
        o = vb.getValue((FacesContext)this.getFacesContext());
        ValueBindingImplTest.assertEquals((Object)"bbb", (Object)o);
    }

    public void testGetValueSimple3() {
        A a = new A();
        B b = new B();
        b.setName("hoge");
        MockVariableResolver variableResolver = this.getVariableResolver();
        variableResolver.putValue("a", (Object)a);
        MockPropertyResolver propertyResolver = this.getPropertyResolver();
        propertyResolver.setValue((Object)a, (Object)"b", (Object)b);
        this.getApplication().setPropertyResolver((PropertyResolver)propertyResolver);
        ValueBindingImpl vb = new ValueBindingImpl((Application)this.getApplication(), "#{a.b.name}", this.createELParser());
        Object o = vb.getValue((FacesContext)this.getFacesContext());
        ValueBindingImplTest.assertEquals((Object)"hoge", (Object)o);
    }

    public void testGetValueSimple4() {
        Hoge hoge = new Hoge();
        MockVariableResolver variableResolver = this.getVariableResolver();
        variableResolver.putValue("hoge", (Object)hoge);
        MockPropertyResolver propertyResolver = this.getPropertyResolver();
        this.getApplication().setPropertyResolver((PropertyResolver)propertyResolver);
        ValueBindingImpl vb = new ValueBindingImpl((Application)this.getApplication(), "#{hoge.a.name}", this.createELParser());
        Object o = vb.getValue((FacesContext)this.getFacesContext());
        ValueBindingImplTest.assertEquals((Object)"aaa", (Object)o);
    }

    public void testGetValueSimple5() {
        C c = new C();
        c.setHoge(true);
        MockVariableResolver variableResolver = this.getVariableResolver();
        variableResolver.putValue("c_", (Object)c);
        ValueBindingImpl vb = new ValueBindingImpl((Application)this.getApplication(), "#{c_.hoge}", this.createELParser());
        Object o = vb.getValue((FacesContext)this.getFacesContext());
        ValueBindingImplTest.assertTrue((boolean)((Boolean)o));
    }

    public void testGetValueSimple6() {
        MockVariableResolver resolver = this.getVariableResolver();
        resolver.putValue("a", (Object)new Integer(1));
        ValueBindingImpl vb = new ValueBindingImpl((Application)this.getApplication(), "#{a == 1}", this.createELParser());
        Object o = vb.getValue((FacesContext)this.getFacesContext());
        ValueBindingImplTest.assertEquals((Object)Boolean.TRUE, (Object)o);
    }

    public void testGetValueSimple7() {
        ArrayList list = new ArrayList();
        D d = new D(list);
        MockVariableResolver variableResolver = this.getVariableResolver();
        variableResolver.putValue("d", (Object)d);
        ValueBindingImpl vb = new ValueBindingImpl((Application)this.getApplication(), "#{d.blank}", this.createELParser());
        Object o = vb.getValue((FacesContext)this.getFacesContext());
        ValueBindingImplTest.assertTrue((boolean)((Boolean)o));
    }

    public void testGetValueSimple8() {
        MockVariableResolver resolver = this.getVariableResolver();
        resolver.putValue("a", (Object)new Boolean(true));
        ValueBindingImpl vb = new ValueBindingImpl((Application)this.getApplication(), "#{a}", this.createELParser());
        Object o = vb.getValue((FacesContext)this.getFacesContext());
        ValueBindingImplTest.assertEquals((Object)Boolean.TRUE, (Object)o);
    }

    public void testGetValueSimple9() {
        MockVariableResolver resolver = this.getVariableResolver();
        resolver.putValue("a", (Object)new Boolean(true));
        ValueBindingImpl vb = new ValueBindingImpl((Application)this.getApplication(), "#{a == false}", this.createELParser());
        Object o = vb.getValue((FacesContext)this.getFacesContext());
        ValueBindingImplTest.assertEquals((Object)Boolean.FALSE, (Object)o);
    }

    public void testGetMapValue1() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("hoge", "foo");
        MockVariableResolver resolver = this.getVariableResolver();
        resolver.putValue("hogemap", map);
        ValueBindingImpl vb = new ValueBindingImpl((Application)this.getApplication(), "#{hogemap}", this.createELParser());
        Object o = vb.getValue((FacesContext)this.getFacesContext());
        ValueBindingImplTest.assertSame(map, (Object)o);
        Map m = (Map)o;
        ValueBindingImplTest.assertEquals((Object)"foo", m.get("hoge"));
    }

    public void testGetMapValue2() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("hoge", "foo");
        MockVariableResolver resolver = this.getVariableResolver();
        resolver.putValue("hogemap", map);
        ValueBindingImpl vb = new ValueBindingImpl((Application)this.getApplication(), "#{hogemap.hoge}", this.createELParser());
        Object o = vb.getValue((FacesContext)this.getFacesContext());
        ValueBindingImplTest.assertEquals((Object)"foo", (Object)o);
    }

    public void testGetMapValue3() {
        HashMap<String, A> map = new HashMap<String, A>();
        map.put("a", new A());
        MockVariableResolver resolver = this.getVariableResolver();
        resolver.putValue("hogemap", map);
        ValueBindingImpl vb = new ValueBindingImpl((Application)this.getApplication(), "#{hogemap[\"a\"]['name'] }", this.createELParser());
        Object o = vb.getValue((FacesContext)this.getFacesContext());
        ValueBindingImplTest.assertEquals((Object)"aaa", (Object)o);
    }

    public void testGetListValue1() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("aaa");
        MockVariableResolver resolver = this.getVariableResolver();
        resolver.putValue("list", list);
        ValueBindingImpl vb = new ValueBindingImpl((Application)this.getApplication(), "#{list[0] }", this.createELParser());
        Object o = vb.getValue((FacesContext)this.getFacesContext());
        ValueBindingImplTest.assertEquals((Object)"aaa", (Object)o);
        list.add(0, "bbb");
        o = vb.getValue((FacesContext)this.getFacesContext());
        ValueBindingImplTest.assertEquals((Object)"bbb", (Object)o);
        vb.setValue((FacesContext)this.getFacesContext(), (Object)"ccc");
        o = vb.getValue((FacesContext)this.getFacesContext());
        ValueBindingImplTest.assertEquals((Object)"ccc", (Object)o);
    }

    public void testGetListValue2() {
        ArrayList list = new ArrayList();
        MockVariableResolver variableResolver = this.getVariableResolver();
        variableResolver.putValue("list", list);
        ValueBindingImpl vb = new ValueBindingImpl((Application)this.getApplication(), "#{empty list}", this.createELParser());
        Object o = vb.getValue((FacesContext)this.getFacesContext());
        ValueBindingImplTest.assertTrue((boolean)((Boolean)o));
    }

    public void testGetListValue3() {
        ValueBindingImpl vb = new ValueBindingImpl((Application)this.getApplication(), "#{empty list}", this.createELParser());
        Object o = vb.getValue((FacesContext)this.getFacesContext());
        ValueBindingImplTest.assertTrue((boolean)((Boolean)o));
    }

    public void testGetListValue4() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("a");
        MockVariableResolver variableResolver = this.getVariableResolver();
        variableResolver.putValue("list", list);
        ValueBindingImpl vb = new ValueBindingImpl((Application)this.getApplication(), "#{!empty list}", this.createELParser());
        Object o = vb.getValue((FacesContext)this.getFacesContext());
        ValueBindingImplTest.assertTrue((boolean)((Boolean)o));
    }

    public void testGetListValue5() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("a");
        MockVariableResolver variableResolver = this.getVariableResolver();
        variableResolver.putValue("list", list);
        ValueBindingImpl vb = new ValueBindingImpl((Application)this.getApplication(), "#{not empty list}", this.createELParser());
        Object o = vb.getValue((FacesContext)this.getFacesContext());
        ValueBindingImplTest.assertTrue((boolean)((Boolean)o));
    }

    public void testGetExpressionalValue1() {
        A a = new A();
        B b = new B();
        MockVariableResolver resolver = this.getVariableResolver();
        resolver.putValue("a", (Object)a);
        resolver.putValue("b", (Object)b);
        ValueBindingImpl vb = new ValueBindingImpl((Application)this.getApplication(), "#{true ? a : b}", this.createELParser());
        Object o = vb.getValue((FacesContext)this.getFacesContext());
        ValueBindingImplTest.assertSame((Object)a, (Object)o);
    }

    public void testGetMixedValue1() {
        A a = new A();
        B b = new B();
        a.setName("hoge");
        b.setName("bar");
        MockVariableResolver resolver = this.getVariableResolver();
        resolver.putValue("a", (Object)a);
        resolver.putValue("b", (Object)b);
        ValueBindingImpl vb = new ValueBindingImpl((Application)this.getApplication(), "#{a.name} and #{b.name}", this.createELParser());
        Object o = vb.getValue((FacesContext)this.getFacesContext());
        ValueBindingImplTest.assertEquals((Object)"hoge and bar", (Object)o);
    }

    public void testIsReadOnly1() {
        ValueBindingImpl vb = new ValueBindingImpl((Application)this.getApplication(), "#{'baz'}", this.createELParser());
        MockVariableResolver resolver = this.getVariableResolver();
        resolver.putValue("'baz'", (Object)"'baz'");
        ValueBindingImplTest.assertTrue((boolean)vb.isReadOnly((FacesContext)this.getFacesContext()));
    }

    public void testIsReadOnly2() {
        A a = new A();
        MockVariableResolver resolver = this.getVariableResolver();
        resolver.putValue("a", (Object)a);
        ValueBindingImpl vb = new ValueBindingImpl((Application)this.getApplication(), "#{a.name}", this.createELParser());
        ValueBindingImplTest.assertFalse((boolean)vb.isReadOnly((FacesContext)this.getFacesContext()));
    }

    public void testIsReadOnly3() {
        Foo foo = new Foo();
        MockVariableResolver resolver = this.getVariableResolver();
        resolver.putValue("foo", (Object)foo);
        ValueBindingImpl vb = new ValueBindingImpl((Application)this.getApplication(), "#{foo.num}", this.createELParser());
        ValueBindingImplTest.assertTrue((boolean)vb.isReadOnly((FacesContext)this.getFacesContext()));
    }

    public void testIsReadOnlyImplicit() {
        ValueBindingImpl vb = new ValueBindingImpl((Application)this.getApplication(), "#{cookie}", this.createELParser());
        ValueBindingImplTest.assertTrue((boolean)vb.isReadOnly((FacesContext)this.getFacesContext()));
        vb = new ValueBindingImpl((Application)this.getApplication(), "#{applicationScope}", this.createELParser());
        ValueBindingImplTest.assertTrue((boolean)vb.isReadOnly((FacesContext)this.getFacesContext()));
        vb = new ValueBindingImpl((Application)this.getApplication(), "#{facesContext}", this.createELParser());
        ValueBindingImplTest.assertTrue((boolean)vb.isReadOnly((FacesContext)this.getFacesContext()));
        vb = new ValueBindingImpl((Application)this.getApplication(), "#{header}", this.createELParser());
        ValueBindingImplTest.assertTrue((boolean)vb.isReadOnly((FacesContext)this.getFacesContext()));
        vb = new ValueBindingImpl((Application)this.getApplication(), "#{headerValues}", this.createELParser());
        ValueBindingImplTest.assertTrue((boolean)vb.isReadOnly((FacesContext)this.getFacesContext()));
        vb = new ValueBindingImpl((Application)this.getApplication(), "#{initParam}", this.createELParser());
        ValueBindingImplTest.assertTrue((boolean)vb.isReadOnly((FacesContext)this.getFacesContext()));
        vb = new ValueBindingImpl((Application)this.getApplication(), "#{param}", this.createELParser());
        ValueBindingImplTest.assertTrue((boolean)vb.isReadOnly((FacesContext)this.getFacesContext()));
        vb = new ValueBindingImpl((Application)this.getApplication(), "#{paramValues}", this.createELParser());
        ValueBindingImplTest.assertTrue((boolean)vb.isReadOnly((FacesContext)this.getFacesContext()));
        vb = new ValueBindingImpl((Application)this.getApplication(), "#{requestScope}", this.createELParser());
        ValueBindingImplTest.assertTrue((boolean)vb.isReadOnly((FacesContext)this.getFacesContext()));
        vb = new ValueBindingImpl((Application)this.getApplication(), "#{sessionScope}", this.createELParser());
        ValueBindingImplTest.assertTrue((boolean)vb.isReadOnly((FacesContext)this.getFacesContext()));
    }

    public void testGetType1() {
        ValueBindingImpl vb = new ValueBindingImpl((Application)this.getApplication(), "#{'hoge'}", this.createELParser());
        ValueBindingImplTest.assertSame((Object)String.class, (Object)vb.getType((FacesContext)this.getFacesContext()));
    }

    public void testGetType2() {
        ValueBindingImpl vb = new ValueBindingImpl((Application)this.getApplication(), "#{true}", this.createELParser());
        ValueBindingImplTest.assertSame((Object)Boolean.class, (Object)vb.getType((FacesContext)this.getFacesContext()));
    }

    public void testGetType3() {
        this.getApplication().setVariableResolver((VariableResolver)new TeedaVariableResolver());
        ValueBindingImpl vb = new ValueBindingImpl((Application)this.getApplication(), "#{requestScope}", this.createELParser());
        ValueBindingImplTest.assertTrue((boolean)Map.class.isAssignableFrom(vb.getType((FacesContext)this.getFacesContext())));
    }

    public void testGetType4() {
        MockVariableResolver resolver = this.getVariableResolver();
        resolver.putValue("aaa", (Object)new A());
        ValueBindingImpl vb = new ValueBindingImpl((Application)this.getApplication(), "#{aaa}", this.createELParser());
        ValueBindingImplTest.assertEquals((Object)A.class, (Object)vb.getType((FacesContext)this.getFacesContext()));
    }

    public void testGetExpressionString() {
        A a = new A();
        MockVariableResolver resolver = this.getVariableResolver();
        resolver.putValue("a", (Object)a);
        ValueBindingImpl vb = new ValueBindingImpl((Application)this.getApplication(), "#{a}", this.createELParser());
        String str = vb.getExpressionString();
        ValueBindingImplTest.assertEquals((String)"#{a}", (String)str);
    }

    public void testSetType1() {
        A a = new A();
        a.setName("hoge");
        MockVariableResolver resolver = this.getVariableResolver();
        resolver.putValue("a", (Object)a);
        ValueBindingImpl vb = new ValueBindingImpl((Application)this.getApplication(), "#{a}", this.createELParser());
        A anotherA = (A)vb.getValue((FacesContext)this.getFacesContext());
        ValueBindingImplTest.assertEquals((String)"hoge", (String)anotherA.getName());
        ManagedBeanFactory factory = this.getManagedBeanFactory();
        factory.registerManagedBean("a", A.class, Scope.REQUEST);
        anotherA.setName("foo");
        vb.setValue((FacesContext)this.getFacesContext(), (Object)anotherA);
        anotherA = (A)vb.getValue((FacesContext)this.getFacesContext());
        ValueBindingImplTest.assertEquals((String)"foo", (String)anotherA.getName());
    }

    public void testSetType2() {
        A a = new A();
        a.setName("aaa");
        MockVariableResolver resolver = this.getVariableResolver();
        resolver.putValue("a", (Object)a);
        ValueBindingImpl vb = new ValueBindingImpl((Application)this.getApplication(), "#{a.name}", this.createELParser());
        String s = (String)vb.getValue((FacesContext)this.getFacesContext());
        ValueBindingImplTest.assertEquals((String)"aaa", (String)s);
        vb.setValue((FacesContext)this.getFacesContext(), (Object)"bbb");
        ValueBindingImplTest.assertEquals((String)"bbb", (String)((String)vb.getValue((FacesContext)this.getFacesContext())));
    }

    public void testSetType3() {
        MockVariableResolver resolver = this.getVariableResolver();
        resolver.putValue("num", (Object)new Integer(123));
        ValueBindingImpl vb = new ValueBindingImpl((Application)this.getApplication(), "#{num}", this.createELParser());
        ValueBindingImplTest.assertEquals((Object)new Integer(123), (Object)vb.getValue((FacesContext)this.getFacesContext()));
        resolver.putValue("num", (Object)new Integer(345));
        vb.setValue((FacesContext)this.getFacesContext(), (Object)new Integer(345));
        Integer num = new Integer(345);
        ValueBindingImplTest.assertEquals((Object)num, (Object)vb.getValue((FacesContext)this.getFacesContext()));
    }

    public void testSetValue_FacesContextIsNull() throws Exception {
        ValueBindingImpl vb = new ValueBindingImpl((Application)this.getApplication(), "#{a}", this.createELParser());
        try {
            vb.setValue(null, (Object)"val");
            ValueBindingImplTest.fail();
        }
        catch (NullPointerException npe) {
            ExceptionAssert.assertMessageExist(npe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetValue_DateType() throws Exception {
        Conv c = new Conv();
        Date now = new Date();
        c.setDate(now);
        MockVariableResolver resolver = this.getVariableResolver();
        resolver.putValue("c", (Object)c);
        ValueBindingImpl vb = new ValueBindingImpl((Application)this.getApplication(), "#{c.date}", this.createELParser());
        MockFacesContext context = this.getFacesContext();
        ValueBindingImplTest.assertEquals((Object)now, (Object)vb.getValue((FacesContext)context));
        Locale defaultLocale = Locale.getDefault();
        try {
            Locale.setDefault(Locale.JAPANESE);
            vb.setValue((FacesContext)context, (Object)"20061231");
        }
        finally {
            Locale.setDefault(defaultLocale);
        }
        ValueBindingImplTest.assertEquals((Object)new SimpleDateFormat("yyyyMMdd").parse("20061231"), (Object)vb.getValue((FacesContext)context));
    }

    public void testSaveAndRestoreState() throws Exception {
        NullELParser parser = new NullELParser(){

            public Object parse(String expression) {
                return expression + expression;
            }
        };
        this.getContainer().register((Object)parser);
        MockFacesContext context = this.getFacesContext();
        ValueBindingImpl vb1 = new ValueBindingImpl(context.getApplication(), "ab", (ELParser)parser);
        Object state = vb1.saveState((FacesContext)context);
        ValueBindingImpl vb2 = new ValueBindingImpl();
        vb2.restoreState((FacesContext)context, state);
        ValueBindingImplTest.assertEquals((String)"ab", (String)vb2.getExpressionString());
        ValueBindingImplTest.assertEquals((Object)"abab", (Object)vb2.getExpression());
    }

    public void testNotSaveELParser() throws Exception {
        MockFacesContext context = this.getFacesContext();
        NullELParser parser = new NullELParser();
        ValueBindingImplTest.assertEquals((boolean)true, (boolean)(parser instanceof Serializable));
        this.getContainer().register((Object)parser);
        ValueBindingImpl vb1 = new ValueBindingImpl(context.getApplication(), "fooo", (ELParser)parser);
        Object saved = vb1.saveState((FacesContext)context);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(saved);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ObjectInputStream ois = new ObjectInputStream(bais);
        Object restored = ois.readObject();
        ValueBindingImpl vb2 = new ValueBindingImpl();
        vb2.restoreState((FacesContext)context, restored);
        ValueBindingImplTest.assertEquals((String)"fooo", (String)vb2.getExpressionString());
    }

    protected ELParser createELParser() {
        CommonsELParser parser = new CommonsELParser();
        parser.setExpressionProcessor((ExpressionProcessor)new CommonsExpressionProcessorImpl());
        return parser;
    }

    public static class Foo {
        public int getNum() {
            return 0;
        }
    }

    public static class Hoge {
        public A getA() {
            return new A();
        }
    }

    public static class D {
        List list_;

        public D(List list) {
            this.list_ = list;
        }

        public List getList() {
            return this.list_;
        }

        public boolean isBlank() {
            return this.list_.isEmpty();
        }
    }

    public static class C {
        private boolean hoge_ = false;

        public void setHoge(boolean hoge) {
            this.hoge_ = hoge;
        }

        public boolean isHoge() {
            return this.hoge_;
        }
    }

    public static class B {
        private String name_;

        public void setName(String name) {
            this.name_ = name;
        }

        public String getName() {
            return this.name_;
        }
    }

    public static class A {
        private String name = "aaa";
        private B b_;

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setB(B b) {
            this.b_ = b;
        }

        public B getB() {
            return this.b_;
        }
    }

    public static class Conv {
        private Date date_;

        public void setDate(Date date) {
            this.date_ = date;
        }

        public Date getDate() {
            return this.date_;
        }
    }
}

