/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.internal;

import java.util.HashMap;
import javax.faces.internal.HotDeployValidatorBuilderImpl;
import javax.faces.internal.NormalValidatorBuilderImpl;
import javax.faces.internal.ValidatorBuilder;
import javax.faces.internal.ValidatorChain;
import javax.faces.internal.ValidatorResource;
import javax.faces.validator.DoubleRangeValidator;
import javax.faces.validator.LengthValidator;
import org.seasar.teeda.core.unit.TeedaTestCase;

public class ValidatorResourceTest
extends TeedaTestCase {
    public void tearDown() {
        ValidatorResource.removeAll();
    }

    public void setUpGetValidator() throws Exception {
        this.register(DoubleRangeValidator.class, "doubleRangeValidator");
        HotDeployValidatorBuilderImpl builder = new HotDeployValidatorBuilderImpl();
        builder.setContainer(this.getContainer());
        ValidatorResource.setValidatorBuilder((ValidatorBuilder)builder);
    }

    public void tearDownGetValidator() throws Exception {
        ValidatorResource.setValidatorBuilder(null);
    }

    public void testGetValidator() throws Exception {
        ValidatorResource.addValidator((String)"#{a.name}", (String)"doubleRangeValidator");
        ValidatorResourceTest.assertNotNull((Object)ValidatorResource.getValidator((String)"#{a.name}"));
        ValidatorResourceTest.assertTrue((boolean)(ValidatorResource.getValidator((String)"#{a.name}") instanceof DoubleRangeValidator));
    }

    public void setUpGetValidator2() throws Exception {
        this.register(DoubleRangeValidator.class, "doubleRangeValidator");
        HotDeployValidatorBuilderImpl builder = new HotDeployValidatorBuilderImpl();
        builder.setContainer(this.getContainer());
        ValidatorResource.setValidatorBuilder((ValidatorBuilder)builder);
    }

    public void tearDownGetValidator2() throws Exception {
        ValidatorResource.setValidatorBuilder(null);
    }

    public void testGetValidator2() throws Exception {
        HashMap<String, Double> properties = new HashMap<String, Double>();
        properties.put("maximum", new Double(111.0));
        properties.put("minimum", new Double(1.0));
        ValidatorResource.addValidator((String)"#{a.name}", (String)"doubleRangeValidator", properties);
        ValidatorResourceTest.assertNotNull((Object)ValidatorResource.getValidator((String)"#{a.name}"));
        ValidatorResourceTest.assertTrue((boolean)(ValidatorResource.getValidator((String)"#{a.name}") instanceof DoubleRangeValidator));
        DoubleRangeValidator dv = (DoubleRangeValidator)ValidatorResource.getValidator((String)"#{a.name}");
        ValidatorResourceTest.assertTrue((dv.getMaximum() == 111.0 ? 1 : 0) != 0);
        ValidatorResourceTest.assertTrue((dv.getMinimum() == 1.0 ? 1 : 0) != 0);
    }

    public void setUpGetValidator3() throws Exception {
        this.register(HogeDoubleRangeValidator.class, "doubleRangeValidator");
        NormalValidatorBuilderImpl builder = new NormalValidatorBuilderImpl();
        builder.setContainer(this.getContainer());
        ValidatorResource.setValidatorBuilder((ValidatorBuilder)builder);
    }

    public void tearDownGetValidator3() throws Exception {
        ValidatorResource.setValidatorBuilder(null);
    }

    public void testGetValidator3() throws Exception {
        HashMap<String, Double> properties = new HashMap<String, Double>();
        properties.put("maximum", new Double(111.0));
        ValidatorResource.addValidator((String)"#{a.name}", (String)"doubleRangeValidator", properties);
        ValidatorResourceTest.assertNotNull((Object)ValidatorResource.getValidator((String)"#{a.name}"));
        ValidatorResourceTest.assertTrue((boolean)(ValidatorResource.getValidator((String)"#{a.name}") instanceof HogeDoubleRangeValidator));
        HogeDoubleRangeValidator dv = (HogeDoubleRangeValidator)ValidatorResource.getValidator((String)"#{a.name}");
        ValidatorResourceTest.assertTrue((dv.getMaximum() == 111.0 ? 1 : 0) != 0);
        ValidatorResourceTest.assertTrue((dv.NUM == 1 ? 1 : 0) != 0);
        DoubleRangeValidator dv2 = (DoubleRangeValidator)ValidatorResource.getValidator((String)"#{a.name}");
        ValidatorResourceTest.assertTrue((dv2.getMaximum() == 111.0 ? 1 : 0) != 0);
        ValidatorResourceTest.assertTrue((dv.NUM == 2 ? 1 : 0) != 0);
    }

    public void setUpAddValidator() throws Exception {
        this.register(DoubleRangeValidator.class, "doubleRangeValidator");
        this.register(LengthValidator.class, "lengthValidator");
        HotDeployValidatorBuilderImpl builder = new HotDeployValidatorBuilderImpl();
        builder.setContainer(this.getContainer());
        ValidatorResource.setValidatorBuilder((ValidatorBuilder)builder);
    }

    public void tearDownAddValidator() throws Exception {
        ValidatorResource.setValidatorBuilder(null);
    }

    public void testAddValidator() throws Exception {
        ValidatorResource.addValidator((String)"#{a.name}", (String)"doubleRangeValidator");
        ValidatorResource.addValidator((String)"#{a.name}", (String)"lengthValidator");
        ValidatorResourceTest.assertTrue((boolean)(ValidatorResource.getValidator((String)"#{a.name}") instanceof ValidatorChain));
        ValidatorChain chain = (ValidatorChain)ValidatorResource.getValidator((String)"#{a.name}");
        ValidatorResourceTest.assertTrue((boolean)(chain.getValidator(0) instanceof DoubleRangeValidator));
        ValidatorResourceTest.assertTrue((boolean)(chain.getValidator(1) instanceof LengthValidator));
    }

    public void setUpAddValidator2() throws Exception {
        this.register(DoubleRangeValidator.class, "doubleRangeValidator");
        this.register(LengthValidator.class, "lengthValidator");
        HotDeployValidatorBuilderImpl builder = new HotDeployValidatorBuilderImpl();
        builder.setContainer(this.getContainer());
        ValidatorResource.setValidatorBuilder((ValidatorBuilder)builder);
    }

    public void tearDownAddValidator2() throws Exception {
        ValidatorResource.setValidatorBuilder(null);
    }

    public void testAddValidator2() throws Exception {
        HashMap<String, Number> properties = new HashMap<String, Number>();
        properties.put("maximum", new Double(111.0));
        properties.put("minimum", new Double(1.0));
        ValidatorResource.addValidator((String)"#{a.name}", (String)"doubleRangeValidator", properties);
        properties = new HashMap();
        properties.put("maximum", new Integer(4));
        properties.put("minimum", new Integer(1));
        ValidatorResource.addValidator((String)"#{a.name}", (String)"lengthValidator", properties);
        ValidatorResourceTest.assertTrue((boolean)(ValidatorResource.getValidator((String)"#{a.name}") instanceof ValidatorChain));
        ValidatorChain chain = (ValidatorChain)ValidatorResource.getValidator((String)"#{a.name}");
        ValidatorResourceTest.assertTrue((boolean)(chain.getValidator(0) instanceof DoubleRangeValidator));
        ValidatorResourceTest.assertTrue((boolean)(chain.getValidator(1) instanceof LengthValidator));
        DoubleRangeValidator dv = (DoubleRangeValidator)chain.getValidator(0);
        ValidatorResourceTest.assertTrue((dv.getMaximum() == 111.0 ? 1 : 0) != 0);
        ValidatorResourceTest.assertTrue((dv.getMinimum() == 1.0 ? 1 : 0) != 0);
        LengthValidator lv = (LengthValidator)chain.getValidator(1);
        ValidatorResourceTest.assertTrue((lv.getMaximum() == 4 ? 1 : 0) != 0);
        ValidatorResourceTest.assertTrue((lv.getMinimum() == 1 ? 1 : 0) != 0);
    }

    public static class HogeDoubleRangeValidator
    extends DoubleRangeValidator {
        public int NUM = 0;

        public double getMaximum() {
            ++this.NUM;
            return super.getMaximum();
        }
    }
}

