/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.render.html;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.Iterator;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.component.html.HtmlOutputLink;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.internal.IgnoreAttribute;
import javax.faces.internal.WindowIdUtil;
import org.seasar.teeda.core.render.AbstractRenderer;
import org.seasar.teeda.core.render.html.support.UrlBuilder;
import org.seasar.teeda.core.util.RendererUtil;
import org.seasar.teeda.core.util.ValueHolderUtil;

public class HtmlOutputLinkRenderer
extends AbstractRenderer {
    public static final String COMPONENT_FAMILY = "javax.faces.Output";
    public static final String RENDERER_TYPE = "javax.faces.Link";
    private final IgnoreAttribute ignoreComponent = new IgnoreAttribute();

    public HtmlOutputLinkRenderer() {
        this.ignoreComponent.addAttributeName("id");
        this.ignoreComponent.addAttributeName("value");
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        this.assertNotNull(context, component);
        if (!component.isRendered()) {
            return;
        }
        this.encodeHtmlOutputLinkBegin(context, (HtmlOutputLink)component);
    }

    protected void encodeHtmlOutputLinkBegin(FacesContext context, HtmlOutputLink htmlOutputLink) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String encoding = writer.getCharacterEncoding();
        String href = this.buildHref(context, htmlOutputLink, encoding);
        writer.startElement("a", htmlOutputLink);
        RendererUtil.renderIdAttributeIfNecessary(writer, htmlOutputLink, this.getIdForRender(context, htmlOutputLink));
        this.renderHref(context, writer, href);
        this.renderRemainAttributes(htmlOutputLink, writer, this.ignoreComponent);
    }

    protected void renderHref(FacesContext context, ResponseWriter writer, String href) throws IOException {
        writer.writeURIAttribute("href", href, null);
    }

    protected String buildHref(FacesContext context, HtmlOutputLink htmlOutputLink, String encoding) throws IOException {
        UrlBuilder urlBuilder = new UrlBuilder();
        urlBuilder.setBase(ValueHolderUtil.getValueForRender(context, htmlOutputLink));
        Iterator it = htmlOutputLink.getChildren().iterator();
        while (it.hasNext()) {
            UIComponent child = (UIComponent)it.next();
            if (!(child instanceof UIParameter)) continue;
            UIParameter parameter = (UIParameter)child;
            urlBuilder.add(URLEncoder.encode(parameter.getName(), encoding), URLEncoder.encode(this.toBlankIfNull(parameter.getValue()), encoding));
        }
        if (WindowIdUtil.isNewWindowTarget(htmlOutputLink.getTarget())) {
            urlBuilder.add("newwindow", "true");
        }
        return context.getExternalContext().encodeResourceURL(urlBuilder.build());
    }

    protected String toBlankIfNull(Object value) {
        if (value == null) {
            return "";
        }
        return value.toString();
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        this.assertNotNull(context, component);
        if (!component.isRendered()) {
            return;
        }
        this.encodeHtmlOutputLinkEnd(context, (HtmlOutputLink)component);
    }

    protected void encodeHtmlOutputLinkEnd(FacesContext context, HtmlOutputLink link) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.endElement("a");
    }

    public boolean getRendersChildren() {
        return true;
    }
}

