/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.util;

import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.seasar.teeda.core.unit.TeedaTestCase;
import org.seasar.teeda.core.util.MessageBundle;

public class MessageBundleTest
extends TeedaTestCase {
    public void testNullArg() throws Exception {
        try {
            new MessageBundle(null);
            MessageBundleTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testBlankArg() throws Exception {
        try {
            new MessageBundle("");
            MessageBundleTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetValue_canada() throws Exception {
        Locale locale = Locale.CANADA;
        this.getFacesContext().getViewRoot().setLocale(locale);
        MessageBundle messageBundle = new MessageBundle("org.seasar.teeda.core.util.MessageBundleTest_test1");
        MessageBundleTest.assertEquals((Object)"AAAA_Canada", (Object)messageBundle.get((Object)"aaaa"));
    }

    public void testGetValue_japan() throws Exception {
        Locale locale = Locale.JAPAN;
        this.getFacesContext().getViewRoot().setLocale(locale);
        MessageBundle messageBundle = new MessageBundle("org.seasar.teeda.core.util.MessageBundleTest_test1");
        MessageBundleTest.assertEquals((Object)"AAAA_default", (Object)messageBundle.get((Object)"aaaa"));
    }

    public void testGetValue_localeChange() throws Exception {
        MessageBundle messageBundle = new MessageBundle("org.seasar.teeda.core.util.MessageBundleTest_test1");
        this.getFacesContext().getViewRoot().setLocale(Locale.JAPAN);
        MessageBundleTest.assertEquals((Object)"AAAA_default", (Object)messageBundle.get((Object)"aaaa"));
        this.getFacesContext().getViewRoot().setLocale(Locale.CANADA);
        MessageBundleTest.assertEquals((Object)"AAAA_Canada", (Object)messageBundle.get((Object)"aaaa"));
        this.getFacesContext().getViewRoot().setLocale(Locale.JAPAN);
        MessageBundleTest.assertEquals((Object)"AAAA_default", (Object)messageBundle.get((Object)"aaaa"));
    }

    public void testClear() throws Exception {
        final boolean[] calls = new boolean[]{false};
        MessageBundle messageBundle = new MessageBundle("org.seasar.teeda.core.util.MessageBundleTest_test1"){

            Map getResourceBundleMap() {
                return new NullMap(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void clear() {
                        1.access$100(this.this$1)[0] = true;
                    }
                };
            }

            static /* synthetic */ boolean[] access$100(1 x0) {
                return x0.calls;
            }
        };
        messageBundle.clear();
        MessageBundleTest.assertEquals((boolean)true, (boolean)calls[0]);
    }

    public void testContainsKey() throws Exception {
        final boolean[] calls = new boolean[]{false};
        MessageBundle messageBundle = new MessageBundle("org.seasar.teeda.core.util.MessageBundleTest_test1"){

            Map getResourceBundleMap() {
                return new NullMap(this){
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public boolean containsKey(Object obj) {
                        3.access$200(this.this$1)[0] = true;
                        return false;
                    }
                };
            }

            static /* synthetic */ boolean[] access$200(3 x0) {
                return x0.calls;
            }
        };
        messageBundle.containsKey((Object)"aaa");
        MessageBundleTest.assertEquals((boolean)true, (boolean)calls[0]);
    }

    public void testContainsValue() throws Exception {
        final boolean[] calls = new boolean[]{false};
        MessageBundle messageBundle = new MessageBundle("org.seasar.teeda.core.util.MessageBundleTest_test1"){

            Map getResourceBundleMap() {
                return new NullMap(this){
                    private final /* synthetic */ 5 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public boolean containsValue(Object obj) {
                        5.access$300(this.this$1)[0] = true;
                        return false;
                    }
                };
            }

            static /* synthetic */ boolean[] access$300(5 x0) {
                return x0.calls;
            }
        };
        messageBundle.containsValue((Object)"aaa");
        MessageBundleTest.assertEquals((boolean)true, (boolean)calls[0]);
    }

    public void testEntrySet() throws Exception {
        final boolean[] calls = new boolean[]{false};
        MessageBundle messageBundle = new MessageBundle("org.seasar.teeda.core.util.MessageBundleTest_test1"){

            Map getResourceBundleMap() {
                return new NullMap(this){
                    private final /* synthetic */ 7 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public Set entrySet() {
                        7.access$400(this.this$1)[0] = true;
                        return null;
                    }
                };
            }

            static /* synthetic */ boolean[] access$400(7 x0) {
                return x0.calls;
            }
        };
        messageBundle.entrySet();
        MessageBundleTest.assertEquals((boolean)true, (boolean)calls[0]);
    }

    public void testGet() throws Exception {
        final boolean[] calls = new boolean[]{false};
        MessageBundle messageBundle = new MessageBundle("org.seasar.teeda.core.util.MessageBundleTest_test1"){

            Map getResourceBundleMap() {
                return new NullMap(this){
                    private final /* synthetic */ 9 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public Object get(Object obj) {
                        9.access$500(this.this$1)[0] = true;
                        return null;
                    }
                };
            }

            static /* synthetic */ boolean[] access$500(9 x0) {
                return x0.calls;
            }
        };
        messageBundle.get((Object)"aaaa");
        MessageBundleTest.assertEquals((boolean)true, (boolean)calls[0]);
    }

    public void testIsEmpty() throws Exception {
        final boolean[] calls = new boolean[]{false};
        MessageBundle messageBundle = new MessageBundle("org.seasar.teeda.core.util.MessageBundleTest_test1"){

            Map getResourceBundleMap() {
                return new NullMap(this){
                    private final /* synthetic */ 11 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public boolean isEmpty() {
                        11.access$600(this.this$1)[0] = true;
                        return false;
                    }
                };
            }

            static /* synthetic */ boolean[] access$600(11 x0) {
                return x0.calls;
            }
        };
        messageBundle.isEmpty();
        MessageBundleTest.assertEquals((boolean)true, (boolean)calls[0]);
    }

    public void testKeySet() throws Exception {
        final boolean[] calls = new boolean[]{false};
        MessageBundle messageBundle = new MessageBundle("org.seasar.teeda.core.util.MessageBundleTest_test1"){

            Map getResourceBundleMap() {
                return new NullMap(this){
                    private final /* synthetic */ 13 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public Set keySet() {
                        13.access$700(this.this$1)[0] = true;
                        return null;
                    }
                };
            }

            static /* synthetic */ boolean[] access$700(13 x0) {
                return x0.calls;
            }
        };
        messageBundle.keySet();
        MessageBundleTest.assertEquals((boolean)true, (boolean)calls[0]);
    }

    public void testPut() throws Exception {
        final boolean[] calls = new boolean[]{false};
        MessageBundle messageBundle = new MessageBundle("org.seasar.teeda.core.util.MessageBundleTest_test1"){

            Map getResourceBundleMap() {
                return new NullMap(this){
                    private final /* synthetic */ 15 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public Object put(Object obj, Object obj1) {
                        15.access$800(this.this$1)[0] = true;
                        return null;
                    }
                };
            }

            static /* synthetic */ boolean[] access$800(15 x0) {
                return x0.calls;
            }
        };
        messageBundle.put((Object)"a", (Object)"b");
        MessageBundleTest.assertEquals((boolean)true, (boolean)calls[0]);
    }

    public void testPutAll() throws Exception {
        final boolean[] calls = new boolean[]{false};
        MessageBundle messageBundle = new MessageBundle("org.seasar.teeda.core.util.MessageBundleTest_test1"){

            Map getResourceBundleMap() {
                return new NullMap(this){
                    private final /* synthetic */ 17 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void putAll(Map map) {
                        17.access$900(this.this$1)[0] = true;
                    }
                };
            }

            static /* synthetic */ boolean[] access$900(17 x0) {
                return x0.calls;
            }
        };
        messageBundle.putAll(null);
        MessageBundleTest.assertEquals((boolean)true, (boolean)calls[0]);
    }

    public void testRemove() throws Exception {
        final boolean[] calls = new boolean[]{false};
        MessageBundle messageBundle = new MessageBundle("org.seasar.teeda.core.util.MessageBundleTest_test1"){

            Map getResourceBundleMap() {
                return new NullMap(this){
                    private final /* synthetic */ 19 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public Object remove(Object obj) {
                        19.access$1000(this.this$1)[0] = true;
                        return null;
                    }
                };
            }

            static /* synthetic */ boolean[] access$1000(19 x0) {
                return x0.calls;
            }
        };
        messageBundle.remove((Object)"a");
        MessageBundleTest.assertEquals((boolean)true, (boolean)calls[0]);
    }

    public void testSize() throws Exception {
        final boolean[] calls = new boolean[]{false};
        MessageBundle messageBundle = new MessageBundle("org.seasar.teeda.core.util.MessageBundleTest_test1"){

            Map getResourceBundleMap() {
                return new NullMap(this){
                    private final /* synthetic */ 21 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public int size() {
                        21.access$1100(this.this$1)[0] = true;
                        return 0;
                    }
                };
            }

            static /* synthetic */ boolean[] access$1100(21 x0) {
                return x0.calls;
            }
        };
        messageBundle.size();
        MessageBundleTest.assertEquals((boolean)true, (boolean)calls[0]);
    }

    public void testValues() throws Exception {
        final boolean[] calls = new boolean[]{false};
        MessageBundle messageBundle = new MessageBundle("org.seasar.teeda.core.util.MessageBundleTest_test1"){

            Map getResourceBundleMap() {
                return new NullMap(this){
                    private final /* synthetic */ 23 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public Collection values() {
                        23.access$1200(this.this$1)[0] = true;
                        return null;
                    }
                };
            }

            static /* synthetic */ boolean[] access$1200(23 x0) {
                return x0.calls;
            }
        };
        messageBundle.values();
        MessageBundleTest.assertEquals((boolean)true, (boolean)calls[0]);
    }

    private static class NullMap
    implements Map {
        private NullMap() {
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public boolean containsKey(Object obj) {
            throw new UnsupportedOperationException();
        }

        public boolean containsValue(Object obj) {
            throw new UnsupportedOperationException();
        }

        public Set entrySet() {
            throw new UnsupportedOperationException();
        }

        public Object get(Object obj) {
            throw new UnsupportedOperationException();
        }

        public boolean isEmpty() {
            throw new UnsupportedOperationException();
        }

        public Set keySet() {
            throw new UnsupportedOperationException();
        }

        public Object put(Object obj, Object obj1) {
            throw new UnsupportedOperationException();
        }

        public void putAll(Map map) {
            throw new UnsupportedOperationException();
        }

        public Object remove(Object obj) {
            throw new UnsupportedOperationException();
        }

        public int size() {
            throw new UnsupportedOperationException();
        }

        public Collection values() {
            throw new UnsupportedOperationException();
        }
    }
}

