/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.unit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import org.seasar.framework.exception.ResourceNotFoundRuntimeException;
import org.seasar.framework.util.InputStreamReaderUtil;
import org.seasar.framework.util.ReaderUtil;
import org.seasar.framework.util.ResourceUtil;

public class TestUtil {
    public static String readText(Class clazz, String fileName, String encoding) {
        String pathByClass = clazz.getName().replace('.', '/') + "_" + fileName;
        InputStream is = null;
        try {
            is = ResourceUtil.getResourceAsStream((String)pathByClass);
        }
        catch (ResourceNotFoundRuntimeException e) {
            String pathByPackage = clazz.getPackage().getName().replace('.', '/') + "/" + fileName;
            is = ResourceUtil.getResourceAsStream((String)pathByPackage);
        }
        InputStreamReader reader = InputStreamReaderUtil.create((InputStream)is, (String)encoding);
        return ReaderUtil.readText((Reader)reader);
    }

    public static Object serializeAndDeserialize(Object input) throws IOException, ClassNotFoundException {
        byte[] serialized = TestUtil.serialize(input);
        Object output = TestUtil.deserialize(serialized);
        return output;
    }

    private static Object deserialize(byte[] byteArray) throws IOException, ClassNotFoundException {
        ByteArrayInputStream bais = new ByteArrayInputStream(byteArray);
        ObjectInputStream ois = new ObjectInputStream(bais);
        Object output = ois.readObject();
        ois.close();
        return output;
    }

    private static byte[] serialize(Object input) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(input);
        oos.close();
        return baos.toByteArray();
    }
}

