/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.unit;

import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import org.seasar.teeda.core.unit.ExceptionalClosure;

public class ExceptionAssert {
    public static void assertMessageExist(Throwable th) {
        String message = th.getMessage();
        try {
            Assert.assertNotNull((String)"Throwable should have message", (Object)message);
            Assert.assertTrue((String)"Throwable should have message", (message.trim().length() > 0 ? 1 : 0) != 0);
        }
        catch (AssertionFailedError afe) {
            th.printStackTrace();
            throw afe;
        }
    }

    public static void assertThrows(Class expected, ExceptionalClosure closure) {
        Assert.assertNotNull((String)"expected", (Object)expected);
        Assert.assertNotNull((String)"closure", (Object)closure);
        boolean thrown = false;
        try {
            closure.execute();
        }
        catch (Throwable th) {
            thrown = true;
            if (expected.isAssignableFrom(th.getClass())) {
                ExceptionAssert.assertMessageExist(th);
            }
            Assert.fail((String)("Expected <" + expected.getName() + "> is not thrown. But was <" + th + ">"));
        }
        if (!thrown) {
            Assert.fail((String)("Expected <" + expected.getName() + "> is not thrown."));
        }
    }

    static void assertContains(String shouldBeContained, String value) {
        Assert.assertEquals((boolean)true, (value.indexOf(shouldBeContained) > -1 ? 1 : 0) != 0);
    }

    static void assertNotEquals(Object expected, Object actual) {
        AssertionFailedError afe = null;
        try {
            Assert.assertEquals((Object)expected, (Object)actual);
        }
        catch (AssertionFailedError e) {
            afe = e;
        }
        if (afe == null) {
            Assert.fail((String)("should not be equals. expected:<" + expected + "> actual:<" + actual + ">"));
        }
    }
}

