/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.render.html;

import javax.faces.component.UIComponent;
import javax.faces.component.UISelectItem;
import javax.faces.component.UISelectItems;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import javax.faces.model.SelectItemGroup;
import javax.faces.render.Renderer;
import javax.faces.render.RendererTest;
import junitx.framework.ArrayAssert;
import org.custommonkey.xmlunit.Diff;
import org.seasar.teeda.core.mock.MockFacesContext;
import org.seasar.teeda.core.mock.MockHtmlSelectManyMenu;
import org.seasar.teeda.core.render.html.HtmlSelectManyMenuRenderer;

public class HtmlSelectManyMenuRendererTest
extends RendererTest {
    private HtmlSelectManyMenuRenderer renderer;
    private MockHtmlSelectManyMenu htmlSelectManyMenu;

    protected void setUp() throws Exception {
        super.setUp();
        this.renderer = this.createHtmlSelectManyMenuRenderer();
        this.htmlSelectManyMenu = new MockHtmlSelectManyMenu();
        this.htmlSelectManyMenu.setRenderer((Renderer)this.renderer);
        this.renderer.addIgnoreAttributeName("setSubmittedValueCalls");
    }

    public void testEncode_NoChild() throws Exception {
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectManyMenu);
        HtmlSelectManyMenuRendererTest.assertEquals((String)"", (String)this.getResponseText());
    }

    public void testEncode_RenderFalse() throws Exception {
        this.htmlSelectManyMenu.setRendered(false);
        UISelectItem selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"val");
        selectItem.setItemLabel("lab");
        this.htmlSelectManyMenu.getChildren().add(selectItem);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectManyMenu);
        HtmlSelectManyMenuRendererTest.assertEquals((String)"", (String)this.getResponseText());
    }

    public void testEncode_Child() throws Exception {
        UISelectItem selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"v");
        selectItem.setItemLabel("l");
        this.htmlSelectManyMenu.getChildren().add(selectItem);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectManyMenu);
        HtmlSelectManyMenuRendererTest.assertEquals((String)"<select name=\"_id0\" multiple=\"multiple\" size=\"1\"><option value=\"v\">l</option></select>", (String)this.getResponseText());
    }

    public void testEncode_Id() throws Exception {
        UISelectItem selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"val");
        selectItem.setItemLabel("lab");
        this.htmlSelectManyMenu.getChildren().add(selectItem);
        this.htmlSelectManyMenu.setId("a");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectManyMenu);
        HtmlSelectManyMenuRendererTest.assertEquals((String)"<select id=\"a\" name=\"a\" multiple=\"multiple\" size=\"1\"><option value=\"val\">lab</option></select>", (String)this.getResponseText());
    }

    public void testEncode_WithUnknownAttribute1() throws Exception {
        UISelectItem selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"val");
        selectItem.setItemLabel("lab");
        this.htmlSelectManyMenu.getChildren().add(selectItem);
        this.htmlSelectManyMenu.setId("a");
        this.htmlSelectManyMenu.getAttributes().put("a1", "b1");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectManyMenu);
        HtmlSelectManyMenuRendererTest.assertEquals((String)"<select id=\"a\" name=\"a\" multiple=\"multiple\" size=\"1\" a1=\"b1\"><option value=\"val\">lab</option></select>", (String)this.getResponseText());
    }

    public void testEncode_WithUnknownAttribute2() throws Exception {
        UISelectItem selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"val");
        selectItem.setItemLabel("lab");
        this.htmlSelectManyMenu.getChildren().add(selectItem);
        this.htmlSelectManyMenu.setId("a");
        this.htmlSelectManyMenu.getAttributes().put("a.1", "b1");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectManyMenu);
        HtmlSelectManyMenuRendererTest.assertEquals((String)"<select id=\"a\" name=\"a\" multiple=\"multiple\" size=\"1\"><option value=\"val\">lab</option></select>", (String)this.getResponseText());
    }

    public void testEncode_Children() throws Exception {
        UISelectItem selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"v1");
        selectItem.setItemLabel("l1");
        this.htmlSelectManyMenu.getChildren().add(selectItem);
        selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"v2");
        selectItem.setItemLabel("l2");
        this.htmlSelectManyMenu.getChildren().add(selectItem);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectManyMenu);
        HtmlSelectManyMenuRendererTest.assertEquals((String)"<select name=\"_id0\" multiple=\"multiple\" size=\"1\"><option value=\"v1\">l1</option><option value=\"v2\">l2</option></select>", (String)this.getResponseText());
    }

    public void testEncode_Selected() throws Exception {
        this.htmlSelectManyMenu.setSelectedValues(new String[]{"v2"});
        UISelectItem selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"v1");
        selectItem.setItemLabel("l1");
        this.htmlSelectManyMenu.getChildren().add(selectItem);
        selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"v2");
        selectItem.setItemLabel("l2");
        this.htmlSelectManyMenu.getChildren().add(selectItem);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectManyMenu);
        HtmlSelectManyMenuRendererTest.assertEquals((String)"<select name=\"_id0\" multiple=\"multiple\" size=\"1\"><option value=\"v1\">l1</option><option value=\"v2\" selected=\"selected\">l2</option></select>", (String)this.getResponseText());
    }

    public void testEncode_ItemDisabled() throws Exception {
        UISelectItem selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"v1");
        selectItem.setItemLabel("l1");
        selectItem.setItemDisabled(true);
        this.htmlSelectManyMenu.getChildren().add(selectItem);
        selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"v2");
        selectItem.setItemLabel("l2");
        this.htmlSelectManyMenu.getChildren().add(selectItem);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectManyMenu);
        HtmlSelectManyMenuRendererTest.assertEquals((String)"<select name=\"_id0\" multiple=\"multiple\" size=\"1\"><option value=\"v1\" disabled=\"disabled\">l1</option><option value=\"v2\">l2</option></select>", (String)this.getResponseText());
    }

    public void testEncode_Disabled() throws Exception {
        this.htmlSelectManyMenu.setDisabled(true);
        UISelectItem selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"v1");
        selectItem.setItemLabel("l1");
        selectItem.setItemDisabled(true);
        this.htmlSelectManyMenu.getChildren().add(selectItem);
        selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"v2");
        selectItem.setItemLabel("l2");
        this.htmlSelectManyMenu.getChildren().add(selectItem);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectManyMenu);
        HtmlSelectManyMenuRendererTest.assertEquals((String)"<select name=\"_id0\" multiple=\"multiple\" size=\"1\" disabled=\"disabled\"><option value=\"v1\" disabled=\"disabled\">l1</option><option value=\"v2\">l2</option></select>", (String)this.getResponseText());
    }

    public void testEncode_LabelClass() throws Exception {
        this.htmlSelectManyMenu.setEnabledClass("ec");
        this.htmlSelectManyMenu.setDisabledClass("dc");
        UISelectItem selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"v1");
        selectItem.setItemLabel("l1");
        this.htmlSelectManyMenu.getChildren().add(selectItem);
        selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"v2");
        selectItem.setItemLabel("l2");
        selectItem.setItemDisabled(true);
        this.htmlSelectManyMenu.getChildren().add(selectItem);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectManyMenu);
        HtmlSelectManyMenuRendererTest.assertEquals((String)"<select name=\"_id0\" multiple=\"multiple\" size=\"1\"><option value=\"v1\" class=\"ec\">l1</option><option value=\"v2\" class=\"dc\" disabled=\"disabled\">l2</option></select>", (String)this.getResponseText());
    }

    public void testEncode_GroupChildren() throws Exception {
        UISelectItems selectItems = new UISelectItems();
        SelectItem item1 = new SelectItem((Object)"v1", "l1");
        SelectItem item2 = new SelectItem((Object)"v2", "l2", null, true);
        selectItems.setValue((Object)new SelectItem[]{item1, item2});
        this.htmlSelectManyMenu.getChildren().add(selectItems);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectManyMenu);
        HtmlSelectManyMenuRendererTest.assertEquals((String)"<select name=\"_id0\" multiple=\"multiple\" size=\"1\"><option value=\"v1\">l1</option><option value=\"v2\" disabled=\"disabled\">l2</option></select>", (String)this.getResponseText());
    }

    public void testEncode_Optgroup() throws Exception {
        SelectItem item1 = new SelectItem((Object)"v1", "l1");
        SelectItem item2 = new SelectItem((Object)"v2", "l2", null, true);
        SelectItemGroup group = new SelectItemGroup("gl");
        group.setSelectItems(new SelectItem[]{item1, item2});
        UISelectItem selectItem = new UISelectItem();
        selectItem.setValue((Object)group);
        this.htmlSelectManyMenu.getChildren().add(selectItem);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectManyMenu);
        HtmlSelectManyMenuRendererTest.assertEquals((String)"<select name=\"_id0\" multiple=\"multiple\" size=\"1\"><optgroup label=\"gl\"><option value=\"v1\">l1</option><option value=\"v2\" disabled=\"disabled\">l2</option></optgroup></select>", (String)this.getResponseText());
    }

    public void testEncode_WithAllAttributes() throws Exception {
        this.htmlSelectManyMenu.setAccesskey("a");
        this.htmlSelectManyMenu.setDir("b");
        this.htmlSelectManyMenu.setDisabled(true);
        this.htmlSelectManyMenu.setDisabledClass("d");
        this.htmlSelectManyMenu.setEnabledClass("e");
        this.htmlSelectManyMenu.setLang("f");
        this.htmlSelectManyMenu.setOnblur("g");
        this.htmlSelectManyMenu.setOnchange("h");
        this.htmlSelectManyMenu.setOnclick("i");
        this.htmlSelectManyMenu.setOndblclick("j");
        this.htmlSelectManyMenu.setOnfocus("k");
        this.htmlSelectManyMenu.setOnkeydown("l");
        this.htmlSelectManyMenu.setOnkeypress("m");
        this.htmlSelectManyMenu.setOnkeyup("n");
        this.htmlSelectManyMenu.setOnmousedown("o");
        this.htmlSelectManyMenu.setOnmousemove("p");
        this.htmlSelectManyMenu.setOnmouseout("q");
        this.htmlSelectManyMenu.setOnmouseover("r");
        this.htmlSelectManyMenu.setOnmouseup("s");
        this.htmlSelectManyMenu.setOnselect("t");
        this.htmlSelectManyMenu.setReadonly(true);
        this.htmlSelectManyMenu.setStyle("w");
        this.htmlSelectManyMenu.setStyleClass("u");
        this.htmlSelectManyMenu.setTabindex("x");
        this.htmlSelectManyMenu.setTitle("y");
        this.htmlSelectManyMenu.getAttributes().put("name", "hoge");
        this.htmlSelectManyMenu.setId("A");
        this.htmlSelectManyMenu.setValue(new String[]{"val"});
        UISelectItem selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"val");
        selectItem.setItemLabel("lab");
        selectItem.getAttributes().put("selected", "selected");
        this.htmlSelectManyMenu.getChildren().add(selectItem);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectManyMenu);
        Diff diff = new Diff("<select id=\"A\" name=\"A\" multiple=\"multiple\" size=\"1\" style=\"w\" class=\"u\" accesskey=\"a\" dir=\"b\" disabled=\"disabled\" lang=\"f\" onblur=\"g\" onchange=\"h\" onclick=\"i\" ondblclick=\"j\" onfocus=\"k\" onkeydown=\"l\" onkeypress=\"m\" onkeyup=\"n\" onmousedown=\"o\" onmousemove=\"p\" onmouseout=\"q\" onmouseover=\"r\" onmouseup=\"s\" onselect=\"t\" readonly=\"readonly\" tabindex=\"x\" title=\"y\"><option value=\"val\" class=\"d\" selected=\"selected\">lab</option></select>", this.getResponseText());
        HtmlSelectManyMenuRendererTest.assertEquals((String)diff.toString(), (boolean)true, (boolean)diff.identical());
    }

    public void testDecode_RequestParameterNotExist() throws Exception {
        this.htmlSelectManyMenu.setClientId("key");
        this.renderer.decode((FacesContext)this.getFacesContext(), (UIComponent)this.htmlSelectManyMenu);
        HtmlSelectManyMenuRendererTest.assertEquals((int)1, (int)this.htmlSelectManyMenu.getSetSubmittedValueCalls());
        String[] submittedValue = (String[])this.htmlSelectManyMenu.getSubmittedValue();
        HtmlSelectManyMenuRendererTest.assertEquals((int)0, (int)submittedValue.length);
    }

    public void testDecodeSuccess() throws Exception {
        this.htmlSelectManyMenu.setClientId("keyA");
        MockFacesContext context = this.getFacesContext();
        context.getExternalContext().getRequestParameterValuesMap().put("keyA", new String[]{"a", "b", "c"});
        this.renderer.decode((FacesContext)context, (UIComponent)this.htmlSelectManyMenu);
        HtmlSelectManyMenuRendererTest.assertEquals((int)1, (int)this.htmlSelectManyMenu.getSetSubmittedValueCalls());
        ArrayAssert.assertEquivalenceArrays((Object[])new String[]{"a", "b", "c"}, (Object[])((Object[])this.htmlSelectManyMenu.getSubmittedValue()));
    }

    public void testGetRendersChildren() throws Exception {
        HtmlSelectManyMenuRendererTest.assertEquals((boolean)false, (boolean)this.renderer.getRendersChildren());
    }

    private HtmlSelectManyMenuRenderer createHtmlSelectManyMenuRenderer() {
        return (HtmlSelectManyMenuRenderer)this.createRenderer();
    }

    protected Renderer createRenderer() {
        HtmlSelectManyMenuRenderer renderer = new HtmlSelectManyMenuRenderer();
        renderer.setComponentIdLookupStrategy(this.getComponentIdLookupStrategy());
        return renderer;
    }
}

