/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.config.faces.impl;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import junitx.framework.ListAssert;
import junitx.framework.ObjectAssert;
import junitx.framework.ThrowableAssert;
import org.seasar.teeda.core.config.faces.element.FacesConfig;
import org.seasar.teeda.core.config.faces.element.ReferencedBeanElement;
import org.seasar.teeda.core.config.faces.element.impl.FacesConfigImpl;
import org.seasar.teeda.core.config.faces.element.impl.ReferencedBeanElementImpl;
import org.seasar.teeda.core.config.faces.impl.FacesConfigUtil;

public class FacesConfigUtilTest
extends TestCase {
    public FacesConfigUtilTest(String name) {
        super(name);
    }

    public void testCollectAllFacesConfig() throws Exception {
        ArrayList<FacesConfigImpl> list = new ArrayList<FacesConfigImpl>();
        FacesConfigImpl config = new FacesConfigImpl();
        ReferencedBeanElementImpl ref1 = new ReferencedBeanElementImpl();
        ref1.setReferencedBeanName("name1");
        ref1.setReferencedBeanClass("class1");
        config.addReferencedBeanElement((ReferencedBeanElement)ref1);
        ReferencedBeanElementImpl ref2 = new ReferencedBeanElementImpl();
        ref1.setReferencedBeanName("name2");
        ref1.setReferencedBeanClass("class2");
        config.addReferencedBeanElement((ReferencedBeanElement)ref2);
        list.add(config);
        FacesConfig f = FacesConfigUtil.collectAllFacesConfig(list);
        List l = f.getReferencedBeanElements();
        ListAssert.assertContains((List)l, (Object)ref1);
        ListAssert.assertContains((List)l, (Object)ref2);
        ObjectAssert.assertSame((Object)ref1, l.get(0));
        ObjectAssert.assertSame((Object)ref2, l.get(1));
    }

    public void testIsAllFacesConfig() throws Exception {
        try {
            FacesConfigUtil.isAllFacesConfig(null);
            FacesConfigUtilTest.fail();
        }
        catch (Exception expected) {
            ThrowableAssert.assertEquals((Throwable)expected, (Throwable)new IllegalArgumentException());
        }
        ArrayList<String> list = null;
        try {
            list = new ArrayList<String>();
            list.add("aaa");
            FacesConfigUtil.isAllFacesConfig(list);
            FacesConfigUtilTest.fail();
        }
        catch (Exception expected) {
            ThrowableAssert.assertEquals((Throwable)expected, (Throwable)new IllegalStateException());
        }
        try {
            list = new ArrayList();
            list.add((String)new FacesConfigImpl());
            FacesConfigUtil.isAllFacesConfig(list);
        }
        catch (Exception e) {
            FacesConfigUtilTest.fail();
        }
    }
}

