/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.config.faces.impl;

import java.util.List;
import junit.framework.TestCase;
import org.seasar.teeda.core.config.faces.element.FacesConfig;
import org.seasar.teeda.core.config.faces.element.FactoryElement;
import org.seasar.teeda.core.config.faces.impl.ApplicationFacesConfigurator;
import org.seasar.teeda.core.mock.MockApplicationFactory;
import org.seasar.teeda.core.mock.MockFacesContextFactory;
import org.seasar.teeda.core.mock.MockLifecycleFactory;
import org.seasar.teeda.core.mock.MockRenderKitFactory;

public class ApplicationFacesConfiguratorTest
extends TestCase {
    public void testConfigure() throws Exception {
        String path = ((Object)((Object)this)).getClass().getPackage().getName().replaceAll("\\.", "/") + "/" + "faces-config.xml";
        TargetApplicationFacesConfigurator configurator = new TargetApplicationFacesConfigurator(path);
        FacesConfig facesConfig = configurator.configure();
        ApplicationFacesConfiguratorTest.assertNotNull((Object)facesConfig);
        List factories = facesConfig.getFactoryElements();
        FactoryElement factory = (FactoryElement)factories.get(0);
        ApplicationFacesConfiguratorTest.assertNotNull((Object)factory);
        ApplicationFacesConfiguratorTest.assertEquals((Object)MockApplicationFactory.class.getName(), factory.getApplicationFactories().get(0));
        ApplicationFacesConfiguratorTest.assertEquals((Object)MockFacesContextFactory.class.getName(), factory.getFacesContextFactories().get(0));
        ApplicationFacesConfiguratorTest.assertEquals((Object)MockLifecycleFactory.class.getName(), factory.getLifecycleFactories().get(0));
        ApplicationFacesConfiguratorTest.assertEquals((Object)MockRenderKitFactory.class.getName(), factory.getRenderKitFactories().get(0));
    }

    private static class TargetApplicationFacesConfigurator
    extends ApplicationFacesConfigurator {
        private String path_;

        public TargetApplicationFacesConfigurator(String path) {
            this.path_ = path;
        }

        public String getPath() {
            return this.path_;
        }
    }
}

