/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.internal;

import java.util.ArrayList;
import java.util.HashMap;
import javax.faces.application.ApplicationFactory;
import javax.faces.internal.FactoryFinderUtil;
import junit.framework.TestCase;
import org.seasar.teeda.core.mock.MockApplicationFactory;
import org.seasar.teeda.core.mock.MockApplicationFactory2;

public class FactoryFinderUtilTest
extends TestCase {
    public void testCheckValidFactoryNames() {
        String name = "javax.faces.application.ApplicationFactory";
        try {
            FactoryFinderUtil.checkValidFactoryNames((String)name);
        }
        catch (Exception e) {
            FactoryFinderUtilTest.fail();
        }
        try {
            FactoryFinderUtil.checkValidFactoryNames((String)"notFactoryname");
            FactoryFinderUtilTest.fail();
        }
        catch (IllegalArgumentException e) {
            FactoryFinderUtilTest.assertTrue((boolean)true);
        }
    }

    public void testGetClassLoader() {
        FactoryFinderUtilTest.assertNotNull((Object)FactoryFinderUtil.getClassLoader());
    }

    public void testGetAbstractFactoryClass() {
        Class clazz = FactoryFinderUtil.getAbstractFactoryClass((String)"javax.faces.context.FacesContextFactory");
        FactoryFinderUtilTest.assertEquals((String)"javax.faces.context.FacesContextFactory", (String)clazz.getName());
        clazz = FactoryFinderUtil.getAbstractFactoryClass((String)"aaa");
        FactoryFinderUtilTest.assertNull((Object)clazz);
    }

    public void testCreateFactoryInstance() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("org.seasar.teeda.core.mock.MockApplicationFactory");
        Object o = FactoryFinderUtil.createFactoryInstance((String)"javax.faces.application.ApplicationFactory", list);
        FactoryFinderUtilTest.assertNotNull((Object)o);
        FactoryFinderUtilTest.assertEquals((String)"org.seasar.teeda.core.mock.MockApplicationFactory", (String)o.getClass().getName());
        list = new ArrayList();
        list.add("javax.faces.internal.FactoryFinderUtilTest");
        try {
            o = FactoryFinderUtil.createFactoryInstance((String)"javax.faces.application.ApplicationFactory", list);
            FactoryFinderUtilTest.fail();
        }
        catch (IllegalArgumentException e) {
            FactoryFinderUtilTest.assertTrue((boolean)true);
        }
    }

    public void testGetCurrentInstanceByConstructor() {
        MockApplicationFactory f = new MockApplicationFactory();
        Class implClass = MockApplicationFactory2.class;
        Class abstractClass = ApplicationFactory.class;
        Object result = null;
        try {
            result = FactoryFinderUtil.getCurrentFactoryInstance((Class)implClass, (Class)abstractClass, (Object)f);
        }
        catch (Exception e) {
            FactoryFinderUtilTest.fail();
        }
        FactoryFinderUtilTest.assertNotNull((Object)result);
        FactoryFinderUtilTest.assertTrue((boolean)(result instanceof ApplicationFactory));
    }

    public void testIsAlreadySetFactory() {
        HashMap<String, String> map = new HashMap<String, String>();
        FactoryFinderUtilTest.assertFalse((boolean)FactoryFinderUtil.isAlreadySetFactory(map, (String)"aaa"));
        map.put("aaa", "aaa");
        FactoryFinderUtilTest.assertTrue((boolean)FactoryFinderUtil.isAlreadySetFactory(map, (String)"aaa"));
    }
}

