/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.util;

import java.util.List;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import org.seasar.teeda.core.unit.TeedaTestCase;
import org.seasar.teeda.core.util.UIParameterUtil;

public class UIParameterUtilTest
extends TeedaTestCase {
    public void testSaveParametersToRequest() throws Exception {
        UICommand command = new UICommand();
        List childrenList = command.getChildren();
        UIParameter parameter1 = new UIParameter();
        parameter1.setName("aaa");
        parameter1.setValue((Object)"AAA");
        childrenList.add(parameter1);
        UIParameter parameter2 = new UIParameter();
        parameter2.setName("bbb");
        parameter2.setValue((Object)"BBB");
        childrenList.add(parameter2);
        UIParameterUtil.saveParametersToRequest((UIComponent)command, (FacesContext)this.getFacesContext());
        UIParameterUtilTest.assertEquals((Object)"AAA", this.getFacesContext().getExternalContext().getRequestMap().get("aaa"));
        UIParameterUtilTest.assertEquals((Object)"BBB", this.getFacesContext().getExternalContext().getRequestMap().get("bbb"));
    }

    public void testSaveParameterToInstance() throws Exception {
        UICommand command = new UICommand();
        List childrenList = command.getChildren();
        UIParameter parameter1 = new UIParameter();
        parameter1.setName("aaa");
        parameter1.setValue((Object)"AAA");
        childrenList.add(parameter1);
        UIParameter parameter2 = new UIParameter();
        parameter2.setName("bbb");
        parameter2.setValue((Object)"2");
        childrenList.add(parameter2);
        Hoge hoge = new Hoge();
        UIParameterUtil.saveParametersToInstance((UIComponent)command, (Object)hoge);
        UIParameterUtilTest.assertEquals((String)"AAA", (String)hoge.getAaa());
        UIParameterUtilTest.assertTrue((hoge.getBbb() == 2 ? 1 : 0) != 0);
    }

    public static class Hoge {
        private String aaa;
        private int bbb;

        public String getAaa() {
            return this.aaa;
        }

        public void setAaa(String aaa) {
            this.aaa = aaa;
        }

        public int getBbb() {
            return this.bbb;
        }

        public void setBbb(int bbb) {
            this.bbb = bbb;
        }
    }
}

