/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.taglib.core;

import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.validator.DoubleRangeValidator;
import javax.faces.validator.Validator;
import org.seasar.teeda.core.mock.MockApplication;
import org.seasar.teeda.core.mock.MockApplicationImpl;
import org.seasar.teeda.core.mock.MockValueBinding;
import org.seasar.teeda.core.taglib.core.ValidateDoubleRangeTag;
import org.seasar.teeda.core.unit.TeedaTestCase;

public class ValidateDoubleRangeTagTest
extends TeedaTestCase {
    public void testCreateValidator() throws Exception {
        String validatorId = "javax.faces.DoubleRange";
        String validatorClassName = "javax.faces.validator.DoubleRangeValidator";
        MockApplicationImpl app = new MockApplicationImpl();
        app.addValidator(validatorId, validatorClassName);
        this.setApplication((MockApplication)app);
        ValidateDoubleRangeTag tag = new ValidateDoubleRangeTag();
        Validator validator = tag.createValidator();
        ValidateDoubleRangeTagTest.assertNotNull((Object)validator);
        ValidateDoubleRangeTagTest.assertTrue((boolean)(validator instanceof DoubleRangeValidator));
    }

    public void testCreateValidator_NotAddValidator() throws Exception {
        ValidateDoubleRangeTag tag = new ValidateDoubleRangeTag();
        try {
            tag.createValidator();
            ValidateDoubleRangeTagTest.fail();
        }
        catch (NullPointerException e) {
            ValidateDoubleRangeTagTest.success();
        }
    }

    public void testCreateValidator_noSetProperty() throws Exception {
        this.addValidator();
        ValidateDoubleRangeTag tag = new ValidateDoubleRangeTag();
        tag.createValidator();
        ValidateDoubleRangeTagTest.assertFalse((boolean)tag.isMinimumSet());
        ValidateDoubleRangeTagTest.assertFalse((boolean)tag.isMaximumSet());
    }

    public void testSetMinimum_constantValue() throws Exception {
        this.addValidator();
        ValidateDoubleRangeTag tag = new ValidateDoubleRangeTag();
        tag.setMinimum("11.01");
        DoubleRangeValidator validator = (DoubleRangeValidator)tag.createValidator();
        ValidateDoubleRangeTagTest.assertTrue((boolean)tag.isMinimumSet());
        ValidateDoubleRangeTagTest.assertTrue((11.01 == validator.getMinimum() ? 1 : 0) != 0);
    }

    public void testSetMinimum_bindingValue() throws Exception {
        this.addValidator();
        MockValueBinding vb = new MockValueBinding();
        vb.setValue((FacesContext)this.getFacesContext(), (Object)new Double(321.01));
        this.getApplication().setValueBinding((ValueBinding)vb);
        ValidateDoubleRangeTag tag = new ValidateDoubleRangeTag();
        tag.setMinimum("#{hoge.minimum}");
        DoubleRangeValidator validator = (DoubleRangeValidator)tag.createValidator();
        ValidateDoubleRangeTagTest.assertTrue((boolean)tag.isMinimumSet());
        ValidateDoubleRangeTagTest.assertTrue((321.01 == validator.getMinimum() ? 1 : 0) != 0);
    }

    public void testSetMaximum_constantValue() throws Exception {
        this.addValidator();
        ValidateDoubleRangeTag tag = new ValidateDoubleRangeTag();
        tag.setMaximum("543.21");
        DoubleRangeValidator validator = (DoubleRangeValidator)tag.createValidator();
        ValidateDoubleRangeTagTest.assertTrue((boolean)tag.isMaximumSet());
        ValidateDoubleRangeTagTest.assertTrue((543.21 == validator.getMaximum() ? 1 : 0) != 0);
    }

    public void testSetMaximum_bindingValue() throws Exception {
        this.addValidator();
        MockValueBinding vb = new MockValueBinding();
        vb.setValue((FacesContext)this.getFacesContext(), (Object)new Double(999.99));
        this.getApplication().setValueBinding((ValueBinding)vb);
        ValidateDoubleRangeTag tag = new ValidateDoubleRangeTag();
        tag.setMaximum("#{hoge.maximum}");
        DoubleRangeValidator validator = (DoubleRangeValidator)tag.createValidator();
        ValidateDoubleRangeTagTest.assertTrue((boolean)tag.isMaximumSet());
        ValidateDoubleRangeTagTest.assertTrue((999.99 == validator.getMaximum() ? 1 : 0) != 0);
    }

    private void addValidator() throws Exception {
        MockApplicationImpl app = new MockApplicationImpl();
        app.addValidator("javax.faces.DoubleRange", "javax.faces.validator.DoubleRangeValidator");
        this.setApplication((MockApplication)app);
    }
}

