/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.render.html;

import java.util.Map;
import javax.faces.application.StateManager;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.custommonkey.xmlunit.Diff;
import org.seasar.teeda.core.render.AbstractResponseStateManager;
import org.seasar.teeda.core.render.EncodeConverter;
import org.seasar.teeda.core.render.html.HtmlResponseStateManager;
import org.seasar.teeda.core.render.html.StructureAndState;
import org.seasar.teeda.core.unit.TeedaTestCase;

public class HtmlResponseStateManagerTest
extends TeedaTestCase {
    public void testWriteState_getEncodeInClient() throws Exception {
        this.setupStateSavingInClient();
        this.getFacesContext().getViewRoot().setViewId("hogeViewId");
        StateManager stateManager = this.getApplication().getStateManager();
        NullEncodeConverter converter = new NullEncodeConverter(){

            public String getAsEncodeString(Object target) {
                return "encodedString";
            }
        };
        HtmlResponseStateManager responseStateManager = new HtmlResponseStateManager();
        responseStateManager.setEncodeConverter((EncodeConverter)converter);
        StateManager stateManager2 = stateManager;
        stateManager2.getClass();
        StateManager.SerializedView serializedView = new StateManager.SerializedView(stateManager2, (Object)"bbbStructure", (Object)"cccState");
        responseStateManager.writeState((FacesContext)this.getFacesContext(), serializedView);
        HtmlResponseStateManagerTest.assertEquals((String)("<input type=\"hidden\" name=\"javax.faces.ViewState\" id=\"javax.faces.ViewState\" value=\"encodedString\" /><input type=\"hidden\" name=\"" + AbstractResponseStateManager.VIEW_ID + "\" id=\"" + AbstractResponseStateManager.VIEW_ID + "\" value=\"hogeViewId\" />"), (String)this.getResponseText());
    }

    public void testWriteState_getEncodeInServer() throws Exception {
        this.setupStateSavingInServer();
        this.getFacesContext().getViewRoot().setViewId("fooViewId");
        StateManager stateManager = this.getApplication().getStateManager();
        NullEncodeConverter converter = new NullEncodeConverter();
        HtmlResponseStateManager responseStateManager = new HtmlResponseStateManager();
        responseStateManager.setEncodeConverter((EncodeConverter)converter);
        StateManager stateManager2 = stateManager;
        stateManager2.getClass();
        StateManager.SerializedView view = new StateManager.SerializedView(stateManager2, (Object)"aaaStructure", (Object)"b");
        responseStateManager.writeState((FacesContext)this.getFacesContext(), view);
        HtmlResponseStateManagerTest.assertEquals((String)("<input type=\"hidden\" name=\"javax.faces.ViewState\" id=\"javax.faces.ViewState\" value=\"aaaStructure\" /><input type=\"hidden\" name=\"" + AbstractResponseStateManager.VIEW_ID + "\" id=\"" + AbstractResponseStateManager.VIEW_ID + "\" value=\"fooViewId\" />"), (String)this.getResponseText());
    }

    public void testGetComponentStateToRestore1() throws Exception {
        this.getExternalContext().getRequestMap().put(AbstractResponseStateManager.FACES_VIEW_STATE, "hoge");
        HtmlResponseStateManager responseStateManager = new HtmlResponseStateManager();
        Object o = responseStateManager.getComponentStateToRestore((FacesContext)this.getFacesContext());
        HtmlResponseStateManagerTest.assertEquals((Object)"hoge", (Object)o);
        HtmlResponseStateManagerTest.assertNull(this.getExternalContext().getRequestMap().get(AbstractResponseStateManager.FACES_VIEW_STATE));
    }

    public void testGetComponentStateToRestore2() throws Exception {
        HtmlResponseStateManager responseStateManager = new HtmlResponseStateManager();
        Object o = responseStateManager.getComponentStateToRestore((FacesContext)this.getFacesContext());
        HtmlResponseStateManagerTest.assertNull((Object)o);
    }

    public void testGetTreeStructureToRestore_emptyValue() throws Exception {
        HtmlResponseStateManager manager = new HtmlResponseStateManager();
        HtmlResponseStateManagerTest.assertNull((Object)manager.getTreeStructureToRestore((FacesContext)this.getFacesContext(), "a"));
    }

    public void testGetTreeStructureToRestore_getDecodedInClient() throws Exception {
        this.setupStateSavingInClient();
        final Object[] args = new Object[1];
        NullEncodeConverter converter = new NullEncodeConverter(){

            public Object getAsDecodeObject(String state) {
                args[0] = state;
                return new StructureAndState((Object)"aaaStructure", (Object)"b");
            }
        };
        Map requestParameterMap = this.getFacesContext().getExternalContext().getRequestParameterMap();
        requestParameterMap.put("javax.faces.ViewState", "fooStateParam");
        requestParameterMap.put(AbstractResponseStateManager.VIEW_ID, "hogeViewId");
        HtmlResponseStateManager responseStateManager = new HtmlResponseStateManager();
        HtmlResponseStateManagerTest.assertEquals((boolean)true, (boolean)responseStateManager.isSavingStateInClient((FacesContext)this.getFacesContext()));
        responseStateManager.setEncodeConverter((EncodeConverter)converter);
        Object restoredStructure = responseStateManager.getTreeStructureToRestore((FacesContext)this.getFacesContext(), "hogeViewId");
        HtmlResponseStateManagerTest.assertNotNull((Object)restoredStructure);
        HtmlResponseStateManagerTest.assertEquals((Object)"aaaStructure", (Object)restoredStructure);
        HtmlResponseStateManagerTest.assertEquals((Object)args[0], (Object)"fooStateParam");
    }

    public void testGetTreeStructureToRestore_getDecodedInServer() throws Exception {
        this.setupStateSavingInServer();
        Map requestParameterMap = this.getFacesContext().getExternalContext().getRequestParameterMap();
        requestParameterMap.put("javax.faces.ViewState", "cccServerState");
        requestParameterMap.put(AbstractResponseStateManager.VIEW_ID, "hoge");
        HtmlResponseStateManager responseStateManager = new HtmlResponseStateManager();
        HtmlResponseStateManagerTest.assertEquals((boolean)false, (boolean)responseStateManager.isSavingStateInClient((FacesContext)this.getFacesContext()));
        NullEncodeConverter converter = new NullEncodeConverter();
        responseStateManager.setEncodeConverter((EncodeConverter)converter);
        Object o = responseStateManager.getTreeStructureToRestore((FacesContext)this.getFacesContext(), "hoge");
        HtmlResponseStateManagerTest.assertNotNull((Object)o);
        HtmlResponseStateManagerTest.assertEquals((Object)"cccServerState", (Object)o);
    }

    public void testGetStructureAndStateToRestore_InClient() throws Exception {
        this.setupStateSavingInClient();
        Map requestParameterMap = this.getFacesContext().getExternalContext().getRequestParameterMap();
        requestParameterMap.put("javax.faces.ViewState", "fooStateParam");
        requestParameterMap.put(AbstractResponseStateManager.VIEW_ID, "hogeViewId");
        NullEncodeConverter converter = new NullEncodeConverter(){

            public Object getAsDecodeObject(String state) {
                return new StructureAndState((Object)"111_Structure", (Object)"222_State");
            }
        };
        HtmlResponseStateManager responseStateManager = new HtmlResponseStateManager();
        responseStateManager.setEncodeConverter((EncodeConverter)converter);
        Object restoredStructure = responseStateManager.getTreeStructureToRestore((FacesContext)this.getFacesContext(), "hogeViewId");
        Object restoredState = responseStateManager.getComponentStateToRestore((FacesContext)this.getFacesContext());
        HtmlResponseStateManagerTest.assertEquals((Object)"111_Structure", (Object)restoredStructure);
        HtmlResponseStateManagerTest.assertEquals((Object)"222_State", (Object)restoredState);
    }

    public void testWriteViewId() throws Exception {
        ResponseWriter writer = this.getFacesContext().getResponseWriter();
        HtmlResponseStateManager responseStateManager = new HtmlResponseStateManager();
        responseStateManager.writeViewId(writer, "hoge");
        Diff diff = new Diff("<input type=\"hidden\" name=\"" + AbstractResponseStateManager.VIEW_ID + "\"" + " id=\"" + AbstractResponseStateManager.VIEW_ID + "\"" + " value=\"hoge\" />", this.getResponseText());
        HtmlResponseStateManagerTest.assertEquals((String)diff.toString(), (boolean)true, (boolean)diff.identical());
    }

    private void setupStateSavingInServer() {
        this.getServletContext().setInitParameter("javax.faces.STATE_SAVING_METHOD", "server");
    }

    private void setupStateSavingInClient() {
        this.getServletContext().setInitParameter("javax.faces.STATE_SAVING_METHOD", "client");
    }

    private static class NullEncodeConverter
    implements EncodeConverter {
        public String getAsEncodeString(Object target) {
            return null;
        }

        public Object getAsDecodeObject(String state) {
            return null;
        }
    }
}

