/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.render.html;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.el.ValueBinding;
import javax.faces.render.Renderer;
import javax.faces.render.RendererTest;
import org.custommonkey.xmlunit.Diff;
import org.seasar.teeda.core.el.ELParser;
import org.seasar.teeda.core.el.ExpressionProcessor;
import org.seasar.teeda.core.el.impl.ValueBindingImpl;
import org.seasar.teeda.core.el.impl.commons.CommonsELParser;
import org.seasar.teeda.core.el.impl.commons.CommonsExpressionProcessorImpl;
import org.seasar.teeda.core.mock.MockConverter;
import org.seasar.teeda.core.mock.MockFacesContext;
import org.seasar.teeda.core.mock.MockHtmlOutputText;
import org.seasar.teeda.core.render.html.HtmlOutputTextRenderer;

public class HtmlOutputTextRendererTest
extends RendererTest {
    private HtmlOutputTextRenderer renderer;
    private MockHtmlOutputText htmlOutputText;

    protected void setUp() throws Exception {
        super.setUp();
        this.renderer = this.createHtmlOutputTextRenderer();
        this.htmlOutputText = new MockHtmlOutputText();
        this.htmlOutputText.setRenderer((Renderer)this.renderer);
    }

    public void testEncode_WithValue() throws Exception {
        this.htmlOutputText.setValue("abc");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlOutputText);
        HtmlOutputTextRendererTest.assertEquals((String)"abc", (String)this.getResponseText());
    }

    public void testEncode_RenderFalse() throws Exception {
        this.htmlOutputText.setRendered(false);
        this.htmlOutputText.setValue("abc");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlOutputText);
        HtmlOutputTextRendererTest.assertEquals((String)"", (String)this.getResponseText());
    }

    public void testEncode_NullValue() throws Exception {
        this.htmlOutputText.setValue(null);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlOutputText);
        HtmlOutputTextRendererTest.assertEquals((String)"", (String)this.getResponseText());
    }

    public void testEncode_EscapeTrue() throws Exception {
        HtmlOutputTextRendererTest.assertTrue((String)"default is true", (boolean)this.htmlOutputText.isEscape());
        this.htmlOutputText.setValue("<a>");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlOutputText);
        HtmlOutputTextRendererTest.assertEquals((String)"&lt;a&gt;", (String)this.getResponseText());
    }

    public void testEncode_EscapeFalse() throws Exception {
        this.htmlOutputText.setEscape(false);
        this.htmlOutputText.setValue("<a>");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlOutputText);
        HtmlOutputTextRendererTest.assertEquals((String)"<a>", (String)this.getResponseText());
    }

    public void testEncode_WithStyle() throws Exception {
        this.htmlOutputText.setStyle("some style");
        this.htmlOutputText.setValue("a");
        this.htmlOutputText.setEscape(false);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlOutputText);
        HtmlOutputTextRendererTest.assertEquals((String)"<span style=\"some style\">a</span>", (String)this.getResponseText());
    }

    public void testEncode_WithStyleClass() throws Exception {
        this.htmlOutputText.setStyleClass("some styleClass");
        this.htmlOutputText.setValue("a");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlOutputText);
        HtmlOutputTextRendererTest.assertEquals((String)"styleClass -> class", (String)"<span class=\"some styleClass\">a</span>", (String)this.getResponseText());
    }

    public void todo_testEncode_CommonAttributtes() throws Exception {
        this.htmlOutputText.getAttributes().put("onmouseout", "do something");
        this.htmlOutputText.getAttributes().put("title", "someTitle");
        this.htmlOutputText.setValue("a");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlOutputText);
        System.out.println(this.getResponseText());
        Diff diff = new Diff("<span title=\"someTitle\" onmouseout=\"do something\">a</span>", this.getResponseText());
        HtmlOutputTextRendererTest.assertEquals((String)diff.toString(), (boolean)true, (boolean)diff.identical());
    }

    public void testEncode_Id() throws Exception {
        this.htmlOutputText.setId("someId");
        this.htmlOutputText.setValue("a");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlOutputText);
        HtmlOutputTextRendererTest.assertEquals((String)"<span id=\"someId\">a</span>", (String)this.getResponseText());
    }

    public void testEncode_WithUnknownAttribute1() throws Exception {
        this.htmlOutputText.getAttributes().put("b", "c");
        this.htmlOutputText.setValue("a");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlOutputText);
        HtmlOutputTextRendererTest.assertEquals((String)"<span b=\"c\">a</span>", (String)this.getResponseText());
    }

    public void testEncode_WithUnknownAttribute2() throws Exception {
        this.htmlOutputText.getAttributes().put("b.c", "c");
        this.htmlOutputText.setValue("a");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlOutputText);
        HtmlOutputTextRendererTest.assertEquals((String)"a", (String)this.getResponseText());
    }

    public void testEncode_NotWriteId() throws Exception {
        this.htmlOutputText.setId("_idsomeId");
        this.htmlOutputText.setValue("a");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlOutputText);
        HtmlOutputTextRendererTest.assertEquals((String)"a", (String)this.getResponseText());
    }

    public void testEncode_WithAllAttributes() throws Exception {
        this.htmlOutputText.setId("fooId");
        this.htmlOutputText.setTitle("someTitle");
        this.htmlOutputText.setValue("a");
        this.htmlOutputText.setStyle("style");
        this.htmlOutputText.setStyleClass("styleClass");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlOutputText);
        Diff diff = new Diff("<span id=\"fooId\" title=\"someTitle\" style=\"style\" class=\"styleClass\">a</span>", this.getResponseText());
        HtmlOutputTextRendererTest.assertEquals((String)diff.toString(), (boolean)true, (boolean)diff.identical());
    }

    public void testEncode_NotRenderChild() throws Exception {
        this.htmlOutputText.setValue("abc");
        MockHtmlOutputText child = new MockHtmlOutputText();
        child.setRenderer((Renderer)this.renderer);
        child.setValue("d");
        this.htmlOutputText.getChildren().add(child);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlOutputText);
        HtmlOutputTextRendererTest.assertEquals((String)"abc", (String)this.getResponseText());
    }

    public void testEncode_Converter() throws Exception {
        MockConverter converter = new MockConverter(){

            public String getAsString(FacesContext context, UIComponent component, Object value) throws ConverterException {
                return value + "ddd";
            }
        };
        this.htmlOutputText.setValue("abc");
        this.htmlOutputText.setConverter((Converter)converter);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlOutputText);
        HtmlOutputTextRendererTest.assertEquals((String)"abcddd", (String)this.getResponseText());
    }

    public void testGetConvertedValue() throws Exception {
        MockConverter converter = new MockConverter(){

            public Object getAsObject(FacesContext context, UIComponent component, String value) throws ConverterException {
                return value + ".testGetConvertedValue";
            }
        };
        this.htmlOutputText.setConverter((Converter)converter);
        Object convertedValue = this.renderer.getConvertedValue((FacesContext)this.getFacesContext(), (UIComponent)this.htmlOutputText, (Object)"bbb");
        HtmlOutputTextRendererTest.assertEquals((Object)"bbb.testGetConvertedValue", (Object)convertedValue);
    }

    public void testGetRendersChildren() throws Exception {
        HtmlOutputTextRendererTest.assertEquals((boolean)false, (boolean)this.renderer.getRendersChildren());
    }

    public void testValueBinding() throws Exception {
        MockFacesContext context = this.getFacesContext();
        CommonsELParser parser = new CommonsELParser();
        parser.setExpressionProcessor((ExpressionProcessor)new CommonsExpressionProcessorImpl());
        ValueBindingImpl vb = new ValueBindingImpl(context.getApplication(), "#{a}", (ELParser)parser);
        this.htmlOutputText.setValueBinding("value", (ValueBinding)vb);
        context.getExternalContext().getRequestMap().put("a", "123");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlOutputText);
        HtmlOutputTextRendererTest.assertEquals((String)"123", (String)this.getResponseText());
    }

    private HtmlOutputTextRenderer createHtmlOutputTextRenderer() {
        return (HtmlOutputTextRenderer)this.createRenderer();
    }

    protected Renderer createRenderer() {
        HtmlOutputTextRenderer renderer = new HtmlOutputTextRenderer();
        renderer.setComponentIdLookupStrategy(this.getComponentIdLookupStrategy());
        return renderer;
    }
}

