/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.render.html;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import javax.faces.render.AbstractRendererTest;
import javax.faces.render.Renderer;
import javax.xml.parsers.ParserConfigurationException;
import org.custommonkey.xmlunit.Diff;
import org.seasar.teeda.core.mock.MockFacesContext;
import org.seasar.teeda.core.mock.MockHtmlCommandLink;
import org.seasar.teeda.core.mock.MockHtmlForm;
import org.seasar.teeda.core.render.html.HtmlCommandLinkRenderer;
import org.seasar.teeda.core.render.html.HtmlFormRenderer;
import org.seasar.teeda.core.unit.TestUtil;
import org.xml.sax.SAXException;

public class HtmlFormAndCommandLinkRendererTest
extends AbstractRendererTest {
    private HtmlFormRenderer formRenderer;
    private HtmlCommandLinkRenderer commandLinkRenderer;
    private MockHtmlForm htmlForm;

    protected void setUp() throws Exception {
        super.setUp();
        this.formRenderer = new HtmlFormRenderer();
        this.formRenderer.setComponentIdLookupStrategy(this.getComponentIdLookupStrategy());
        this.htmlForm = new MockHtmlForm();
        this.htmlForm.setRenderer((Renderer)this.formRenderer);
        this.htmlForm.setEnctype(null);
        this.commandLinkRenderer = new HtmlCommandLinkRenderer();
        this.commandLinkRenderer.setComponentIdLookupStrategy(this.getComponentIdLookupStrategy());
        this.formRenderer.addIgnoreAttributeName("setSubmittedCalls");
    }

    public void testEncode_WithCommandLink() throws Exception {
        MockHtmlCommandLink htmlCommandLink = new MockHtmlCommandLink();
        htmlCommandLink.setRenderer((Renderer)this.commandLinkRenderer);
        htmlCommandLink.setId("fooLink");
        this.htmlForm.setId("fooForm");
        this.htmlForm.getChildren().add(htmlCommandLink);
        MockFacesContext context = this.getFacesContext();
        context.getViewRoot().setViewId("/aa");
        this.formRenderer.encodeBegin((FacesContext)context, (UIComponent)this.htmlForm);
        this.formRenderer.encodeChildren((FacesContext)context, (UIComponent)this.htmlForm);
        this.formRenderer.encodeEnd((FacesContext)context, (UIComponent)this.htmlForm);
        System.out.println(this.getResponseText());
        String readText = TestUtil.readText(((Object)((Object)this)).getClass(), "testEncode_WithCommandLink.html", "UTF-8");
        Diff diff = this.diff(readText, this.getResponseText());
        HtmlFormAndCommandLinkRendererTest.assertEquals((String)diff.toString(), (boolean)true, (boolean)diff.identical());
    }

    public void testEncode_WithParameter() throws Exception {
        MockFacesContext context = this.getFacesContext();
        context.getViewRoot().setViewId("/aaaViewId");
        this.htmlForm.setId("fooForm");
        MockHtmlCommandLink commandLink = new MockHtmlCommandLink();
        commandLink.setRenderer((Renderer)this.commandLinkRenderer);
        UIParameter param = new UIParameter();
        param.setName("a");
        param.setValue((Object)"1");
        commandLink.getChildren().add(param);
        this.htmlForm.getChildren().add(commandLink);
        this.htmlForm.encodeBegin((FacesContext)context);
        commandLink.encodeBegin((FacesContext)context);
        commandLink.encodeChildren((FacesContext)context);
        commandLink.encodeEnd((FacesContext)context);
        this.htmlForm.encodeEnd((FacesContext)context);
        System.out.println(this.getResponseText());
        String readText = TestUtil.readText(((Object)((Object)this)).getClass(), "testEncode_WithParameter.html", "UTF-8");
        Diff diff = this.diff(readText, this.getResponseText());
        HtmlFormAndCommandLinkRendererTest.assertEquals((String)diff.toString(), (boolean)true, (boolean)diff.identical());
    }

    public void testEncode_WithParameters() throws Exception {
        MockHtmlCommandLink htmlCommandLink = new MockHtmlCommandLink();
        htmlCommandLink.setRenderer((Renderer)this.commandLinkRenderer);
        htmlCommandLink.setId("fooLink");
        this.htmlForm.setId("barForm");
        this.htmlForm.getChildren().add(htmlCommandLink);
        UIParameter param = new UIParameter();
        param.setName("x");
        param.setValue((Object)"1");
        htmlCommandLink.getChildren().add(param);
        param = new UIParameter();
        param.setName("y");
        param.setValue((Object)"2");
        htmlCommandLink.getChildren().add(param);
        MockFacesContext context = this.getFacesContext();
        context.getViewRoot().setViewId("/abc");
        this.formRenderer.encodeBegin((FacesContext)context, (UIComponent)this.htmlForm);
        this.formRenderer.encodeChildren((FacesContext)context, (UIComponent)this.htmlForm);
        this.formRenderer.encodeEnd((FacesContext)context, (UIComponent)this.htmlForm);
        System.out.println(this.getResponseText());
        String readText = TestUtil.readText(((Object)((Object)this)).getClass(), "testEncode_WithParameters.html", "UTF-8");
        Diff diff = this.diff(readText, this.getResponseText());
        HtmlFormAndCommandLinkRendererTest.assertEquals((String)diff.toString(), (boolean)true, (boolean)diff.identical());
    }

    protected Diff diff(String expected, String actual) throws SAXException, IOException, ParserConfigurationException {
        return super.diff("<dummy>" + expected + "</dummy>", "<dummy>" + actual + "</dummy>");
    }
}

