/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.render;

import java.util.Iterator;
import javax.faces.context.FacesContext;
import javax.faces.render.RenderKit;
import javax.faces.render.Renderer;
import org.seasar.teeda.core.mock.MockRenderKitImpl;
import org.seasar.teeda.core.mock.MockRenderer;
import org.seasar.teeda.core.render.RenderKitFactoryImpl;
import org.seasar.teeda.core.unit.TeedaTestCase;

public class RenderKitFactoryImplTest
extends TeedaTestCase {
    public RenderKitFactoryImplTest(String name) {
        super(name);
    }

    public void testAddRenderKit() throws Exception {
        RenderKitFactoryImpl renderKit = new RenderKitFactoryImpl();
        MockRenderKitImpl mock = new MockRenderKitImpl();
        mock.addRenderer("family", "type", (Renderer)new MockRenderer());
        renderKit.addRenderKit("id", (RenderKit)mock);
        RenderKit r = renderKit.getRenderKit((FacesContext)this.getFacesContext(), "id");
        RenderKitFactoryImplTest.assertNotNull((Object)r);
        RenderKitFactoryImplTest.assertTrue((boolean)(r instanceof MockRenderKitImpl));
        Renderer renderer = r.getRenderer("family", "type");
        RenderKitFactoryImplTest.assertNotNull((Object)renderer);
        RenderKitFactoryImplTest.assertTrue((boolean)(renderer instanceof MockRenderer));
        Iterator itr = renderKit.getRenderKitIds();
        RenderKitFactoryImplTest.assertEquals((Object)"id", itr.next());
    }

    public void testAddRenderKit_withDI() throws Exception {
        this.getContainer().register(MockRenderKitImpl.class);
        RenderKitFactoryImpl renderKit = new RenderKitFactoryImpl();
        RenderKit kit = renderKit.getRenderKit((FacesContext)this.getFacesContext(), "HTML_BASIC");
        RenderKitFactoryImplTest.assertNotNull((Object)kit);
        RenderKitFactoryImplTest.assertTrue((boolean)(kit instanceof MockRenderKitImpl));
        Iterator itr = renderKit.getRenderKitIds();
        RenderKitFactoryImplTest.assertEquals((Object)"HTML_BASIC", itr.next());
    }
}

