/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.lifecycle;

import java.io.IOException;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.seasar.teeda.core.lifecycle.LifecycleImpl;
import org.seasar.teeda.core.lifecycle.Phase;
import org.seasar.teeda.core.mock.MockFacesContext;
import org.seasar.teeda.core.unit.TeedaTestCase;
import org.seasar.teeda.core.util.ErrorPageManager;
import org.seasar.teeda.core.util.PostbackUtil;

public class LifecycleImplTest
extends TeedaTestCase {
    private LifecycleImpl lifecycle;

    public void setUpExecute_restoreAndResponseCompleteWithoutPostback() throws Exception {
        this.lifecycle = new LifecycleImpl();
        this.lifecycle.setRestoreViewPhase((Phase)new MockRestoreViewPhaseWithoutPostback());
    }

    public void testExecute_restoreAndResponseCompleteWithoutPostback() throws Exception {
        this.lifecycle.execute((FacesContext)this.getFacesContext());
        LifecycleImplTest.assertNull(this.getFacesContext().getExternalContext().getRequestMap().get("postback"));
    }

    public void setUpExecute_restoreAndResponseCompleteWithPostback() throws Exception {
        this.lifecycle = new LifecycleImpl();
        this.lifecycle.setRestoreViewPhase((Phase)new MockRestoreViewPhase());
    }

    public void testExecute_restoreAndResponseCompleteWithPostback() throws Exception {
        this.lifecycle.execute((FacesContext)this.getFacesContext());
        LifecycleImplTest.assertEquals((Object)Boolean.TRUE, this.getFacesContext().getExternalContext().getRequestMap().get("postback"));
    }

    public void setUpExecute_facesContextDI() throws Exception {
        this.lifecycle = new LifecycleImpl();
        this.lifecycle.setRestoreViewPhase((Phase)new MockRestoreViewPhase());
    }

    public void testExecute_facesContextDI() throws Exception {
        this.lifecycle.execute((FacesContext)this.getFacesContext());
        LifecycleImplTest.assertSame((Object)this.getFacesContext(), this.getExternalContext().getRequestMap().get("facesContext"));
    }

    public void setUpExecute_handleRuntimeException() throws Exception {
        this.lifecycle = new LifecycleImpl();
        this.lifecycle.setRestoreViewPhase((Phase)new MockErrorViewPhase());
    }

    public void testExecute_handleRuntimeException() throws Exception {
        this.lifecycle.setErrorPageManager(new ErrorPageManager(){

            public void addErrorPage(Class exceptionType, String location) {
            }

            public boolean handleException(Throwable exception, FacesContext context, ExternalContext extContext) throws IOException {
                return true;
            }
        });
        MockFacesContext context = this.getFacesContext();
        this.lifecycle.execute((FacesContext)context);
        LifecycleImplTest.assertTrue((boolean)context.getResponseComplete());
    }

    public void setUpRender_handleRuntimeException() throws Exception {
        this.lifecycle = new LifecycleImpl();
        this.lifecycle.setRenderResponsePhase((Phase)new MockErrorViewPhase());
    }

    public void testRender_handleRuntimeException() throws Exception {
        this.lifecycle.setErrorPageManager(new ErrorPageManager(){

            public void addErrorPage(Class exceptionType, String location) {
            }

            public boolean handleException(Throwable exception, FacesContext context, ExternalContext extContext) throws IOException {
                return true;
            }
        });
        MockFacesContext context = this.getFacesContext();
        this.lifecycle.execute((FacesContext)context);
        LifecycleImplTest.assertTrue((boolean)context.getResponseComplete());
    }

    public void testRender_noRenderWhenResponseCompleted() throws Exception {
        LifecycleImpl lifecycle = new LifecycleImpl();
        final boolean[] calls = new boolean[]{false};
        lifecycle.setRenderResponsePhase(new Phase(){

            public void execute(FacesContext context) throws FacesException {
                calls[0] = true;
            }
        });
        MockFacesContext context = this.getFacesContext();
        context.responseComplete();
        lifecycle.render((FacesContext)context);
        LifecycleImplTest.assertFalse((boolean)calls[0]);
    }

    public static class MockRestoreViewPhase
    implements Phase {
        public void execute(FacesContext context) throws FacesException {
            context.responseComplete();
            PostbackUtil.setPostback((Map)context.getExternalContext().getRequestMap(), (boolean)true);
        }
    }

    public static class MockRestoreViewPhaseWithoutPostback
    implements Phase {
        public void execute(FacesContext context) throws FacesException {
            context.responseComplete();
        }
    }

    public static class MockErrorViewPhase
    implements Phase {
        public void execute(FacesContext context) throws FacesException {
            throw new RuntimeException();
        }
    }
}

