/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.el.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import javax.faces.application.Application;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.MethodNotFoundException;
import junitx.framework.ObjectAssert;
import org.seasar.framework.exception.SRuntimeException;
import org.seasar.teeda.core.el.ELParser;
import org.seasar.teeda.core.el.ExpressionProcessor;
import org.seasar.teeda.core.el.ValueBindingBase;
import org.seasar.teeda.core.el.impl.MethodBindingImpl;
import org.seasar.teeda.core.el.impl.ValueBindingImpl;
import org.seasar.teeda.core.el.impl.commons.CommonsELParser;
import org.seasar.teeda.core.el.impl.commons.CommonsExpressionProcessorImpl;
import org.seasar.teeda.core.mock.MockFacesContext;
import org.seasar.teeda.core.mock.MockVariableResolver;
import org.seasar.teeda.core.unit.ExceptionAssert;
import org.seasar.teeda.core.unit.TeedaTestCase;

public class MethodBindingImplTest
extends TeedaTestCase {
    public void testGetType1() {
        A a = new A();
        MockVariableResolver resolver = this.getVariableResolver();
        resolver.putValue("a", (Object)a);
        CommonsELParser parser = new CommonsELParser();
        parser.setExpressionProcessor((ExpressionProcessor)new CommonsExpressionProcessorImpl());
        ValueBindingImpl vb = new ValueBindingImpl((Application)this.getApplication(), "#{a.getName}", (ELParser)parser);
        MethodBindingImpl mb = new MethodBindingImpl((ValueBindingBase)vb, new Class[0], (ELParser)parser);
        MethodBindingImplTest.assertSame((Object)String.class, (Object)mb.getType((FacesContext)this.getFacesContext()));
    }

    public void testGetType2() {
        A a = new A();
        MockVariableResolver resolver = this.getVariableResolver();
        resolver.putValue("a", (Object)a);
        CommonsELParser parser = new CommonsELParser();
        parser.setExpressionProcessor((ExpressionProcessor)new CommonsExpressionProcessorImpl());
        ValueBindingImpl vb = new ValueBindingImpl((Application)this.getApplication(), "#{a.getNum}", (ELParser)parser);
        MethodBindingImpl mb = new MethodBindingImpl((ValueBindingBase)vb, new Class[0], (ELParser)parser);
        MethodBindingImplTest.assertSame(Integer.TYPE, (Object)mb.getType((FacesContext)this.getFacesContext()));
    }

    public void testGetType3() {
        HashMap<String, A> map = new HashMap<String, A>();
        map.put("a", new A());
        MockVariableResolver resolver = this.getVariableResolver();
        resolver.putValue("m", map);
        resolver.putValue("a", (Object)new A());
        CommonsELParser parser = new CommonsELParser();
        parser.setExpressionProcessor((ExpressionProcessor)new CommonsExpressionProcessorImpl());
        ValueBindingImpl vb = new ValueBindingImpl((Application)this.getApplication(), "#{m[\"a\"].toString}", (ELParser)parser);
        MethodBindingImpl mb = new MethodBindingImpl((ValueBindingBase)vb, new Class[0], (ELParser)parser);
        MethodBindingImplTest.assertSame((Object)String.class, (Object)mb.getType((FacesContext)this.getFacesContext()));
    }

    public void testInvoke1() {
        A a = new A();
        MockVariableResolver resolver = this.getVariableResolver();
        resolver.putValue("a", (Object)a);
        CommonsELParser parser = new CommonsELParser();
        parser.setExpressionProcessor((ExpressionProcessor)new CommonsExpressionProcessorImpl());
        ValueBindingImpl vb = new ValueBindingImpl((Application)this.getApplication(), "#{a.getName}", (ELParser)parser);
        MethodBindingImpl mb = new MethodBindingImpl((ValueBindingBase)vb, new Class[0], (ELParser)parser);
        MethodBindingImplTest.assertEquals((Object)a.getName(), (Object)mb.invoke((FacesContext)this.getFacesContext(), null));
    }

    public void testInvokeThrowsEvaluationException() throws Exception {
        C c = new C();
        c.setThrowable((RuntimeException)new SRuntimeException("someMessageId"));
        MockVariableResolver resolver = this.getVariableResolver();
        resolver.putValue("c", (Object)c);
        CommonsELParser parser = new CommonsELParser();
        parser.setExpressionProcessor((ExpressionProcessor)new CommonsExpressionProcessorImpl());
        ValueBindingImpl vb = new ValueBindingImpl((Application)this.getApplication(), "#{c.execute}", (ELParser)parser);
        MethodBindingImpl mb = new MethodBindingImpl((ValueBindingBase)vb, new Class[0], (ELParser)parser);
        try {
            mb.invoke((FacesContext)this.getFacesContext(), null);
            MethodBindingImplTest.fail();
        }
        catch (EvaluationException e) {
            ExceptionAssert.assertMessageExist(e);
            Throwable cause = e.getCause();
            ObjectAssert.assertInstanceOf((Class)SRuntimeException.class, (Object)cause);
            SRuntimeException runtimeException = (SRuntimeException)cause;
            MethodBindingImplTest.assertEquals((String)"someMessageId", (String)runtimeException.getMessageCode());
        }
    }

    public void testInvokeThrowsMethodNotFoundException() throws Exception {
        A a = new A();
        MockVariableResolver resolver = this.getVariableResolver();
        resolver.putValue("a", (Object)a);
        CommonsELParser parser = new CommonsELParser();
        parser.setExpressionProcessor((ExpressionProcessor)new CommonsExpressionProcessorImpl());
        ValueBindingImpl vb = new ValueBindingImpl((Application)this.getApplication(), "#{a.wrongMethodName}", (ELParser)parser);
        MethodBindingImpl mb = new MethodBindingImpl((ValueBindingBase)vb, new Class[0], (ELParser)parser);
        try {
            mb.invoke((FacesContext)this.getFacesContext(), null);
            MethodBindingImplTest.fail();
        }
        catch (MethodNotFoundException e) {
            ExceptionAssert.assertMessageExist(e);
        }
    }

    public void testSaveAndRestoreState() throws Exception {
        A a = new A();
        a.setName("foooooo");
        this.getVariableResolver().putValue("aaa", (Object)a);
        CommonsELParser parser = new CommonsELParser();
        parser.setExpressionProcessor((ExpressionProcessor)new CommonsExpressionProcessorImpl());
        ValueBindingImpl vb = new ValueBindingImpl((Application)this.getApplication(), "#{aaa.getName}", (ELParser)parser);
        MethodBindingImpl mb1 = new MethodBindingImpl((ValueBindingBase)vb, new Class[0], (ELParser)parser);
        MockFacesContext context = this.getFacesContext();
        MethodBindingImplTest.assertEquals((Object)"foooooo", (Object)mb1.invoke((FacesContext)context, null));
        this.getContainer().register((Object)parser);
        Object state = mb1.saveState((FacesContext)context);
        MethodBindingImpl mb2 = new MethodBindingImpl();
        mb2.restoreState((FacesContext)context, state);
        MethodBindingImplTest.assertEquals((Object)"foooooo", (Object)mb2.invoke((FacesContext)context, null));
    }

    public void testNotSaveELParser() throws Exception {
        MockVariableResolver resolver = this.getVariableResolver();
        A a = new A();
        a.setNum(4);
        resolver.putValue("a", (Object)a);
        CommonsELParser parser = new CommonsELParser();
        this.getContainer().register((Object)parser);
        parser.setExpressionProcessor((ExpressionProcessor)new CommonsExpressionProcessorImpl());
        ValueBindingImpl vb = new ValueBindingImpl((Application)this.getApplication(), "#{a.getNum}", (ELParser)parser);
        MethodBindingImpl mb1 = new MethodBindingImpl((ValueBindingBase)vb, new Class[0], (ELParser)parser);
        MockFacesContext context = this.getFacesContext();
        MethodBindingImplTest.assertEquals((boolean)true, (boolean)(parser instanceof Serializable));
        Object saved = mb1.saveState((FacesContext)context);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(saved);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ObjectInputStream ois = new ObjectInputStream(bais);
        Object restored = ois.readObject();
        MethodBindingImpl mb2 = new MethodBindingImpl();
        mb2.restoreState((FacesContext)context, restored);
        MethodBindingImplTest.assertEquals((String)"#{a.getNum}", (String)mb2.getExpressionString());
        Object o = mb2.invoke((FacesContext)context, new Object[0]);
        MethodBindingImplTest.assertEquals((Object)new Integer(4), (Object)o);
    }

    public static class C {
        private RuntimeException re_;

        public void execute() {
            throw this.re_;
        }

        public void setThrowable(RuntimeException re) {
            this.re_ = re;
        }
    }

    public static class B {
        private String name_ = "bbb";

        public String getName() {
            return this.name_;
        }

        public void setName(String name) {
            this.name_ = name;
        }
    }

    public static class A {
        private String name_ = "aaa";
        private int num_ = 0;
        private B b_;

        public String getName() {
            return this.name_;
        }

        public int getNum() {
            return this.num_;
        }

        public void setName(String name) {
            this.name_ = name;
        }

        public void setNum(int num) {
            this.num_ = num;
        }

        public B getB() {
            return this.b_;
        }

        public void setB(B b) {
            this.b_ = b;
        }
    }
}

