/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.context.html;

import java.io.IOException;
import java.io.Writer;
import java.net.URLDecoder;
import java.net.URLEncoder;
import javax.faces.context.ResponseWriter;
import junit.framework.TestCase;
import org.seasar.framework.util.SPrintWriter;
import org.seasar.teeda.core.context.html.HtmlResponseWriter;
import org.seasar.teeda.core.mock.NullWriter;
import org.seasar.teeda.core.unit.ExceptionAssert;

public class HtmlResponseWriterTest
extends TestCase {
    public void testStartDocument() throws Exception {
        HtmlResponseWriter responseWriter = new HtmlResponseWriter();
        responseWriter.startDocument();
    }

    public void testEndDocument() throws Exception {
        HtmlResponseWriter responseWriter = new HtmlResponseWriter();
        responseWriter.endDocument();
    }

    public void testCloneWithWriter() throws Exception {
        HtmlResponseWriter responseWriter = new HtmlResponseWriter();
        responseWriter.setContentType("foo content type");
        responseWriter.setCharacterEncoding("bar encoding");
        NullWriter writer = new NullWriter();
        ResponseWriter newWriter = responseWriter.cloneWithWriter((Writer)writer);
        HtmlResponseWriterTest.assertEquals((boolean)true, (boolean)(newWriter instanceof HtmlResponseWriter));
        HtmlResponseWriter newResponseWriter = (HtmlResponseWriter)newWriter;
        HtmlResponseWriterTest.assertSame((Object)writer, (Object)newResponseWriter.getWriter());
        HtmlResponseWriterTest.assertEquals((String)"foo content type", (String)newResponseWriter.getContentType());
        HtmlResponseWriterTest.assertEquals((String)"bar encoding", (String)newResponseWriter.getCharacterEncoding());
    }

    public void testClose() throws Exception {
        HtmlResponseWriter responseWriter = new HtmlResponseWriter();
        final boolean[] calls = new boolean[]{false};
        NullWriter writer = new NullWriter(){

            public void close() throws IOException {
                calls[0] = true;
            }
        };
        responseWriter.setWriter((Writer)writer);
        responseWriter.close();
        HtmlResponseWriterTest.assertTrue((boolean)calls[0]);
    }

    public void testFlush() throws Exception {
        HtmlResponseWriter responseWriter = new HtmlResponseWriter();
        final boolean[] calls = new boolean[]{false};
        NullWriter writer = new NullWriter(){

            public void flush() throws IOException {
                calls[0] = true;
            }
        };
        responseWriter.setWriter((Writer)writer);
        responseWriter.flush();
        HtmlResponseWriterTest.assertFalse((boolean)calls[0]);
    }

    public void testCloneWithWriterWithNull() throws Exception {
        HtmlResponseWriter responseWriter = new HtmlResponseWriter();
        try {
            responseWriter.cloneWithWriter(null);
            HtmlResponseWriterTest.fail();
        }
        catch (NullPointerException npe) {
            String message = npe.getMessage();
            HtmlResponseWriterTest.assertTrue((message != null && 0 < message.length() ? 1 : 0) != 0);
        }
    }

    public void testStartElement() throws Exception {
        HtmlResponseWriter responseWriter = new HtmlResponseWriter();
        SPrintWriter writer = new SPrintWriter();
        responseWriter.setWriter((Writer)writer);
        responseWriter.startElement("a", null);
        String value = writer.toString();
        HtmlResponseWriterTest.assertEquals((String)"<a", (String)value);
    }

    public final void testStartElement_NameIsNull() throws Exception {
        HtmlResponseWriter responseWriter = new HtmlResponseWriter();
        try {
            responseWriter.startElement(null, null);
            HtmlResponseWriterTest.fail();
        }
        catch (NullPointerException npe) {
            String message = npe.getMessage();
            HtmlResponseWriterTest.assertNotNull((Object)message);
            HtmlResponseWriterTest.assertTrue((message.trim().length() > 0 ? 1 : 0) != 0);
        }
    }

    public void testEndElement() throws Exception {
        HtmlResponseWriter responseWriter = new HtmlResponseWriter();
        SPrintWriter writer = new SPrintWriter();
        responseWriter.setWriter((Writer)writer);
        responseWriter.startElement("span", null);
        responseWriter.endElement("span");
        String value = writer.toString();
        HtmlResponseWriterTest.assertEquals((String)"<span></span>", (String)value);
    }

    public final void testEndElement_NameIsNull() throws Exception {
        HtmlResponseWriter responseWriter = new HtmlResponseWriter();
        try {
            responseWriter.endElement(null);
            HtmlResponseWriterTest.fail();
        }
        catch (NullPointerException npe) {
            String message = npe.getMessage();
            HtmlResponseWriterTest.assertNotNull((Object)message);
            HtmlResponseWriterTest.assertTrue((message.trim().length() > 0 ? 1 : 0) != 0);
        }
    }

    public void testWrite_Chars() throws Exception {
        HtmlResponseWriter responseWriter = new HtmlResponseWriter();
        SPrintWriter writer = new SPrintWriter();
        responseWriter.setWriter((Writer)writer);
        responseWriter.write("1234<a>".toCharArray());
        String value = writer.toString();
        HtmlResponseWriterTest.assertEquals((String)"write raw characters", (String)"1234<a>", (String)value);
    }

    public void testWrite_CharsAndIndex() throws Exception {
        HtmlResponseWriter responseWriter = new HtmlResponseWriter();
        SPrintWriter writer = new SPrintWriter();
        responseWriter.setWriter((Writer)writer);
        responseWriter.write("abcdefg".toCharArray(), 3, 2);
        String value = writer.toString();
        HtmlResponseWriterTest.assertEquals((String)"de", (String)value);
    }

    public void testWrite_CharsAndIndex_NoEncoding() throws Exception {
        HtmlResponseWriter responseWriter = new HtmlResponseWriter();
        SPrintWriter writer = new SPrintWriter();
        responseWriter.setWriter((Writer)writer);
        responseWriter.write("1234<a>".toCharArray(), 3, 4);
        String value = writer.toString();
        HtmlResponseWriterTest.assertEquals((String)"write raw characters", (String)"4<a>", (String)value);
    }

    public void testWrite_Int() throws Exception {
        HtmlResponseWriter responseWriter = new HtmlResponseWriter();
        SPrintWriter writer = new SPrintWriter();
        responseWriter.setWriter((Writer)writer);
        responseWriter.write(60);
        String value = writer.toString();
        HtmlResponseWriterTest.assertEquals((String)"write raw characters", (String)"<", (String)value);
    }

    public void testWrite_String() throws Exception {
        HtmlResponseWriter responseWriter = new HtmlResponseWriter();
        SPrintWriter writer = new SPrintWriter();
        responseWriter.setWriter((Writer)writer);
        responseWriter.write("aa>");
        String value = writer.toString();
        HtmlResponseWriterTest.assertEquals((String)"write raw characters", (String)"aa>", (String)value);
    }

    public void testWrite_StringAndIndex() throws Exception {
        HtmlResponseWriter responseWriter = new HtmlResponseWriter();
        SPrintWriter writer = new SPrintWriter();
        responseWriter.setWriter((Writer)writer);
        responseWriter.write("ab><d", 1, 3);
        String value = writer.toString();
        HtmlResponseWriterTest.assertEquals((String)"write raw characters", (String)"b><", (String)value);
    }

    public void testWriteText_Object() throws Exception {
        HtmlResponseWriter responseWriter = new HtmlResponseWriter();
        SPrintWriter writer = new SPrintWriter();
        responseWriter.setWriter((Writer)writer);
        responseWriter.writeText((Object)"abc", null);
        String value = writer.toString();
        HtmlResponseWriterTest.assertEquals((String)"abc", (String)value);
    }

    public void testWriteText_Object_WithNull() throws Exception {
        HtmlResponseWriter responseWriter = new HtmlResponseWriter();
        try {
            responseWriter.writeText(null, null);
            HtmlResponseWriterTest.fail();
        }
        catch (NullPointerException npe) {
            String message = npe.getMessage();
            HtmlResponseWriterTest.assertTrue((message != null && 0 < message.length() ? 1 : 0) != 0);
        }
    }

    public void testWriteText_Object_Encoding() throws Exception {
        HtmlResponseWriter responseWriter = new HtmlResponseWriter();
        SPrintWriter writer = new SPrintWriter();
        responseWriter.setWriter((Writer)writer);
        responseWriter.writeText((Object)"<a>", null);
        String value = writer.toString();
        HtmlResponseWriterTest.assertEquals((String)"&lt;a&gt;", (String)value);
    }

    public void testWriteText_SingleQuart() throws Exception {
        HtmlResponseWriter responseWriter = new HtmlResponseWriter();
        SPrintWriter writer = new SPrintWriter();
        responseWriter.setWriter((Writer)writer);
        responseWriter.writeText((Object)"abc'def", null);
        String value = writer.toString();
        HtmlResponseWriterTest.assertEquals((String)"abc&#39;def", (String)value);
    }

    public void testWriteText_SingleQuart2() throws Exception {
        HtmlResponseWriter responseWriter = new HtmlResponseWriter();
        SPrintWriter writer = new SPrintWriter();
        responseWriter.setWriter((Writer)writer);
        responseWriter.writeText((Object)"'''''", null);
        String value = writer.toString();
        HtmlResponseWriterTest.assertEquals((String)"&#39;&#39;&#39;&#39;&#39;", (String)value);
    }

    public void testWriteText_Chars() throws Exception {
        HtmlResponseWriter responseWriter = new HtmlResponseWriter();
        SPrintWriter writer = new SPrintWriter();
        responseWriter.setWriter((Writer)writer);
        responseWriter.writeText("abcdefg".toCharArray(), 3, 2);
        String value = writer.toString();
        HtmlResponseWriterTest.assertEquals((String)"de", (String)value);
    }

    public void testWriteText_Chars_WithNull() throws Exception {
        HtmlResponseWriter responseWriter = new HtmlResponseWriter();
        try {
            responseWriter.writeText((char[])null, 0, 0);
            HtmlResponseWriterTest.fail();
        }
        catch (NullPointerException npe) {
            String message = npe.getMessage();
            HtmlResponseWriterTest.assertTrue((message != null && 0 < message.length() ? 1 : 0) != 0);
        }
    }

    public void testWriteText_Chars_Encoding() throws Exception {
        HtmlResponseWriter responseWriter = new HtmlResponseWriter();
        SPrintWriter writer = new SPrintWriter();
        responseWriter.setWriter((Writer)writer);
        responseWriter.writeText("ab\"efgh".toCharArray(), 2, 4);
        String value = writer.toString();
        HtmlResponseWriterTest.assertEquals((String)"&quot;efg", (String)value);
    }

    public void testWriteComment() throws Exception {
        HtmlResponseWriter responseWriter = new HtmlResponseWriter();
        SPrintWriter writer = new SPrintWriter();
        responseWriter.setWriter((Writer)writer);
        responseWriter.writeComment((Object)"abc");
        String value = writer.toString();
        HtmlResponseWriterTest.assertEquals((String)"<!--abc-->", (String)value);
    }

    public void testWriteCommentWithNull() throws Exception {
        HtmlResponseWriter responseWriter = new HtmlResponseWriter();
        SPrintWriter writer = new SPrintWriter();
        responseWriter.setWriter((Writer)writer);
        try {
            responseWriter.writeComment(null);
            HtmlResponseWriterTest.fail();
        }
        catch (NullPointerException npe) {
            String message = npe.getMessage();
            HtmlResponseWriterTest.assertTrue((message != null && 0 < message.length() ? 1 : 0) != 0);
        }
    }

    public void testStartElementShouldBeClosed_ByStartElement() throws Exception {
        HtmlResponseWriter responseWriter = new HtmlResponseWriter();
        SPrintWriter writer = new SPrintWriter();
        responseWriter.setWriter((Writer)writer);
        responseWriter.startElement("x", null);
        responseWriter.startElement("a", null);
        String value = writer.toString();
        HtmlResponseWriterTest.assertEquals((String)"<x><a", (String)value);
    }

    public void testStartElementShouldBeClosed_ByWriteComment() throws Exception {
        HtmlResponseWriter responseWriter = new HtmlResponseWriter();
        SPrintWriter writer = new SPrintWriter();
        responseWriter.setWriter((Writer)writer);
        responseWriter.startElement("span", null);
        responseWriter.writeComment((Object)"foo");
        String value = writer.toString();
        HtmlResponseWriterTest.assertEquals((String)"<span><!--foo-->", (String)value);
    }

    public void testStartElementShouldBeClosed_ByWriteTextCharsAndIndex() throws Exception {
        HtmlResponseWriter responseWriter = new HtmlResponseWriter();
        SPrintWriter writer = new SPrintWriter();
        responseWriter.setWriter((Writer)writer);
        responseWriter.startElement("span", null);
        responseWriter.writeText("zxcvbnm".toCharArray(), 1, 3);
        String value = writer.toString();
        HtmlResponseWriterTest.assertEquals((String)"<span>xcv", (String)value);
    }

    public void testStartElementShouldBeClosed_ByEndDocument() throws Exception {
        HtmlResponseWriter responseWriter = new HtmlResponseWriter();
        SPrintWriter writer = new SPrintWriter();
        responseWriter.setWriter((Writer)writer);
        responseWriter.startElement("span", null);
        responseWriter.endDocument();
        String value = writer.toString();
        HtmlResponseWriterTest.assertEquals((String)"<span>", (String)value);
    }

    public void testStartElementShouldBeClosed_ByClose() throws Exception {
        HtmlResponseWriter responseWriter = new HtmlResponseWriter();
        SPrintWriter writer = new SPrintWriter(){

            public void close() {
            }
        };
        responseWriter.setWriter((Writer)writer);
        responseWriter.startElement("v", null);
        responseWriter.close();
        String value = writer.toString();
        HtmlResponseWriterTest.assertEquals((String)"<v>", (String)value);
    }

    public void testStartElementShouldBeClosed_ByFlush() throws Exception {
        HtmlResponseWriter responseWriter = new HtmlResponseWriter();
        SPrintWriter writer = new SPrintWriter();
        responseWriter.setWriter((Writer)writer);
        responseWriter.startElement("r", null);
        responseWriter.flush();
        String value = writer.toString();
        HtmlResponseWriterTest.assertEquals((String)"<r>", (String)value);
    }

    public void testStartElementShouldBeClosed_ByWriteChars() throws Exception {
        HtmlResponseWriter responseWriter = new HtmlResponseWriter();
        SPrintWriter writer = new SPrintWriter();
        responseWriter.setWriter((Writer)writer);
        responseWriter.startElement("x", null);
        responseWriter.write("aa".toCharArray());
        String value = writer.toString();
        HtmlResponseWriterTest.assertEquals((String)"<x>aa", (String)value);
    }

    public void testStartElementShouldBeClosed_ByWriteCharsAndIndex() throws Exception {
        HtmlResponseWriter responseWriter = new HtmlResponseWriter();
        SPrintWriter writer = new SPrintWriter();
        responseWriter.setWriter((Writer)writer);
        responseWriter.startElement("x", null);
        responseWriter.write("aa123".toCharArray(), 0, 2);
        String value = writer.toString();
        HtmlResponseWriterTest.assertEquals((String)"<x>aa", (String)value);
    }

    public void testStartElementShouldBeClosed_ByWriteInt() throws Exception {
        HtmlResponseWriter responseWriter = new HtmlResponseWriter();
        SPrintWriter writer = new SPrintWriter();
        responseWriter.setWriter((Writer)writer);
        responseWriter.startElement("x", null);
        responseWriter.write(98);
        String value = writer.toString();
        HtmlResponseWriterTest.assertEquals((String)"<x>b", (String)value);
    }

    public void testStartElementShouldBeClosed_ByWriteString() throws Exception {
        HtmlResponseWriter responseWriter = new HtmlResponseWriter();
        SPrintWriter writer = new SPrintWriter();
        responseWriter.setWriter((Writer)writer);
        responseWriter.startElement("x", null);
        responseWriter.write("aa");
        String value = writer.toString();
        HtmlResponseWriterTest.assertEquals((String)"<x>aa", (String)value);
    }

    public void testStartElementShouldBeClosed_ByWriteStringAndIndex() throws Exception {
        HtmlResponseWriter responseWriter = new HtmlResponseWriter();
        SPrintWriter writer = new SPrintWriter();
        responseWriter.setWriter((Writer)writer);
        responseWriter.startElement("x", null);
        responseWriter.write("aa123", 0, 2);
        String value = writer.toString();
        HtmlResponseWriterTest.assertEquals((String)"<x>aa", (String)value);
    }

    public void testStartElementShouldBeClosed_ByWriteTextObject() throws Exception {
        HtmlResponseWriter responseWriter = new HtmlResponseWriter();
        SPrintWriter writer = new SPrintWriter();
        responseWriter.setWriter((Writer)writer);
        responseWriter.startElement("x", null);
        responseWriter.writeText((Object)"aa", null);
        String value = writer.toString();
        HtmlResponseWriterTest.assertEquals((String)"<x>aa", (String)value);
    }

    public void testStartElementAndWriteTextAndEndElement() throws Exception {
        HtmlResponseWriter responseWriter = new HtmlResponseWriter();
        SPrintWriter writer = new SPrintWriter();
        responseWriter.setWriter((Writer)writer);
        responseWriter.startElement("span", null);
        responseWriter.writeText((Object)"aa", null);
        responseWriter.endElement("span");
        String value = writer.toString();
        HtmlResponseWriterTest.assertEquals((String)"<span>aa</span>", (String)value);
    }

    public void testSetGetContentType() throws Exception {
        HtmlResponseWriter responseWriter = new HtmlResponseWriter();
        HtmlResponseWriterTest.assertNull((Object)responseWriter.getContentType());
        responseWriter.setContentType("some content type");
        HtmlResponseWriterTest.assertEquals((String)"some content type", (String)responseWriter.getContentType());
    }

    public void testSetGetCharacterEncoding() throws Exception {
        HtmlResponseWriter responseWriter = new HtmlResponseWriter();
        responseWriter.setCharacterEncoding("some character encoding");
        HtmlResponseWriterTest.assertEquals((String)"some character encoding", (String)responseWriter.getCharacterEncoding());
    }

    public void testWriteAttribute() throws Exception {
        HtmlResponseWriter responseWriter = new HtmlResponseWriter();
        SPrintWriter writer = new SPrintWriter();
        responseWriter.setWriter((Writer)writer);
        responseWriter.startElement("span", null);
        responseWriter.writeAttribute("a", (Object)"bb", null);
        String value = writer.toString();
        HtmlResponseWriterTest.assertEquals((String)"<span a=\"bb\"", (String)value);
    }

    public void testWriteAttribute_Escape() throws Exception {
        HtmlResponseWriter responseWriter = new HtmlResponseWriter();
        SPrintWriter writer = new SPrintWriter();
        responseWriter.setWriter((Writer)writer);
        responseWriter.startElement("span", null);
        responseWriter.writeAttribute("a", (Object)"<b>", null);
        String value = writer.toString();
        HtmlResponseWriterTest.assertEquals((String)"<span a=\"&lt;b&gt;\"", (String)value);
    }

    public void testWriteAttribute_JavaScript() throws Exception {
        HtmlResponseWriter responseWriter = new HtmlResponseWriter();
        SPrintWriter writer = new SPrintWriter();
        responseWriter.setWriter((Writer)writer);
        responseWriter.startElement("span", null);
        responseWriter.writeAttribute("aa", (Object)"javascript:document.write('<b>foo</b>');", null);
        String value = writer.toString();
        HtmlResponseWriterTest.assertEquals((String)"<span aa=\"javascript:document.write('&lt;b&gt;foo&lt;/b&gt;');\"", (String)value);
    }

    public void testWriteAttribute_NameIsNull() throws Exception {
        HtmlResponseWriter responseWriter = new HtmlResponseWriter();
        try {
            responseWriter.writeAttribute(null, (Object)"attrValue", null);
            HtmlResponseWriterTest.fail();
        }
        catch (NullPointerException npe) {
            ExceptionAssert.assertMessageExist(npe);
        }
    }

    public void testWriteAttribute_NoOpenElement() throws Exception {
        HtmlResponseWriter responseWriter = new HtmlResponseWriter();
        try {
            responseWriter.writeAttribute("attrName", (Object)"attrValue", null);
            HtmlResponseWriterTest.fail();
        }
        catch (IllegalStateException ise) {
            ExceptionAssert.assertMessageExist(ise);
        }
    }

    public void testWriteURIAttribute_NameIsNull() throws Exception {
        HtmlResponseWriter responseWriter = new HtmlResponseWriter();
        try {
            responseWriter.writeURIAttribute(null, (Object)"attrValue", null);
            HtmlResponseWriterTest.fail();
        }
        catch (NullPointerException npe) {
            ExceptionAssert.assertMessageExist(npe);
        }
    }

    public void testWriteURIAttribute_NoOpenElement() throws Exception {
        HtmlResponseWriter responseWriter = new HtmlResponseWriter();
        try {
            responseWriter.writeURIAttribute("attrName", (Object)"attrValue", null);
            HtmlResponseWriterTest.fail();
        }
        catch (IllegalStateException ise) {
            ExceptionAssert.assertMessageExist(ise);
        }
    }

    public void testWriteURIAttribute() throws Exception {
        HtmlResponseWriter responseWriter = new HtmlResponseWriter(){

            protected String encodeURIAttribute(String url) throws IOException {
                return url + "_add";
            }
        };
        SPrintWriter writer = new SPrintWriter();
        responseWriter.setWriter((Writer)writer);
        responseWriter.startElement("z", null);
        responseWriter.writeURIAttribute("aaa", (Object)"bbb", null);
        HtmlResponseWriterTest.assertEquals((String)"<z aaa=\"bbb_add\"", (String)writer.toString());
    }

    public void testWriteURIAttribute_JavaScript() throws Exception {
        HtmlResponseWriter responseWriter = new HtmlResponseWriter();
        SPrintWriter writer = new SPrintWriter();
        responseWriter.setWriter((Writer)writer);
        responseWriter.startElement("span", null);
        responseWriter.writeURIAttribute("aa", (Object)"javascript:document.write('<b>foo</b>');", null);
        String value = writer.toString();
        HtmlResponseWriterTest.assertEquals((String)"<span aa=\"javascript:document.write('&lt;b&gt;foo&lt;/b&gt;');\"", (String)value);
    }

    public void testWriteText_ScriptBody() throws Exception {
        HtmlResponseWriter responseWriter = new HtmlResponseWriter();
        SPrintWriter writer = new SPrintWriter();
        responseWriter.setWriter((Writer)writer);
        responseWriter.startElement("script", null);
        responseWriter.writeText((Object)"<>\"&", null);
        responseWriter.endElement("script");
        String value = writer.toString();
        HtmlResponseWriterTest.assertEquals((String)"script body is not escaped", (String)"<script><>\"&</script>", (String)value);
    }

    public void testWriteText_ScriptBodyUpperCase() throws Exception {
        HtmlResponseWriter responseWriter = new HtmlResponseWriter();
        SPrintWriter writer = new SPrintWriter();
        responseWriter.setWriter((Writer)writer);
        responseWriter.startElement("SCRIPT", null);
        responseWriter.writeText((Object)"<>\"&", null);
        responseWriter.endElement("SCRIPT");
        String value = writer.toString();
        HtmlResponseWriterTest.assertEquals((String)"SCRIPT body is not escaped", (String)"<SCRIPT><>\"&</SCRIPT>", (String)value);
    }

    public void testEncodeURIAttribute() throws Exception {
        HtmlResponseWriter responseWriter = new HtmlResponseWriter();
        HtmlResponseWriterTest.assertEquals((String)"url", (String)responseWriter.encodeURIAttribute("url"));
        HtmlResponseWriterTest.assertEquals((String)"/a/b.html", (String)responseWriter.encodeURIAttribute("/a/b.html"));
        HtmlResponseWriterTest.assertEquals((String)"url?a=b", (String)responseWriter.encodeURIAttribute("url?a=b"));
        HtmlResponseWriterTest.assertEquals((String)"url?a=b%3Fc=d", (String)responseWriter.encodeURIAttribute("url?a=b?c=d"));
        HtmlResponseWriterTest.assertEquals((String)"ur%25l?a=b", (String)responseWriter.encodeURIAttribute("ur%l?a=b"));
        HtmlResponseWriterTest.assertEquals((String)"url?a=b&amp;c=d", (String)responseWriter.encodeURIAttribute("url?a=b&c=d"));
        HtmlResponseWriterTest.assertEquals((String)"a?1=%20", (String)responseWriter.encodeURIAttribute("a?1= "));
        HtmlResponseWriterTest.assertEquals((String)"url?a=%E3%81%82", (String)responseWriter.encodeURIAttribute("url?a=\u3042"));
        HtmlResponseWriterTest.assertEquals((String)"%E3%81%82?a=1", (String)responseWriter.encodeURIAttribute("\u3042?a=1"));
        HtmlResponseWriterTest.assertEquals((String)"#", (String)responseWriter.encodeURIAttribute("#"));
        HtmlResponseWriterTest.assertEquals((String)"/a.html#aaa", (String)responseWriter.encodeURIAttribute("/a.html#aaa"));
        HtmlResponseWriterTest.assertEquals((String)"http://hoge.foo/bar#", (String)responseWriter.encodeURIAttribute("http://hoge.foo/bar#"));
        HtmlResponseWriterTest.assertEquals((String)"/a.html?1=2&amp;3=4#aaa", (String)responseWriter.encodeURIAttribute("/a.html?1=2&3=4#aaa"));
    }

    public void testLeaningURLEncoder() throws Exception {
        HtmlResponseWriterTest.assertEquals((String)"%3B", (String)URLEncoder.encode(";", "UTF-8"));
        HtmlResponseWriterTest.assertEquals((String)"%2F", (String)URLEncoder.encode("/", "UTF-8"));
        HtmlResponseWriterTest.assertEquals((String)"%3F", (String)URLEncoder.encode("?", "UTF-8"));
        HtmlResponseWriterTest.assertEquals((String)"%3A", (String)URLEncoder.encode(":", "UTF-8"));
        HtmlResponseWriterTest.assertEquals((String)"%40", (String)URLEncoder.encode("@", "UTF-8"));
        HtmlResponseWriterTest.assertEquals((String)"%26", (String)URLEncoder.encode("&", "UTF-8"));
        HtmlResponseWriterTest.assertEquals((String)"%3D", (String)URLEncoder.encode("=", "UTF-8"));
        HtmlResponseWriterTest.assertEquals((String)"%2B", (String)URLEncoder.encode("+", "UTF-8"));
        HtmlResponseWriterTest.assertEquals((String)"%24", (String)URLEncoder.encode("$", "UTF-8"));
        HtmlResponseWriterTest.assertEquals((String)"%2C", (String)URLEncoder.encode(",", "UTF-8"));
        HtmlResponseWriterTest.assertEquals((String)"%23", (String)URLEncoder.encode("#", "UTF-8"));
        HtmlResponseWriterTest.assertEquals((String)"-", (String)URLEncoder.encode("-", "UTF-8"));
        HtmlResponseWriterTest.assertEquals((String)"_", (String)URLEncoder.encode("_", "UTF-8"));
        HtmlResponseWriterTest.assertEquals((String)".", (String)URLEncoder.encode(".", "UTF-8"));
        HtmlResponseWriterTest.assertEquals((String)"%21", (String)URLEncoder.encode("!", "UTF-8"));
        HtmlResponseWriterTest.assertEquals((String)"%7E", (String)URLEncoder.encode("~", "UTF-8"));
        HtmlResponseWriterTest.assertEquals((String)"*", (String)URLEncoder.encode("*", "UTF-8"));
        HtmlResponseWriterTest.assertEquals((String)"%27", (String)URLEncoder.encode("'", "UTF-8"));
        HtmlResponseWriterTest.assertEquals((String)"%28", (String)URLEncoder.encode("(", "UTF-8"));
        HtmlResponseWriterTest.assertEquals((String)"%29", (String)URLEncoder.encode(")", "UTF-8"));
        HtmlResponseWriterTest.assertEquals((String)"%25", (String)URLEncoder.encode("%", "UTF-8"));
        HtmlResponseWriterTest.assertEquals((String)"%3C", (String)URLEncoder.encode("<", "UTF-8"));
        HtmlResponseWriterTest.assertEquals((String)"%3E", (String)URLEncoder.encode(">", "UTF-8"));
        HtmlResponseWriterTest.assertEquals((String)"%22", (String)URLEncoder.encode("\"", "UTF-8"));
        HtmlResponseWriterTest.assertEquals((String)"%27", (String)URLEncoder.encode("'", "UTF-8"));
        HtmlResponseWriterTest.assertEquals((String)"+", (String)URLEncoder.encode(" ", "UTF-8"));
        HtmlResponseWriterTest.assertEquals((String)"3042", (String)Integer.toHexString(12354));
        HtmlResponseWriterTest.assertEquals((String)"%E3%81%82", (String)URLEncoder.encode("\u3042", "UTF-8"));
        HtmlResponseWriterTest.assertEquals((String)"%82%A0", (String)URLEncoder.encode("\u3042", "Windows-31J"));
    }

    public void testLeaningURLDecoder() throws Exception {
        HtmlResponseWriterTest.assertEquals((String)"https://hogehoge.co.jp/test/cgi-bin/test.cgi?cmd=login", (String)URLDecoder.decode("https%3A//hogehoge.co.jp/test/cgi-bin/test.cgi%3Fcmd=login", "UTF-8"));
    }

    public void testLearningCharacter() throws Exception {
        HtmlResponseWriterTest.assertEquals((boolean)true, (boolean)Character.isLetter('A'));
        HtmlResponseWriterTest.assertEquals((boolean)true, (boolean)Character.isLetter('\u3042'));
        HtmlResponseWriterTest.assertEquals((boolean)false, (boolean)Character.isLetter('0'));
        HtmlResponseWriterTest.assertEquals((boolean)false, (boolean)Character.isLetter('\uda55'));
    }
}

